/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.properties;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ibm.ez.analysis.api.internal.Messages;
import com.ibm.ez.analysis.api.model.APIRelatedNode;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class GenericAPIRelatedSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EMPTY_STRING = "";
    private Text txtName;
    private Text txtType;
    private Text txtURL;
    private Text txtServiceProvider;
    private Label lblServiceProvider;
    private Text txtTargetName;
    private Label targetNameLbl;
    private APIRelatedNode model;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericAPIRelatedSection.class, "name.label"));
        this.txtName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtName.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericAPIRelatedSection.class, "type.label"));
        this.txtType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericAPIRelatedSection.class, "url.label"));
        this.txtURL = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtURL.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.lblServiceProvider = this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericAPIRelatedSection.class, "service.provider.label"));
        this.txtServiceProvider = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtServiceProvider.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.targetNameLbl = this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericAPIRelatedSection.class, "target.name.label"));
        this.txtTargetName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtTargetName.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            if (this.model.getName() != null) {
                this.txtName.setText(this.model.getName());
            }
            if (this.model.getType() != null) {
                this.txtType.setText(this.model.getType());
            }
            if (this.model.getUrl() != null) {
                this.txtURL.setText(this.model.getUrl());
            }
            if (this.model.isService()) {
                this.makeServiceAreaVisible(true);
                if (this.model.getServiceProvider() != null) {
                    this.txtServiceProvider.setText(this.model.getServiceProvider());
                }
                if (this.model.getTargetName() != null) {
                    this.txtTargetName.setText(this.model.getTargetName());
                }
            } else {
                this.makeServiceAreaVisible(false);
            }
        }
        this.composite.pack();
        this.composite.getParent().layout(true);
    }

    private void clearData() {
        this.txtName.setText(EMPTY_STRING);
        this.txtType.setText(EMPTY_STRING);
        this.txtURL.setText(EMPTY_STRING);
        this.txtServiceProvider.setText(EMPTY_STRING);
        this.txtTargetName.setText(EMPTY_STRING);
    }

    private void makeServiceAreaVisible(boolean visible) {
        this.txtTargetName.setVisible(visible);
        this.targetNameLbl.setVisible(visible);
        this.txtServiceProvider.setVisible(visible);
        this.lblServiceProvider.setVisible(visible);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof APIRelatedNode) {
            this.model = (APIRelatedNode)input;
        } else if (input instanceof EZEntityID) {
            EZSourceMainframeNodeIdSg sg = (EZSourceMainframeNodeIdSg)((EZEntityID)input).getSegment(EZSourceMainframeNodeIdSg.class);
            this.model = (APIRelatedNode)sg.getResNode();
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

