/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.model.impl;

import com.ibm.ez.analysis.api.internal.Messages;
import com.ibm.ez.analysis.api.model.Model;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonModel
extends Model {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(JsonModel.class);
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String PROTOCOL_KEY = "protocol";
    public static final String AUTH_KEY = "authType";
    public static final String USER_KEY = "user";
    public static final String PASW_KEY = "pasword";
    Properties settings = new Properties();

    public JsonModel(Properties prefs) {
        this.settings = prefs;
    }

    @Override
    public void fill(IProgressMonitor pmonitor) throws Throwable {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.subTask(Messages.getString(JsonModel.class, "getlist.subtask"));
        String host = this.settings.getProperty(HOST_KEY);
        String port = this.settings.getProperty(PORT_KEY);
        String proto = this.settings.getProperty(PROTOCOL_KEY);
        String authType = this.settings.getProperty(AUTH_KEY, "basic");
        String username = this.settings.getProperty(USER_KEY);
        String password = this.settings.getProperty(PASW_KEY);
        if (host == null || port == null || proto == null || authType == null || authType.equalsIgnoreCase("basic") && (username == null || password == null)) {
            throw new RuntimeException(Messages.getString(JsonModel.class, "checkPreferences.exception"));
        }
        InputStreamReader responseReader = null;
        HttpURLConnection conn = null;
        StringBuilder urlSt = new StringBuilder();
        urlSt.append(proto);
        urlSt.append("://");
        urlSt.append(host);
        urlSt.append(":");
        urlSt.append(port);
        urlSt.append("/com.ibm.etools.ad.catalog/cat/entity/retrieveEntity");
        try {
            try {
                URL url = new URL(urlSt.toString());
                conn = (HttpURLConnection)url.openConnection();
                if (authType.equalsIgnoreCase("basic")) {
                    String userpass = String.valueOf(username) + ":" + password;
                    String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
                    conn.setRequestProperty("Authorization", basicAuth);
                }
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestProperty("requester", "AD Analyze Client");
                conn.setRequestProperty("version", "1.0");
                String header = "{\"entityCriteria\": {\n \"zOSC\": {\n      \"zoscId\": [\n          \"zosConnect/apis\",\n          \"contains\"\n      ]\n  }},\t\"linkCriteria\": {}\n}";
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                conn.setRequestProperty("Content-Length", Integer.toString(header.length()));
                L.debug("before write service payload");
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                writer.write(header);
                writer.flush();
                writer.close();
                L.debug("after write service payload");
                if (conn.getResponseCode() == 200) {
                    InputStream response = conn.getInputStream();
                    responseReader = new InputStreamReader(response, Charset.forName("UTF-8"));
                    L.debug("got response from web service");
                    monitor.subTask(Messages.getString(JsonModel.class, "buildModel.subtask"));
                    this.buildModel(responseReader);
                } else {
                    L.error("error accessing web service; responseCode={}", (Object)conn.getResponseCode());
                }
            }
            catch (Throwable th) {
                L.error("error loading API model from web service", th);
                this.apiModel.clear();
                this.services.clear();
                throw th;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void buildModel(InputStreamReader responseReader) throws Throwable {
        JsonReader rdr = Json.createReader((Reader)responseReader);
        JsonObject obj = rdr.readObject();
        JsonArray results = obj.getJsonArray("results");
        L.debug("results size: {}", (Object)results.size());
        for (JsonObject result : results.getValuesAs(JsonObject.class)) {
            JsonArray v = (JsonArray)result.get((Object)"entities");
            int entitiesNo = v.size();
            L.debug("entities size: {}", (Object)entitiesNo);
            int i = 0;
            while (i < entitiesNo) {
                JsonObject entObj = v.getJsonObject(i);
                String entID = entObj.getString("entityID");
                JsonObject entDataObj = entObj.getJsonObject("entityData");
                if (entDataObj == null) {
                    throw new RuntimeException(Messages.getString(JsonModel.class, "malformedEntry.exception", new String[]{"<entityData>"}));
                }
                String apiUrl = entDataObj.getString("apiUrl");
                String apiName = entDataObj.getString("name");
                L.trace("read data for entityID={}, apiURL={} and name={}", new Object[]{entID, apiUrl, apiName});
                if (entDataObj.get((Object)"service") == null) {
                    throw new RuntimeException(Messages.getString(JsonModel.class, "malformedEntry.exception", new String[]{"<service>"}));
                }
                HashSet<String> apiServ = new HashSet<String>();
                JsonValue.ValueType val = ((JsonValue)entDataObj.get((Object)"service")).getValueType();
                switch (val) {
                    case ARRAY: {
                        JsonArray servArr = entDataObj.getJsonArray("service");
                        int servNo = servArr.size();
                        L.debug("API {} has {} services", (Object)apiUrl, (Object)servNo);
                        int j = 0;
                        while (j < servNo) {
                            JsonObject servObj = servArr.getJsonObject(j);
                            this.getData4Service(servObj, apiServ);
                            ++j;
                        }
                        break;
                    }
                    case OBJECT: {
                        L.debug("API {} has one service", (Object)apiUrl);
                        JsonObject servObj = (JsonObject)entDataObj.get((Object)"service");
                        this.getData4Service(servObj, apiServ);
                        break;
                    }
                }
                JsonObject zOSConn = entDataObj.getJsonObject("zOSC");
                if (zOSConn == null) {
                    throw new RuntimeException(Messages.getString(JsonModel.class, "malformedEntry.exception", new String[]{"<zOSC>"}));
                }
                String zOSReq = zOSConn.getString("requester");
                String zOSId = zOSConn.getString("zoscId");
                Long zOSTimest = Long.valueOf(zOSConn.getString("timestamp"));
                boolean addAPI = false;
                Map existentapi = (Map)this.apiModel.get(apiUrl);
                if (existentapi != null) {
                    Long time = (Long)existentapi.get("timestamp");
                    Date d1 = new Date(time);
                    if (d1.compareTo(new Date(zOSTimest)) < 0) {
                        addAPI = true;
                    } else {
                        L.debug("entity with id {} is newer and was kept", (Object)apiUrl);
                    }
                } else {
                    addAPI = true;
                }
                if (addAPI) {
                    HashMap<String, Object> api = new HashMap<String, Object>();
                    api.put("url", apiUrl);
                    api.put("timestamp", zOSTimest);
                    api.put("name", apiName);
                    this.apiModel.put(apiUrl, api);
                    this.apiToService.put(apiUrl, new ArrayList<String>(apiServ));
                    L.debug("added entity with id {}, requester={}, zoscId={}", new Object[]{apiUrl, zOSReq, zOSId});
                }
                ++i;
            }
            L.debug("APIs: {}", (Object)this.apiModel);
            L.debug("Services: {}", (Object)this.services);
        }
    }

    private void getData4Service(JsonObject servObj, Set<String> apiServ) {
        if (servObj != null) {
            JsonObject zOSConn = servObj.getJsonObject("zosConnect");
            if (zOSConn == null) {
                throw new RuntimeException(Messages.getString(JsonModel.class, "malformedEntry.exception", new String[]{"<zosConnect>"}));
            }
            String servUrl = zOSConn.getString("serviceURL");
            if (this.services.get(servUrl) == null) {
                String servName = zOSConn.getString("serviceName");
                String servProvider = zOSConn.getString("serviceProvider");
                String targetName = servObj.getString("entryPointName");
                Map<String, Object> s = this.newService(servName, targetName, servProvider);
                s.put("url", servUrl);
                s.put("service.provider", servProvider);
                this.services.put(servUrl, s);
            }
            apiServ.add(servUrl);
        } else {
            L.debug("service object is null!");
        }
    }
}

