/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.model.impl;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.PathUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.internal.PasswordUtils;
import com.ibm.ez.analysis.api.internal.Activator;
import com.ibm.ez.analysis.api.internal.Messages;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.IAPIFillerService;
import com.ibm.ez.analysis.api.model.Model;
import com.ibm.ez.analysis.api.model.Node;
import com.ibm.ez.analysis.api.model.impl.DummyModel;
import com.ibm.ez.analysis.api.model.impl.JsonModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiFiller
implements IAPIFillerService {
    private static final Logger L = LoggerFactory.getLogger(ApiFiller.class);
    private static final String SERVICES_KEY = "services";
    private static final String APIS_KEY = "apis";
    private static final String API_FILE_NAME = "api";
    private static final String INTERNAL_SEPARATOR = "^";
    private static final String ENTITY_SEPARATOR = "|";
    private static final String ESCAPED_INT_SEPARATOR = "\\^";
    private static final String ESCAPED_ENT_SEPARATOR = "\\|";
    private static final String SERVICES_SEPARATOR = ";";
    private static final String EMPTY_STRING = "**ez**";
    Set<ApiInterface> tree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFiller() {
        Set<ApiInterface> set = this.tree = new HashSet<ApiInterface>();
        synchronized (set) {
            this.loadSaved();
        }
    }

    private void loadSaved() {
        Model m = new Model();
        File file = new File(PathUtils.METADATA_FOLDER, API_FILE_NAME);
        Properties prop = this.readFile(file);
        if (!prop.isEmpty()) {
            String name;
            String p;
            int n;
            int n2;
            String[] stringArray;
            HashMap<String, Map<String, Object>> servObjs = new HashMap<String, Map<String, Object>>();
            String apisStr = (String)prop.get(APIS_KEY);
            String services = (String)prop.get(SERVICES_KEY);
            if (services != null && !services.isEmpty()) {
                String[] apiParts;
                stringArray = apiParts = services.split(ESCAPED_ENT_SEPARATOR);
                n2 = apiParts.length;
                n = 0;
                while (n < n2) {
                    p = stringArray[n];
                    String[] srvParts = p.split(ESCAPED_INT_SEPARATOR);
                    if (srvParts.length < 4) {
                        L.trace("wrong format for Service string: {}", (Object)p);
                    } else {
                        name = srvParts[0];
                        String targetT = srvParts[1];
                        targetT = targetT.equalsIgnoreCase(EMPTY_STRING) ? "" : targetT;
                        String targetN = srvParts[2];
                        targetN = targetN.equalsIgnoreCase(EMPTY_STRING) ? "" : targetN;
                        String url = srvParts[3];
                        Map<String, Object> srv = (Map<String, Object>)servObjs.get(name);
                        if (srv == null) {
                            srv = m.newService(name, targetN, targetT);
                            srv.put("url", url.equalsIgnoreCase(EMPTY_STRING) ? "" : url);
                            srv.put("service.provider", targetT);
                            servObjs.put(name, srv);
                        }
                    }
                    ++n;
                }
            }
            m.addServices(servObjs);
            if (apisStr != null && !apisStr.isEmpty()) {
                String[] apis;
                stringArray = apis = apisStr.split(ESCAPED_ENT_SEPARATOR);
                n2 = apis.length;
                n = 0;
                while (n < n2) {
                    p = stringArray[n];
                    String[] apiParts = p.split(ESCAPED_INT_SEPARATOR);
                    if (apiParts.length < 4) {
                        L.trace("wrong format for API string: {}", (Object)p);
                    } else {
                        String timestamp;
                        name = apiParts[0];
                        String url = apiParts[1];
                        String string = url = url.equalsIgnoreCase(EMPTY_STRING) ? "" : url;
                        if (url.isEmpty()) {
                            url = name;
                            L.warn("empty URL for API; name it will be used as key instead");
                        }
                        timestamp = (timestamp = apiParts[2]).equalsIgnoreCase(EMPTY_STRING) ? "" : timestamp;
                        Long timeLong = timestamp.isEmpty() ? null : Long.valueOf(timestamp);
                        HashMap<String, Object> api = new HashMap<String, Object>();
                        api.put("url", url);
                        api.put("timestamp", timeLong);
                        api.put("name", name.equalsIgnoreCase(EMPTY_STRING) ? "" : name);
                        String servicesStr = apiParts[3];
                        List<String> a1List = new ArrayList<String>();
                        if (servicesStr != null && !servicesStr.isEmpty()) {
                            String[] sNames = servicesStr.split(SERVICES_SEPARATOR);
                            a1List = Arrays.asList(sNames);
                            String[] stringArray2 = sNames;
                            int n3 = sNames.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String s = stringArray2[n4];
                                servObjs.remove(s);
                                ++n4;
                            }
                        }
                        m.addAPI(url, api, a1List);
                    }
                    ++n;
                }
                m.addServicesWithoutAPI(servObjs.keySet());
            }
        } else {
            L.info("no api load from file");
        }
        this.buildTree(m, (IProgressMonitor)new NullProgressMonitor());
    }

    private void buildTree(Model model, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.subTask(Messages.getString(ApiFiller.class, "build.model.taskName"));
        this.tree = new HashSet<ApiInterface>();
        if (model.getApiNames() != null) {
            for (String string : model.getApiNames()) {
                String name;
                Map<String, Object> apiModel = model.getAPI(string);
                String string2 = name = apiModel != null ? (String)apiModel.get("name") : null;
                if (name == null) {
                    name = string;
                }
                Node n = new Node(null, name, ApiInterface.Type.API, null);
                n.addInfo("url", apiModel != null ? apiModel.get("url") : null);
                n.addInfo("timestamp", apiModel != null ? apiModel.get("timestamp") : Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                this.tree.add(n);
                List<Map<String, Object>> serv = model.getServices(string);
                if (serv == null) continue;
                for (Map<String, Object> srvInfo : serv) {
                    String srvName = (String)srvInfo.get("service.name");
                    new Node(n, srvName, ApiInterface.Type.SERVICE, srvInfo);
                }
            }
        }
        if (model.getNoApiServices() != null) {
            for (Map map : model.getNoApiServices()) {
                String srvName = (String)map.get("service.name");
                Node n = new Node(null, srvName, ApiInterface.Type.SERVICE, map);
                this.tree.add(n);
            }
        }
        model.clear();
        model = null;
        monitor.setWorkRemaining(0);
    }

    @Override
    public Set<ApiInterface> getAPIs() {
        return this.tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(IProgressMonitor pmonitor) {
        if (pmonitor == null) {
            pmonitor = new NullProgressMonitor();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setWorkRemaining(100);
        monitor.setTaskName(Messages.getString(ApiFiller.class, "refresh.model.taskName"));
        Set<ApiInterface> set = this.tree;
        synchronized (set) {
            Model model = this.getModel((IProgressMonitor)monitor.newChild(60));
            this.buildTree(model, (IProgressMonitor)monitor.newChild(30));
            this.save((IProgressMonitor)monitor.newChild(10));
            monitor.setWorkRemaining(0);
        }
    }

    private Model getModel(IProgressMonitor pmonitor) {
        String useDummy = System.getProperty("useDummy");
        String jsonModelProp = System.getProperty("useAPI.json");
        if (useDummy != null && Boolean.valueOf(useDummy).booleanValue() || jsonModelProp != null && !Boolean.valueOf(jsonModelProp).booleanValue()) {
            return new DummyModel();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(ApiFiller.class, "read.model.taskName"));
        Properties prefs = this.readFromPreferences();
        JsonModel model = new JsonModel(prefs);
        try {
            model.fill((IProgressMonitor)monitor);
        }
        catch (Throwable ex) {
            L.error("Error filling JSON model", ex);
            LogUtil.displayErrorMessage((Throwable)ex, (String)Messages.getString(ApiFiller.class, "error.filling.model"), (Plugin)Activator.getDefault());
        }
        monitor.done();
        return model;
    }

    private Properties readFromPreferences() {
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.warn("Catalog web service not configured!");
            return null;
        }
        String host = srv.getString("general.webservice.catalog", "catalog.host", null, null);
        String port = srv.getString("general.webservice.catalog", "catalog.port", "9080", null);
        String proto = srv.getString("general.webservice.catalog", "catalog.protocol", null, null);
        String authType = srv.getString("general.webservice.catalog", "catalog.authentication.type", null, null);
        String user = srv.getString("general.webservice.catalog", "catalog.authentication.username", null, null);
        String pass = srv.getString("general.webservice.catalog", "catalog.authentication.password", null, null);
        pass = PasswordUtils.decrypt((String)pass);
        Properties env = new Properties();
        if (host != null) {
            env.put("host", host);
        }
        if (port != null) {
            env.put("port", port);
        }
        if (proto != null) {
            env.put("protocol", proto);
        }
        if (authType != null) {
            env.put("authType", authType);
        }
        if (user != null) {
            env.put("user", user);
        }
        if (pass != null) {
            env.put("pasword", pass);
        }
        return env;
    }

    private void save(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.subTask(Messages.getString(ApiFiller.class, "cache.model.subtask"));
        File explore = new File(PathUtils.METADATA_FOLDER, API_FILE_NAME);
        Properties prop = new Properties();
        StringBuilder strApi = new StringBuilder();
        StringBuilder strServ = new StringBuilder();
        HashSet<String> srvs = new HashSet<String>();
        block6: for (ApiInterface n : this.tree) {
            String name = n.getName();
            String url = n.getInfo() != null ? (String)n.getInfo().get("url") : null;
            ApiInterface.Type t = n.getType();
            switch (t) {
                case API: {
                    if (strApi.length() != 0) {
                        strApi.append(ENTITY_SEPARATOR);
                    }
                    strApi.append(name);
                    strApi.append(INTERNAL_SEPARATOR);
                    strApi.append(url != null && !url.isEmpty() ? url : EMPTY_STRING);
                    strApi.append(INTERNAL_SEPARATOR);
                    String time = n.getInfo() != null && n.getInfo().get("timestamp") != null ? n.getInfo().get("timestamp").toString() : null;
                    strApi.append(time != null && !time.isEmpty() ? time : EMPTY_STRING);
                    Node api = (Node)n;
                    if (api.getChildren() == null) break;
                    strApi.append(INTERNAL_SEPARATOR);
                    for (Node srv : api.getChildren()) {
                        String serviceName = srv.getName();
                        if (!srvs.contains(serviceName)) {
                            this.appendService(strServ, srvs, srv);
                        }
                        strApi.append(serviceName).append(SERVICES_SEPARATOR);
                    }
                    continue block6;
                }
                case SERVICE: {
                    if (srvs.contains(name)) {
                        L.info("service already saved: {}", (Object)name);
                        break;
                    }
                    Node serv = (Node)n;
                    this.appendService(strServ, srvs, serv);
                    break;
                }
            }
        }
        prop.put(APIS_KEY, strApi.toString());
        prop.put(SERVICES_KEY, strServ.toString());
        try {
            prop.store(new FileOutputStream(explore), "");
        }
        catch (IOException e) {
            L.error("error saving api file", (Throwable)e);
        }
        monitor.setWorkRemaining(0);
    }

    private void appendService(StringBuilder strServ, Set<String> srvs, Node serv) {
        String url;
        String targetType;
        String name = serv.getName();
        String targetN = (String)serv.getInfo().get("target");
        if (targetN == null || targetN.isEmpty()) {
            targetN = EMPTY_STRING;
            L.warn("service without target! {}", (Object)name);
        }
        if ((targetType = (String)serv.getInfo().get("service.provider")) == null || targetType.isEmpty()) {
            targetType = EMPTY_STRING;
            L.warn("service without service provider! {}", (Object)name);
        }
        if ((url = (String)serv.getInfo().get("url")) == null || url.isEmpty()) {
            url = EMPTY_STRING;
            L.warn("service without URL! {}", (Object)name);
        }
        if (strServ.length() != 0) {
            strServ.append(ENTITY_SEPARATOR);
        }
        strServ.append(name).append(INTERNAL_SEPARATOR).append(targetType).append(INTERNAL_SEPARATOR).append(targetN).append(INTERNAL_SEPARATOR).append(url);
        srvs.add(name);
    }

    private Properties readFile(File f) {
        Properties p = new Properties();
        try {
            if (f.exists()) {
                p.load(new FileInputStream(f));
            } else {
                L.debug("api file not exists");
            }
        }
        catch (IOException e) {
            L.error("could not load file {} into properties", (Object)f.getAbsolutePath(), (Object)e);
        }
        return p;
    }

    @Override
    public Collection<Node> getAPIs(Node service) {
        HashSet<Node> apis = null;
        if (this.tree != null && !this.tree.isEmpty()) {
            apis = new HashSet<Node>();
            for (ApiInterface api : this.tree) {
                List<Node> servs = ((Node)api).getChildren();
                if (servs == null || !servs.contains(service)) continue;
                apis.add((Node)api);
            }
        }
        return apis;
    }
}

