/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.model;

import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.ApiTargetType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements ApiInterface,
Comparable<Node> {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(Node.class);
    String name;
    ApiInterface.Type type;
    Map<String, Object> info;
    Node parent;
    List<Node> children = null;

    public Node(Node parent, String name, ApiInterface.Type type, Map<String, Object> info) {
        this.name = name;
        this.type = type;
        this.info = info;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ApiInterface.Type getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getInfo() {
        return this.info;
    }

    public void addChild(Node n) {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(n);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(Node o) {
        int ret = 0;
        if (o == null) {
            ret = 1;
        } else if (this.name == null) {
            ret = o.getName() == null ? 0 : -1;
        } else {
            int n = ret = o.getName() == null ? 1 : this.name.compareTo(o.getName());
        }
        if (ret == 0) {
            if (this.type == null) {
                ret = o.getType() == null ? 0 : -1;
            } else {
                int n = ret = o.getType() == null ? 1 : this.type.compareTo(o.getType());
            }
            if (ret == 0) {
                long d2;
                long d1 = this.getInfo() != null ? (Long)this.getInfo().get("timestamp") : -1L;
                long l = d2 = o.getInfo() != null ? (Long)o.getInfo().get("timestamp") : -1L;
                ret = d1 == -1L ? (d2 == -1L ? 0 : -1) : (d2 == -1L ? 1 : new Date(d1).compareTo(new Date(d2)));
            }
        }
        return ret;
    }

    public void addInfo(String key, Object value) {
        if (this.info == null) {
            this.info = new HashMap<String, Object>();
        }
        this.info.put(key, value);
    }

    public ApiTargetType getTargetType() {
        String servProvider;
        ApiTargetType targetType = null;
        if (ApiInterface.Type.SERVICE.equals((Object)this.getType()) && (servProvider = (String)this.getInfo().get("service.provider")) != null) {
            if (servProvider.toUpperCase().indexOf("CICS") > -1) {
                targetType = ApiTargetType.PROGRAM;
            } else if (servProvider.toUpperCase().indexOf("IMS") > -1) {
                targetType = ApiTargetType.IMS_TRANSACTION;
            } else {
                L.info("service provider not supported: {}", (Object)servProvider);
                targetType = ApiTargetType.UNKNOWN;
            }
        }
        return targetType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "Node [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", parent=" + this.parent + "]";
    }
}

