/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class Model {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TARGET_TYPE_KEY = "target.type";
    public static final String TARGET_KEY = "target";
    public static final String SERVICE_NAME_KEY = "service.name";
    public static final String SERVICE_PROVIDER_KEY = "service.provider";
    public static final String TIMESTAMP_KEY = "timestamp";
    public static final String URL_KEY = "url";
    public static final String NAME_KEY = "name";
    protected Map<String, Map<String, Object>> services = new HashMap<String, Map<String, Object>>();
    protected Map<String, List<String>> apiToService = new HashMap<String, List<String>>();
    protected List<String> noApiService = new ArrayList<String>();
    protected Map<String, Map<String, Object>> apiModel = new HashMap<String, Map<String, Object>>();

    public List<String> getApiNames() {
        return new ArrayList<String>(this.apiModel.keySet());
    }

    public Map<String, Object> newService(String name, String target, String serviceProvider) {
        HashMap<String, Object> srv = new HashMap<String, Object>();
        srv.put(SERVICE_NAME_KEY, name);
        srv.put(TARGET_KEY, target);
        srv.put(SERVICE_PROVIDER_KEY, serviceProvider);
        return srv;
    }

    public List<Map<String, Object>> getServices(String api) {
        ArrayList<Map<String, Object>> srv = new ArrayList<Map<String, Object>>();
        for (String sName : this.apiToService.get(api)) {
            Map<String, Object> info = this.services.get(sName);
            srv.add(info);
        }
        return srv;
    }

    public List<Map<String, Object>> getNoApiServices() {
        ArrayList<Map<String, Object>> srv = new ArrayList<Map<String, Object>>();
        for (String sName : this.noApiService) {
            Map<String, Object> info = this.services.get(sName);
            srv.add(info);
        }
        return srv;
    }

    public void addServices(Map<String, Map<String, Object>> services) {
        this.services.putAll(services);
    }

    public void addServicesWithoutAPI(Collection<String> services) {
        this.noApiService.addAll(services);
    }

    public Map<String, Object> getAPI(String apiURL) {
        return this.apiModel.get(apiURL);
    }

    public void addAPI(String url, Map<String, Object> apiDetails, List<String> apiServices) {
        this.apiModel.put(url, apiDetails);
        this.apiToService.put(url, apiServices);
    }

    public void clear() {
        this.apiModel.clear();
        this.apiToService.clear();
        this.noApiService.clear();
        this.services.clear();
    }

    public void fill(IProgressMonitor pmonitor) throws Throwable {
    }
}

