/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.model;

import com.ibm.ez.analysis.api.model.ApiInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIRelatedNode {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(APIRelatedNode.class);
    ApiInterface node;

    public APIRelatedNode(ApiInterface node) {
        this.node = node;
    }

    public boolean isService() {
        return this.node != null ? ApiInterface.Type.SERVICE.equals((Object)this.node.getType()) : false;
    }

    public String getUrl() {
        String url = "";
        if (this.node != null && this.node.getInfo() != null) {
            url = (String)this.node.getInfo().get("url");
        } else {
            L.debug("model is empty when search for URL");
        }
        return url;
    }

    public String getTargetName() {
        String targetName = "";
        if (this.node != null) {
            if (ApiInterface.Type.SERVICE.equals((Object)this.node.getType())) {
                if (this.node.getInfo() != null) {
                    targetName = (String)this.node.getInfo().get("target");
                } else {
                    L.debug("model is empty when search for targetName");
                }
            }
        } else {
            L.debug("model is null when search for targetName");
        }
        return targetName;
    }

    public String getServiceProvider() {
        String name = "";
        if (this.node != null) {
            if (ApiInterface.Type.SERVICE.equals((Object)this.node.getType())) {
                if (this.node.getInfo() != null) {
                    name = (String)this.node.getInfo().get("service.provider");
                } else {
                    L.debug("model is empty when search for serviceProvider");
                }
            }
        } else {
            L.debug("model is null when search for serviceProvider");
        }
        return name;
    }

    public String getName() {
        String s = "";
        if (this.node != null) {
            s = this.node.getName();
        } else {
            L.debug("model is empty when search for name");
        }
        return s;
    }

    public String getType() {
        String s = "";
        if (this.node != null) {
            s = this.node.getType().getName();
        } else {
            L.debug("model is empty when search for type");
        }
        return s;
    }
}

