/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.configuration.config;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.ConfigurationAdapter;
import com.ez.report.generation.common.configuration.ReportConfigurations;
import java.io.File;
import java.io.FilenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsConfigurationInterceptor
extends ConfigurationAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(ReportsConfigurationInterceptor.class);
    private static final String LOGO_PROPERTY_PATH = "reports.reportImageHeader";
    private static final String DIRECTORY_PATH_PROPERTY = "ez.meta.directory_path";
    private static final String[] LOGO_EXT = ReportConfigurations.LOGO_EXT;
    private String cachedLogoPath = null;

    ReportsConfigurationInterceptor(Configuration c) {
        super(c);
    }

    public Object getObject(String path) {
        if (path.equals(LOGO_PROPERTY_PATH)) {
            return this.getLogoPath();
        }
        return this.c.getObject(path);
    }

    public void refresh() {
        this.c.refresh();
        this.cachedLogoPath = null;
    }

    private synchronized String getLogoPath() {
        String logoPath = null;
        if (this.cachedLogoPath != null) {
            logoPath = this.cachedLogoPath;
        } else {
            try {
                String dp = (String)this.c.getObject(DIRECTORY_PATH_PROPERTY);
                if (dp != null && (logoPath = this.getLogoFile(dp)) != null) {
                    this.cachedLogoPath = logoPath;
                }
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
        return logoPath;
    }

    private String getLogoFile(String parent) {
        File pf = new File(parent);
        File[] cl = pf.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String[] stringArray = LOGO_EXT;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    String ln = name.toLowerCase();
                    if (ln.endsWith(ext)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        if (cl != null && cl.length > 0) {
            return cl[0].getAbsolutePath();
        }
        return null;
    }
}

