/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.db.createdb;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.impl.DataConnectionFactory;
import com.ez.ezdao.impl.DataOperation;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ibm.ad.db.createdb.DBPropertiesFile;
import com.ibm.ad.db.createdb.StreamConsumer;
import com.ibm.ad.internal.PasswordUtils;
import java.io.File;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2LuwCreateDBUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Db2LuwCreateDBUtils.class);
    private static final String DB_CREATEDB2_TOOL = "CreateDb2LuwDB";
    private static final int DB_UNKNOWN_STATUS = -1;
    private static final int DB_EXISTS = 0;
    private static final int DB_NOT_EXIST = 1;
    private static final int DB2LUW_TOOL_RET_CODE_SUCCESS = 0;
    private static final int DB2LUW_TOOL_RET_CODE_DB_EXISTS = -1005;
    private static final int DB2LUW_TOOL_RET_CODE_FAIL = -1;

    public static boolean createDatabase(DataConnectionFactory f, DatabaseInfo dbInfo, String createDbToolDirectory, String fullLogName) {
        boolean createDB;
        boolean ok;
        block5: {
            ok = false;
            createDB = false;
            if (dbInfo == null) {
                L.warn("createDatabase: database info was not set");
                return false;
            }
            int connStatus = Db2LuwCreateDBUtils.dbExistenceStatus(f, dbInfo);
            ok = connStatus == 0;
            boolean bl = createDB = connStatus == 1;
            if (ok || createDB) break block5;
            L.error("Cannot verify if database exists. It might be possible the cause to be related to the access to database server.");
            return false;
        }
        try {
            if (createDB) {
                ok = Db2LuwCreateDBUtils.createDatabaseByExternalTool(dbInfo, createDbToolDirectory, fullLogName);
            }
        }
        catch (Exception e) {
            L.error("Error while creating or setting up database ", (Throwable)e);
            ok = false;
        }
        return ok;
    }

    public static boolean checkDbExists(DataConnectionFactory f, DatabaseInfo dbInfo) {
        return Db2LuwCreateDBUtils.dbExistenceStatus(f, dbInfo) == 0;
    }

    public static int dbExistenceStatus(DataConnectionFactory f, DatabaseInfo dbInfo) {
        int status;
        block8: {
            status = -1;
            String sqlDatabase = dbInfo.getDatabase();
            DataOperation c = null;
            L.info("Checking if database {} exists on the system... \n", (Object)sqlDatabase);
            try {
                try {
                    c = f.create(sqlDatabase, dbInfo);
                    if (c != null) {
                        status = 0;
                        L.info("Database {} exists on the system {} \n", (Object)sqlDatabase);
                    }
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().indexOf("ERRORCODE=-4499") > -1 && e.getMessage().indexOf("SQLSTATE=08004") > -1) {
                        L.info("Database {} was not found on the system. ", (Object)sqlDatabase);
                        L.debug("Message returned when attempting to connect to database: {} \n", (Object)e.getMessage());
                        status = 1;
                    } else {
                        L.error("Could not create connection to check if {} database exists. ", (Object)sqlDatabase, (Object)e.getMessage());
                        L.debug("Exception ", (Throwable)e);
                    }
                    Db2LuwCreateDBUtils.releaseConnection(f, c);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Db2LuwCreateDBUtils.releaseConnection(f, c);
                throw throwable;
            }
            Db2LuwCreateDBUtils.releaseConnection(f, c);
        }
        return status;
    }

    private static boolean createDatabaseByExternalTool(DatabaseInfo dbInfo, String dbToolDirectory, String logName) {
        boolean ok = false;
        if (dbInfo == null) {
            L.error("Database info is null, therefore database could not be created.");
            return ok;
        }
        DBPropertiesFile propFile = new DBPropertiesFile();
        try {
            String osName;
            Properties dbProp = new Properties();
            String dbName = dbInfo.getDatabase();
            dbProp.put("NodeName", dbInfo.getNodeName());
            dbProp.put("Hostname", dbInfo.getHost());
            if (dbInfo.getPort() != null) {
                dbProp.put("Port", String.valueOf(dbInfo.getPort()));
            }
            dbProp.put("User", dbInfo.getUsername());
            dbProp.put("Spad", PasswordUtils.encrypt((String)dbInfo.getPassword()));
            dbProp.put("CreateDBName", dbInfo.getDatabase());
            dbProp.put("CreateDBAlias", dbInfo.getDatabase());
            dbProp.put("UseTLS", (Object)dbInfo.useTLS());
            propFile.setProperties(dbProp);
            String propFileName = propFile.saveProperties();
            if (logName == null || logName.isEmpty()) {
                logName = Db2LuwCreateDBUtils.generateDbToolLogName();
            }
            String toolName = (osName = System.getProperty("os.name").toLowerCase()) != null && osName.contains("win") ? DB_CREATEDB2_TOOL.concat(".exe") : DB_CREATEDB2_TOOL;
            ArrayList<String> args = new ArrayList<String>();
            String dbTool = Paths.get(dbToolDirectory, toolName).normalize().toString();
            args.add(dbTool);
            args.add("-c");
            args.add(propFileName);
            args.add("-l");
            args.add(logName);
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            pb.directory(new File(dbToolDirectory));
            L.debug("Service dir: " + pb.directory());
            L.debug("DB Create command: " + ((Object)args).toString());
            L.info("Starting to create database {}... ", (Object)dbName);
            Process p = pb.start();
            StreamConsumer sc = new StreamConsumer(p.getInputStream());
            sc.start();
            int ret = p.waitFor();
            switch (ret) {
                case 0: {
                    L.info("Database {} was created.", (Object)dbName);
                    ok = true;
                    break;
                }
                case -1005: {
                    L.error("Error when creating DB {}. It may be possible that database alias {} already exists in either the local database directory or system database directory.", (Object)dbName, (Object)dbName);
                    break;
                }
                case -1: {
                    L.error("Error when creating DB {}. \n {}", (Object)dbName, (Object)sc.getOutput());
                    break;
                }
                default: {
                    L.error("Error when creating DB {}. Check DB2 LUW Creation Tool's log. \n {}", (Object)dbName, (Object)sc.getOutput());
                    break;
                }
            }
        }
        catch (Exception e) {
            L.error("Exception while creating db", (Throwable)e);
        }
        if (!ok) {
            L.info("Please check {} file for more information.", (Object)logName);
        }
        return ok;
    }

    public static String generateDbToolLogName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String timestamp = sdf.format(new Date());
        String logName = "createDb2LuwDB_".concat(timestamp).concat(".log");
        return logName;
    }

    public static boolean checkSchemaExists(EZSourceConnection conn, String schemaName) {
        String querrySchemaExists = String.format("SELECT * FROM syscat.schemata WHERE schemaname = '%s'", schemaName);
        boolean ok = true;
        try {
            String[][] rez = conn.executeSQL(querrySchemaExists);
            ok = rez != null && rez.length > 0;
        }
        catch (RuntimeException e) {
            L.error("Error encountered when checking if database schema exists.", (Throwable)e);
            ok = false;
            throw e;
        }
        return ok;
    }

    public static void releaseConnection(DataConnectionFactory f, DataOperation c) {
        if (f != null && c != null) {
            f.destroy(c);
        }
    }
}

