/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.db.createdb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPropertiesFile {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DBPropertiesFile.class);
    private Properties properties;
    private String fileName = new String();

    public DBPropertiesFile() {
    }

    public DBPropertiesFile(Properties properties) {
        this.properties = properties;
    }

    private String generateFileName() {
        try {
            File tempFile = File.createTempFile("db2CreateDB", ".conf");
            if (tempFile != null) {
                this.fileName = tempFile.getAbsolutePath();
            }
        }
        catch (IOException e) {
            L.error("Exception when creating temporary DB properties file: " + e);
        }
        return this.fileName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void deleteFile() {
        if (this.fileName != null) {
            try {
                Files.delete(Paths.get(this.fileName, new String[0]));
            }
            catch (IOException e) {
                L.error("Exception when deleting temporary DB properties file: " + e);
            }
        }
    }

    public String saveProperties() {
        String fName = new String();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.generateFileName()));
            if (this.properties != null) {
                this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    try {
                        writer.write(key + "=" + value);
                        writer.newLine();
                    }
                    catch (IOException e) {
                        L.error("Exception when writing database properties to file: " + e);
                    }
                }));
            }
            writer.flush();
            writer.close();
            fName = this.getFileName();
        }
        catch (Exception e) {
            L.error("Exception when saving database properties to file: " + e);
        }
        return fName;
    }
}

