/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.db.createdb;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDBUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CreateDBUtils.class);

    public static String getCreateDBSqlString(ServerType dbEngine, String dbName, String storageGroup) {
        String sqlStr = "create database " + dbName;
        if (ServerType.Db2Z.equals((Object)dbEngine)) {
            if (storageGroup != null && !storageGroup.isEmpty()) {
                sqlStr = String.valueOf(sqlStr) + " STOGROUP " + storageGroup.toUpperCase();
            }
            sqlStr = String.valueOf(sqlStr) + " CCSID UNICODE";
        }
        return sqlStr;
    }

    public static boolean checkDbExistence(EZSourceConnection conn, DatabaseInfo dbInfo, String dbName) {
        boolean ok = true;
        if (dbInfo == null) {
            L.warn("no settings for database info in CCS");
            return false;
        }
        ServerType dbEngine = CreateDBUtils.getServerType(dbInfo);
        try {
            String query = CreateDBUtils.getCheckDbExistanceQuery(dbEngine, dbName);
            String[][] rez = conn.executeSQL(query);
            ok = rez != null && rez.length > 0;
        }
        catch (RuntimeException e) {
            L.error("checkDbExistence()", (Throwable)e);
            ok = false;
            throw e;
        }
        return ok;
    }

    public static ServerType getServerType(DatabaseInfo dbInfo) {
        ServerType dbEngine = ServerType.findByName((String)dbInfo.getServerType());
        if (dbEngine == null) {
            L.warn("dbEngine unknown, assume it's SqlServer");
            dbEngine = ServerType.SqlServer;
        }
        return dbEngine;
    }

    private static String getCheckDbExistanceQuery(ServerType dbengine, String dbName) {
        String sqlStr = null;
        switch (dbengine) {
            case SqlServer: {
                sqlStr = String.format("SELECT name FROM master.sys.databases WHERE name = N'%s'", dbName);
                break;
            }
            case Db2Z: {
                sqlStr = String.format("select * from sysibm.sysdatabase where name = '%s';", dbName);
                break;
            }
        }
        if (sqlStr == null) {
            throw new RuntimeException("no query for dbengine=" + dbengine.getName());
        }
        return sqlStr;
    }

    public static final String convertDbLikeValue(String value, boolean lookaround, char escapeCharacter) throws IllegalArgumentException {
        if (value != null) {
            String regexEscape = CreateDBUtils.escapeAdapt(escapeCharacter);
            value = value.replaceAll("&", "&amp");
            value = value.replaceAll(String.valueOf(regexEscape) + regexEscape, "&esch");
            value = value.replaceAll("(?<=" + regexEscape + ")[\\[]", "[[]");
            value = value.replaceAll("[%_]", String.valueOf(regexEscape) + "$0");
            if (lookaround) {
                if (!value.isEmpty()) {
                    int length = value.length();
                    if (value.charAt(0) == '*') {
                        value = "%" + value.substring(1);
                    }
                    if (value.charAt(0) == '?') {
                        value = "_" + value.substring(1);
                    }
                    if (value.charAt(length - 1) == '*' && (length == 1 || value.charAt(length - 2) != escapeCharacter)) {
                        value = String.valueOf(value.substring(0, length - 1)) + "%";
                    }
                    if (value.charAt(length - 1) == '?' && (length == 1 || value.charAt(length - 2) != escapeCharacter)) {
                        value = String.valueOf(value.substring(0, length - 1)) + "_";
                    }
                }
            } else {
                value = value.replaceAll("(?<!" + regexEscape + ")[*]", "%").replaceAll("(?<!" + regexEscape + ")[?]", "_");
            }
            value = value.replaceAll(String.valueOf(regexEscape) + "([^%_])", "$1");
            value = value.replaceAll("'", "''");
            value = value.replaceAll("&esch", regexEscape);
            value = value.replaceAll("&amp", "&");
            value = value.replaceAll("\\\\(?![%_])", "\\\\\\\\");
        }
        return value;
    }

    public static String escapeAdapt(char escapeCharacter) {
        return escapeCharacter == '\\' ? "\\\\" : "" + escapeCharacter;
    }

    public static String toFullTempTableName(ServerType serverType, String tableName) {
        String tempTable = new String();
        switch (serverType) {
            case SqlServer: {
                tempTable = "#" + tableName;
                break;
            }
            case Db2: 
            case Db2Z: {
                tempTable = "SESSION." + tableName;
                break;
            }
        }
        return tempTable;
    }

    public static String getCreateTempTableQuery(ServerType serverType, String fullTableName, String colsList) {
        String createSql = new String();
        switch (serverType) {
            case SqlServer: {
                createSql = "CREATE TABLE ".concat(fullTableName).concat(colsList);
                break;
            }
            case Db2Z: {
                createSql = " DECLARE GLOBAL TEMPORARY TABLE ".concat(fullTableName).concat(colsList).concat(" CCSID UNICODE ").concat(" ON COMMIT PRESERVE ROWS NOT LOGGED ");
                break;
            }
            case Db2: {
                createSql = " DECLARE GLOBAL TEMPORARY TABLE ".concat(fullTableName).concat(colsList).concat(" WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ");
                break;
            }
        }
        return createSql;
    }

    public static boolean isDb2Luw(String serverType) {
        return ServerType.Db2.getName().equals(serverType);
    }

    public static boolean isSqlServer(String serverType) {
        return ServerType.SqlServer.getName().equals(serverType);
    }

    public static String getSqlSeparator(ServerType dbEngine) {
        String sqlSeparator = "";
        switch (dbEngine) {
            case SqlServer: {
                sqlSeparator = "GO";
                break;
            }
            case Db2Z: {
                sqlSeparator = ";";
                break;
            }
            case Db2: {
                sqlSeparator = "@";
                break;
            }
        }
        return sqlSeparator;
    }
}

