/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.bridge;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.eclient.zkbridge.ProjectConnectionFactoryProvider;
import com.ez.ezsource.connection.DatabaseAccessType;
import com.ez.internal.utils.PreferencesUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.workspace.bridge.BridgeConfiguratorPropertiesService;
import com.ez.workspace.bridge.IBridgeConfigurator;
import com.ez.workspace.bridge.internal.Activator;
import com.ez.workspace.mu.client.ClientAdapter;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeConfiguratorPropertiesLoader
implements BridgeConfiguratorPropertiesService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(BridgeConfiguratorPropertiesLoader.class);
    public static final Integer CLIENT_APP_ID_FOR_LICENSE = 3;
    static IBridgeConfigurator configurator = new IBridgeConfigurator(){

        public Properties getConnectionProperties() {
            Properties connectionProperties = new Properties();
            L.trace("load bridge settings from preferences");
            String serverHost = null;
            String serverPort = null;
            String clientPort = null;
            String corePoolSize = null;
            String maxPoolSize = null;
            String workspacePath = null;
            String clientSID = null;
            String value = null;
            DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
            if (srv == null) {
                L.trace("bridge cannot be configured!");
                return null;
            }
            value = srv.getString("general.networking.bridge", "bridgeService.serverHost", null, null);
            String string = serverHost = value != null ? value : "";
            if (serverHost.isEmpty()) {
                L.trace("unknown serverHost. go to preferences to set the bridge server host");
            }
            String string2 = serverPort = (value = srv.getString("general.networking.bridge", "bridgeService.serverPort", null, null)) != null ? value : "";
            if (serverPort.isEmpty()) {
                L.trace("unknown serverPort. go to preferences to set the bridge server port");
            }
            PreferencesUtils.manageClientIP();
            IPreferenceStore localStore = WorkspacePrefUtils.getPreferenceStore();
            value = localStore.getString("bridgeService.clientPort");
            clientPort = value != null ? value : "";
            L.trace("clientPort used by bridge load from preferences: {}", (Object)clientPort);
            if (clientPort.isEmpty()) {
                L.trace("unknown clientPort. go to preferences to set the client port for bridge connection");
            }
            corePoolSize = "10";
            maxPoolSize = "10";
            workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            clientSID = ClientAdapter.getClient().getSID();
            boolean useJDBC = Boolean.valueOf(System.getProperty("jdbc", "true"));
            boolean useDirectJDBC = Boolean.valueOf(System.getProperty("direct_jdbc", "true"));
            if (!useDirectJDBC) {
                if (useJDBC) {
                    connectionProperties.setProperty("database.accessType", DatabaseAccessType.JDBC.name());
                } else {
                    connectionProperties.setProperty("database.accessType", DatabaseAccessType.JNI.name());
                }
            } else {
                Integer jdbcBatchSize = 1000;
                try {
                    jdbcBatchSize = Integer.parseInt(System.getProperty("jdbc.batch_size"));
                }
                catch (Exception ex) {
                    L.trace("Can't get jdbc batch size.", (Throwable)ex);
                }
                if (System.getProperty("ENABLE_ZK_PROJECTS") != null && !Boolean.parseBoolean(System.getProperty("ENABLE_ZK_PROJECTS"))) {
                    connectionProperties.setProperty("jdbc.batch_size", String.valueOf(jdbcBatchSize));
                    connectionProperties.setProperty("factoryProviderClass", "com.ez.ezsource.connection.remote.jdbc.EZSourceRemoteFactoryProvider");
                } else {
                    connectionProperties.setProperty("factoryProviderClass", ProjectConnectionFactoryProvider.class.getName());
                }
            }
            String batchSize = System.getProperty("batchSize");
            if (batchSize != null && !batchSize.isEmpty()) {
                connectionProperties.setProperty("batchSize", batchSize);
            }
            connectionProperties.setProperty("bridgeService.type", "remote");
            connectionProperties.setProperty("bridgeService.serverHost", serverHost);
            connectionProperties.setProperty("bridgeService.serverPort", serverPort);
            connectionProperties.setProperty("bridgeService.clientPort", clientPort);
            connectionProperties.setProperty("workspace", workspacePath);
            connectionProperties.setProperty("bridgeService.corePoolSize", corePoolSize);
            connectionProperties.setProperty("bridgeService.maxPoolSize", maxPoolSize);
            connectionProperties.setProperty("applicationId", CLIENT_APP_ID_FOR_LICENSE.toString());
            connectionProperties.setProperty("instanceSid", clientSID);
            connectionProperties.setProperty("dll.location", Activator.getNtlmAuthPath());
            return connectionProperties;
        }
    };

    public IBridgeConfigurator getConfigurator() {
        return configurator;
    }
}

