/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.utils;

import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.EZSourceAuthorizationConnectionException;
import com.ez.ezsource.connection.EZSourceAuthorizatonException;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.ezsource.versioning.ProjectUtils;
import com.ez.ezsource.versioning.VersioningUtils;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.MappingConstants;
import com.ez.mainframe.model.UCMDBStateCertainty;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.ModelVersion;
import com.ez.report.application.utils.SecuredObjectInputStream;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.utils.ModelReadingException;
import com.ez.report.generation.common.utils.RGB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    public static final String PLUGIN_ID = "com.ez.mainframe.reports.core";
    public static final String ICONS = "/icons/";
    public static final String GIF_EXT = ".gif";
    public static final String PNG_EXT = ".png";
    public static String userDir = System.getProperty("user.home");
    @Deprecated
    private static String userHomeFolder = System.getProperty("appType");
    @Deprecated
    private static String instName = "0";
    @Deprecated
    public static final String USER_APP_DIR = String.valueOf(userDir) + File.separator + userHomeFolder + File.separator + instName;
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final File APPLICATION_FOLDER = new File(".");
    public static final String LIB = "lib";
    public static final File LIB_FOLDER = new File(String.valueOf(APPLICATION_FOLDER.getAbsolutePath()) + File.separator + "lib");
    public static final String CONFIG_FILE_NAME = "config.jar";
    public static final String CONFIG_TEMP_PATH = String.valueOf(LIB_FOLDER.getAbsolutePath()) + File.separator + "config.jar";
    public static final File CONFIG_TEMP_FILE = new File(CONFIG_TEMP_PATH);
    public static Map myReportsMap = new HashMap();
    public static final String MYREPORTS_PROPERTIES_FILENAME = "myreports.properties";
    public static final String REPORTS_PROPERTIES_FILENAME = "reports.properties";
    public static final String REPORTS_PATH_IN_PROJECT = "/config/reports.properties";
    private static String programsCountQuery = "SELECT COUNT(AliasName) FROM Programs \tINNER JOIN ProgramAliases \t\tON Programs.ProgramID = ProgramAliases.ProgramId WHERE OccurID <> 0 \t\tand ProgramAliases.AliasType = 0 \t\tand (Programs.ProgramTypeID not in (9, 13, 14, 15, 16) )";
    @Deprecated
    public static final String ORDER_BY_PROGRAM_NAME_CLAUSE = "ORDER BY Programs.ProgramName;";
    public static final String folderQuery = "select * from pj_folder";
    public static final String filesQuery = "select * from pj_file where id_folder = ";
    public static final String RESOURCE_TYPE_PROGRAM = Messages.getString(Utils.class, "impactReports.programType");
    public static final String RESOURCE_TYPE_INCLUDE = Messages.getString(Utils.class, "impactReports.includeType");
    public static final Integer DEF_CYCLOMATIC_EASY = Integer.valueOf("10");
    public static final Integer DEF_CYCLOMATIC_MEDIUM = Integer.valueOf("50");
    public static final RGB DEF_CYCLOMATIC_EASY_COLOR = new RGB(0, 255, 0);
    public static final RGB DEF_CYCLOMATIC_MEDIUM_COLOR = new RGB(250, 196, 69);
    public static final RGB DEF_CYCLOMATIC_DIFFICULT_COLOR = new RGB(221, 0, 0);
    public static final Integer DEF_COMPLEXITY_SIMPLE = Integer.valueOf("200");
    public static final Integer DEF_COMPLEXITY_MEDIUM = Integer.valueOf("500");
    public static final RGB DEF_COMPLEXITY_SIMPLE_COLOR = new RGB(0, 255, 0);
    public static final RGB DEF_COMPLEXITY_MEDIUM_COLOR = new RGB(250, 196, 69);
    public static final RGB DEF_COMPLEXITY_COMPLEX_COLOR = new RGB(221, 0, 0);

    public static String getGraphsDirectory() {
        return com.ez.report.generation.common.utils.Utils.getGraphsDirectory();
    }

    public static AbstractReport getGeneratedReportModel(String reportFileName, String generatedFileStore, String defaultGeneratedFolder, Queue<LogMessage> messages) {
        String generatedDir;
        Properties generatedPropFile;
        block24: {
            String generatedRepsConfig = generatedFileStore;
            FileInputStream stream = null;
            generatedPropFile = null;
            generatedDir = null;
            try {
                stream = new FileInputStream(generatedRepsConfig);
                generatedPropFile = new Properties();
                generatedPropFile.load(stream);
            }
            catch (FileNotFoundException e) {
                L.error("error at loading generated report config file", (Throwable)e);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        L.warn("could not close inputstream", (Throwable)e2);
                    }
                }
                break block24;
            }
            catch (IOException e) {
                try {
                    L.error("error at loading generated report config file", (Throwable)e);
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e3) {
                            L.warn("could not close inputstream", (Throwable)e3);
                        }
                    }
                }
            }
            if (stream == null) break block24;
            try {
                stream.close();
            }
            catch (IOException e) {
                L.warn("could not close inputstream", (Throwable)e);
            }
        }
        if (generatedPropFile != null) {
            String reportValues = generatedPropFile.getProperty(reportFileName);
            String[] values = reportValues.split(",");
            if (values == null || values.length < 3) {
                L.error("Wrong values [{}] in generated.properties for report: {}", (Object)reportValues, (Object)reportFileName);
            } else if (values.length > 3) {
                generatedDir = values[3].trim();
            }
        }
        if (generatedDir == null) {
            generatedDir = defaultGeneratedFolder;
        }
        File file = new File(generatedDir.concat(reportFileName));
        AbstractReport report = null;
        try {
            report = (AbstractReport)Utils.readModel(file);
        }
        catch (ModelReadingException ex) {
            L.error("error at regenerating report with name: {}", (Object)reportFileName, (Object)ex);
            messages.add(new LogMessage(Messages.getString(Utils.class, "modelChanged.err"), 4, PLUGIN_ID, (Throwable)ex));
        }
        return report;
    }

    /*
     * Loose catch block
     */
    public static Object readModel(File fileName) throws ModelReadingException {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        Object obj = null;
        ModelReadingException except = null;
        try {
            try {
                if (fileName.exists()) {
                    fis = new FileInputStream(fileName);
                    in = new SecuredObjectInputStream(fis);
                    obj = in.readObject();
                    ModelVersion cfr_ignored_0 = (ModelVersion)obj;
                    obj = in.readObject();
                }
            }
            catch (IOException ex) {
                L.error("Error at reading model from file: {}", (Object)fileName, (Object)ex);
                except = new ModelReadingException(Messages.getString(Utils.class, "readModel.error.message"), (Throwable)ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    L.error("readModel", (Throwable)e);
                }
                if (except != null) {
                    throw except;
                }
            }
            catch (ClassNotFoundException ex) {
                L.error("read model error for file {}", (Object)fileName, (Object)ex);
                except = new ModelReadingException(Messages.getString(Utils.class, "readModel.error.message"), (Throwable)ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    L.error("readModel", (Throwable)e);
                }
                if (except != null) {
                    throw except;
                }
            }
            catch (ClassCastException ex) {
                L.error("read model error for file {}", (Object)fileName, (Object)ex);
                except = new ModelReadingException(Messages.getString(Utils.class, "readModel.error.message"), (Throwable)ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    L.error("readModel", (Throwable)e);
                }
                if (except != null) {
                    throw except;
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                L.error("readModel", (Throwable)e);
            }
            if (except != null) {
                throw except;
            }
        }
        return obj;
    }

    public static boolean hasIlegalCharacter(String name) {
        boolean res = Utils.stringContains(name, "?") || Utils.stringContains(name, "<") || Utils.stringContains(name, ">") || Utils.stringContains(name, "*") || Utils.stringContains(name, ":") || Utils.stringContains(name, "\"") || Utils.stringContains(name, "|") || Utils.stringContains(name, "/") || Utils.stringContains(name, "\\");
        return res;
    }

    private static boolean stringContains(String source, String what) {
        return source.indexOf(what) > -1;
    }

    public static void setParamsForTitle(Map<String, Object> params, String project, boolean isUCMDB, Map<String, Object> inputs) {
        com.ez.report.generation.common.utils.Utils.setParamsForTitle(params, inputs);
        params.put("title.projName", Messages.getString(Utils.class, "project.title"));
        String projectName = (String)inputs.get("project_name_for_cover_page");
        String projectValue = projectName == null ? project : projectName;
        params.put("title.projValue", projectValue);
        if (projectValue != null && isUCMDB) {
            params.put("title.appName", Messages.getString(Utils.class, "appName.title"));
        }
    }

    public static int countAvailablePrograms(String countQuery, EZSourceConnection conn) {
        if (countQuery == null) {
            return Utils.countAvailablePrograms(conn);
        }
        int count = -1;
        try {
            String[][] results = conn.executeSQL(countQuery);
            count = new Integer(results[0][0]);
        }
        catch (Exception e) {
            L.error("failed to count available programs!", (Throwable)e);
        }
        return count;
    }

    public static int countAvailablePrograms(EZSourceConnection conn) {
        int count = -1;
        try {
            String[][] results = conn.executeSQL(programsCountQuery);
            count = new Integer(results[0][0]);
        }
        catch (Exception e) {
            L.error("failed to count available programs!", (Throwable)e);
        }
        return count;
    }

    public static ObjectForSubreport makeGenericEntry(List<ObjectForSubreport> list, String exp, Object value, String parent) {
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(exp);
        obj.setExpVal(value != null ? value.toString() : null);
        obj.setParent(parent);
        list.add(obj);
        return obj;
    }

    public static String getFileName(String path) {
        path = path.substring(path.lastIndexOf("\\") + 1);
        return path;
    }

    public static String getResourceExternalizedType(Integer type) {
        switch (type) {
            case 1: {
                return Messages.getString(Utils.class, "resourceType.1");
            }
            case 2: {
                return Messages.getString(Utils.class, "resourceType.2");
            }
            case 3: {
                return Messages.getString(Utils.class, "resourceType.3");
            }
            case 4: {
                return Messages.getString(Utils.class, "resourceType.4");
            }
            case 5: {
                return Messages.getString(Utils.class, "resourceType.5");
            }
            case 6: {
                return Messages.getString(Utils.class, "resourceType.6");
            }
            case 7: {
                return Messages.getString(Utils.class, "resourceType.7");
            }
            case 8: {
                return Messages.getString(Utils.class, "resourceType.8");
            }
            case 9: {
                return Messages.getString(Utils.class, "resourceType.9");
            }
            case 10: {
                return Messages.getString(Utils.class, "resourceType.10");
            }
            case 11: {
                return Messages.getString(Utils.class, "resourceType.11");
            }
            case 12: {
                return Messages.getString(Utils.class, "resourceType.12");
            }
            case 13: {
                return Messages.getString(Utils.class, "resourceType.13");
            }
            case 14: {
                return Messages.getString(Utils.class, "resourceType.14");
            }
            case 15: {
                return Messages.getString(Utils.class, "resourceType.15");
            }
            case 16: {
                return Messages.getString(Utils.class, "resourceType.16");
            }
            case 17: {
                return Messages.getString(Utils.class, "resourceType.17");
            }
            case 18: {
                return Messages.getString(Utils.class, "resourceType.18");
            }
            case 19: {
                return Messages.getString(Utils.class, "resourceType.19");
            }
            case 20: {
                return Messages.getString(Utils.class, "resourceType.20");
            }
            case 21: {
                return Messages.getString(Utils.class, "resourceType.21");
            }
            case 22: {
                return Messages.getString(Utils.class, "resourceType.22");
            }
            case 23: {
                return Messages.getString(Utils.class, "resourceType.23");
            }
            case 24: {
                return Messages.getString(Utils.class, "resourceType.24");
            }
            case 25: {
                return Messages.getString(Utils.class, "resourceType.25");
            }
            case 26: {
                return Messages.getString(Utils.class, "resourceType.26");
            }
            case 27: {
                return Messages.getString(Utils.class, "resourceType.27");
            }
            case 28: {
                return Messages.getString(Utils.class, "resourceType.28");
            }
            case 29: {
                return Messages.getString(Utils.class, "resourceType.29");
            }
            case 30: {
                return Messages.getString(Utils.class, "resourceType.30");
            }
            case 31: {
                return Messages.getString(Utils.class, "resourceType.31");
            }
            case 32: {
                return Messages.getString(Utils.class, "resourceType.12");
            }
            case 33: {
                return Messages.getString(Utils.class, "resourceType.33");
            }
            case 34: {
                return Messages.getString(Utils.class, "resourceType.34");
            }
            case 35: {
                return Messages.getString(Utils.class, "resourceType.35");
            }
            case 36: {
                return Messages.getString(Utils.class, "resourceType.36");
            }
            case 37: {
                return Messages.getString(Utils.class, "resourceType.37");
            }
            case 38: {
                return Messages.getString(Utils.class, "resourceType.38");
            }
            case 39: {
                return Messages.getString(Utils.class, "resourceType.39");
            }
            case 40: {
                return Messages.getString(Utils.class, "resourceType.40");
            }
            case 41: {
                return Messages.getString(Utils.class, "resourceType.41");
            }
            case 42: {
                return Messages.getString(Utils.class, "resourceType.42");
            }
            case 43: {
                return Messages.getString(Utils.class, "resourceType.43");
            }
            case 44: {
                return Messages.getString(Utils.class, "resourceType.44");
            }
            case 45: {
                return Messages.getString(Utils.class, "resourceType.45");
            }
            case 46: {
                return Messages.getString(Utils.class, "resourceType.46");
            }
            case 47: {
                return Messages.getString(Utils.class, "resourceType.47");
            }
            case 48: {
                return Messages.getString(Utils.class, "resourceType.48");
            }
            case 49: {
                return Messages.getString(Utils.class, "resourceType.49");
            }
            case 50: {
                return Messages.getString(Utils.class, "resourceType.50");
            }
            case 51: {
                return Messages.getString(Utils.class, "resourceType.51");
            }
            case 52: {
                return Messages.getString(Utils.class, "resourceType.52");
            }
            case 53: {
                return Messages.getString(Utils.class, "resourceType.53");
            }
            case 54: {
                return Messages.getString(Utils.class, "resourceType.54");
            }
            case 55: {
                return Messages.getString(Utils.class, "resourceType.55");
            }
            case 56: {
                return Messages.getString(Utils.class, "resourceType.56");
            }
            case 57: {
                return Messages.getString(Utils.class, "resourceType.57");
            }
            case 58: {
                return Messages.getString(Utils.class, "resourceType.58");
            }
            case 59: {
                return Messages.getString(Utils.class, "resourceType.59");
            }
            case 60: {
                return Messages.getString(Utils.class, "resourceType.60");
            }
            case 61: {
                return Messages.getString(Utils.class, "resourceType.61");
            }
            case 62: {
                return Messages.getString(Utils.class, "resourceType.62");
            }
            case 63: {
                return Messages.getString(Utils.class, "resourceType.63");
            }
            case 64: {
                return Messages.getString(Utils.class, "resourceType.64");
            }
            case 65: {
                return Messages.getString(Utils.class, "resourceType.65");
            }
            case 66: {
                return Messages.getString(Utils.class, "resourceType.66");
            }
            case 67: {
                return Messages.getString(Utils.class, "resourceType.67");
            }
            case 68: {
                return Messages.getString(Utils.class, "resourceType.68");
            }
            case 69: {
                return Messages.getString(Utils.class, "resourceType.69");
            }
            case 70: {
                return Messages.getString(Utils.class, "resourceType.70");
            }
            case 71: {
                return Messages.getString(Utils.class, "resourceType.71");
            }
            case 72: {
                return Messages.getString(Utils.class, "resourceType.72");
            }
            case 73: {
                return Messages.getString(Utils.class, "resourceType.73");
            }
            case 74: {
                return Messages.getString(Utils.class, "resourceType.74");
            }
            case 79: {
                return Messages.getString(Utils.class, "resourceType.79");
            }
            case 81: {
                return Messages.getString(Utils.class, "resourceType.81");
            }
            case 75: {
                return Messages.getString(Utils.class, "resourceType.75");
            }
            case 76: {
                return Messages.getString(Utils.class, "resourceType.76");
            }
            case 77: {
                return Messages.getString(Utils.class, "resourceType.77");
            }
            case 78: {
                return Messages.getString(Utils.class, "resourceType.78");
            }
            case 80: {
                return Messages.getString(Utils.class, "resourceType.80");
            }
            case 82: {
                return Messages.getString(Utils.class, "resourceType.82");
            }
            case 83: {
                return Messages.getString(Utils.class, "resourceType.83");
            }
            case 84: {
                return Messages.getString(Utils.class, "resourceType.84");
            }
            case 85: {
                return Messages.getString(Utils.class, "resourceType.85");
            }
        }
        return type.toString();
    }

    public static boolean isSpecialExpression(String expression) {
        return expression.startsWith("@") && expression.endsWith("@");
    }

    public static String escapeText(String source) {
        String MARKER = "@@@@@EZLEGACY@@@@";
        source = source.replaceAll("'", "''");
        source = source.replaceAll("%", "\\\\%");
        source = source.replaceAll("_", "\\\\_");
        source = source.replaceAll("\\\\\\*", MARKER);
        source = source.replaceAll("\\*", "%");
        source = source.replaceAll(MARKER, "*");
        source = source.replaceAll("\\\\\\?", MARKER);
        source = source.replaceAll("\\?", "_");
        source = source.replaceAll(MARKER, "?");
        return source;
    }

    public static String transformExprForAccess(String expr) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < expr.length()) {
            char c = expr.charAt(i);
            if (c == '#') {
                buffer.append("[#]");
            } else if (c == '[') {
                buffer.append("[[]");
            } else if (c == '\\') {
                char nextChar = " ".charAt(0);
                String nextCharStr = null;
                if (i + 1 < expr.length()) {
                    nextChar = expr.charAt(i + 1);
                    nextCharStr = String.valueOf(nextChar).toString();
                }
                if (nextCharStr == null) {
                    nextCharStr = String.valueOf(nextChar).toString().trim();
                }
                buffer.append("[").append(nextCharStr).append("]");
                ++i;
            } else {
                buffer.append(c);
            }
            ++i;
        }
        L.debug("expr {} was transformed for access {}", (Object)expr, (Object)buffer);
        return buffer.toString();
    }

    public static String unescapeText(String source) {
        String MARKER = "@@@@@EZLEGACY@@@@";
        source = source.replaceAll("''", "'");
        source = source.replaceAll("\\\\%", MARKER);
        source = source.replaceAll("%", "\\*");
        source = source.replaceAll(MARKER, "%");
        source = source.replaceAll("\\\\_", MARKER);
        source = source.replaceAll("_", "\\?");
        source = source.replaceAll(MARKER, "_");
        return source;
    }

    public static int getOperationForAnalysis(int reportType) {
        int op = -1;
        switch (reportType) {
            case 4: {
                op = AnalysisType.EZSOURCE_EZREPORT_HALSTEAD_ANALYSIS.getOperationCode();
                break;
            }
            case 5: {
                op = AnalysisType.EZSOURCE_EZREPORT_WEIGHT_ANALYSIS.getOperationCode();
                break;
            }
            case 50: {
                op = AnalysisType.EZSOURCE_EZREPORT_CYCLOMATIC_ANALYSIS.getOperationCode();
                break;
            }
            case 51: {
                op = AnalysisType.EZSOURCE_EZREPORT_MAINTAINABILITY_ANALYSIS.getOperationCode();
                break;
            }
            case 7: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_FILES_ANALYSIS.getOperationCode();
                break;
            }
            case 8: {
                op = AnalysisType.EZSOURCE_EZREPORT_FILES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 9: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_INCLUDES_ANALYSIS.getOperationCode();
                break;
            }
            case 10: {
                op = AnalysisType.EZSOURCE_EZREPORT_INCLUDES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 11: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_IDMS_SETS_ANALYSIS.getOperationCode();
                break;
            }
            case 12: {
                op = AnalysisType.EZSOURCE_EZREPORT_IDMS_SETS_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 13: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_IDMS_RECORDS_ANALYSIS.getOperationCode();
                break;
            }
            case 14: {
                op = AnalysisType.EZSOURCE_EZREPORT_IDMS_RECORDS_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 1011: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_IDMSX_SETS_ANALYSIS.getOperationCode();
                break;
            }
            case 1012: {
                op = AnalysisType.EZSOURCE_EZREPORT_IDMSX_SETS_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 1013: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_IDMSX_RECORDS_ANALYSIS.getOperationCode();
                break;
            }
            case 1014: {
                op = AnalysisType.EZSOURCE_EZREPORT_IDMSX_RECORDS_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 100: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_SMART_TABLES_ANALYSIS.getOperationCode();
                break;
            }
            case 101: {
                op = AnalysisType.EZSOURCE_EZREPORT_SMART_TABLES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 102: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_LOGICAL_FILES_ANALYSIS.getOperationCode();
                break;
            }
            case 103: {
                op = AnalysisType.EZSOURCE_EZREPORT_LOGICAL_FILES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 104: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_SQLTABLES_ANALYSIS.getOperationCode();
                break;
            }
            case 105: {
                op = AnalysisType.EZSOURCE_EZREPORT_SQLTABLES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 106: {
                op = AnalysisType.EZSOURCE_EZREPORT_CL_PROGRAMS_VS_CL_FILES_ANALYSIS.getOperationCode();
                break;
            }
            case 107: {
                op = AnalysisType.EZSOURCE_EZREPORT_CLFILES_VS_CLPROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 108: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_SMART_SCREENS_ANALYSIS.getOperationCode();
                break;
            }
            case 109: {
                op = AnalysisType.EZSOURCE_EZREPORT_SMART_SCREENS_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 110: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_PRINTER_FILES_ANALYSIS.getOperationCode();
                break;
            }
            case 111: {
                op = AnalysisType.EZSOURCE_EZREPORT_PRINTERFILES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 112: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_MQUEUES_ANALYSIS.getOperationCode();
                break;
            }
            case 113: {
                op = AnalysisType.EZSOURCE_EZREPORT_MQUEUES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 114: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_VARIABLES_ANALYSIS.getOperationCode();
                break;
            }
            case 116: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_STRING_LITERALS_ANALYSIS.getOperationCode();
                break;
            }
            case 118: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_ADABAS_ANALYSIS.getOperationCode();
                break;
            }
            case 119: {
                op = AnalysisType.EZSOURCE_EZREPORT_ADABAS_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 120: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_DATACOM_TABLES_ANALYSIS.getOperationCode();
                break;
            }
            case 121: {
                op = AnalysisType.EZSOURCE_EZREPORT_DATACOM_TABLES_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 122: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_IMSDB_ANALYSIS.getOperationCode();
                break;
            }
            case 123: {
                op = AnalysisType.EZSOURCE_EZREPORT_IMSDB_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 124: {
                op = AnalysisType.EZSOURCE_EZREPORT_SCL_VS_FILES_ANALYSIS.getOperationCode();
                break;
            }
            case 125: {
                op = AnalysisType.EZSOURCE_EZREPORT_FILES_VS_SCL_ANALYSIS.getOperationCode();
                break;
            }
            case 16: {
                op = AnalysisType.EZSOURCE_EZREPORT_UNUSEDPROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 17: {
                op = AnalysisType.EZSOURCE_EZREPORT_UNUSEDPROCEDURES_ANALYSIS.getOperationCode();
                break;
            }
            case 21: {
                op = AnalysisType.EZSOURCE_EZREPORT_BACKWARDCHAINS_ANALYSIS.getOperationCode();
                break;
            }
            case 20: {
                op = AnalysisType.EZSOURCE_EZREPORT_FORWARDCHAINS_ANALYSIS.getOperationCode();
                break;
            }
            case 301: {
                op = AnalysisType.EZSOURCE_EZREPORT_FIELDRENAMING_ANALYSIS.getOperationCode();
                break;
            }
            case 302: {
                op = AnalysisType.EZSOURCE_EZREPORT_FIELDEXPANSION_ANALYSIS.getOperationCode();
                break;
            }
            case 303: {
                op = AnalysisType.EZSOURCE_EZREPORT_FIELDIMPACT_ANALYSIS.getOperationCode();
                break;
            }
            case 200: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMSUMMARY_ANALYSIS.getOperationCode();
                break;
            }
            case 201: {
                op = AnalysisType.EZSOURCE_EZREPORT_COMPAREPROJECTS_ANALYSIS.getOperationCode();
                break;
            }
            case 202: {
                op = AnalysisType.EZSOURCE_EZREPORT_COMPAREAPPLICATIONS_ANALYSIS.getOperationCode();
                break;
            }
            case 203: {
                op = AnalysisType.EZSOURCE_EZREPORT_APPLICATIONINVENTORY_ANALYSIS.getOperationCode();
                break;
            }
            case 204: {
                op = AnalysisType.EZSOURCE_EZREPORT_MEMBERSINVENTORY_ANALYSIS.getOperationCode();
                break;
            }
            case 205: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROJECTINVENTORY_ANALYSIS.getOperationCode();
                break;
            }
            case 206: {
                op = AnalysisType.EZSOURCE_EZREPORT_MISSINGRESOURCES_ANALYSIS.getOperationCode();
                break;
            }
            case 207: {
                op = AnalysisType.EZSOURCE_EZREPORT_DDCL_PROJECT_INVENTORY_ANALYSIS.getOperationCode();
                break;
            }
            case 208: {
                op = AnalysisType.EZSOURCE_EZREPORT_DDCL_ELEMENT_INVENTORY_ANALYSIS.getOperationCode();
                break;
            }
            case 701: {
                op = AnalysisType.EZSOURCE_EZREPORT_DATASETFLOW_ANALYSIS.getOperationCode();
                break;
            }
            case 801: {
                op = AnalysisType.EZSOURCE_EZREPORT_SHAREDRESOURCES_ANALYSIS.getOperationCode();
                break;
            }
            case 60: {
                op = AnalysisType.EZSOURCE_EZREPORT_MAINFRAME_RUNTIME_PERFORMANCE_ANALYSIS.getOperationCode();
                break;
            }
            case 126: {
                op = AnalysisType.EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_FILES_ANALYSIS.getOperationCode();
                break;
            }
            case 127: {
                op = AnalysisType.EZSOURCE_EZREPORT_FILES_VS_DDCL_ELEMENTS_ANALYSIS.getOperationCode();
                break;
            }
            case 128: {
                op = AnalysisType.EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_RECORDS_ANALYSIS.getOperationCode();
                break;
            }
            case 129: {
                op = AnalysisType.EZSOURCE_EZREPORT_RECORDS_VS_DDCL_ELEMENTS_ANALYSIS.getOperationCode();
                break;
            }
            case 130: {
                op = AnalysisType.EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_SETS_ANALYSIS.getOperationCode();
                break;
            }
            case 131: {
                op = AnalysisType.EZSOURCE_EZREPORT_SETS_VS_DDCL_ELEMENTS_ANALYSIS.getOperationCode();
                break;
            }
            case 132: {
                op = AnalysisType.EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_RECORD_GROUPS_ANALYSIS.getOperationCode();
                break;
            }
            case 133: {
                op = AnalysisType.EZSOURCE_EZREPORT_RECORD_GROUPS_VS_DDCL_ELEMENTS_ANALYSIS.getOperationCode();
                break;
            }
            case 405: {
                op = AnalysisType.EZSOURCE_EZREPORT_JOBFLOW_ANALYSIS.getOperationCode();
                break;
            }
            case 407: {
                op = AnalysisType.EZSOURCE_EZREPORT_VSAMFILE_ANALYSIS.getOperationCode();
                break;
            }
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 501: 
            case 511: 
            case 601: 
            case 602: {
                op = -1;
                break;
            }
            case 22: {
                op = AnalysisType.EZSOURCE_EZREPORT_SQLBACKWARDCHAINS_ANALYSIS.getOperationCode();
                break;
            }
            case 901: {
                op = AnalysisType.EZSOURCE_EZREPORT_RULE_BASED_ANALYSIS.getOperationCode();
                break;
            }
            case 134: {
                op = AnalysisType.EZSOURCE_EZREPORT_JOBS_VS_SQLTABLES_ANALYSIS.getOperationCode();
                break;
            }
            case 135: {
                op = AnalysisType.EZSOURCE_EZREPORT_SQLTABLES_VS_JOBS_ANALYSIS.getOperationCode();
                break;
            }
            case 136: {
                op = AnalysisType.EZSOURCE_EZREPORT_JOBS_VS_DATASETS_ANALYSIS.getOperationCode();
                break;
            }
            case 137: {
                op = AnalysisType.EZSOURCE_EZREPORT_DATASETS_VS_JOBS_ANALYSIS.getOperationCode();
                break;
            }
            case 18: {
                op = AnalysisType.EZSOURCE_EZREPORT_UNUSEDDDCLELEMENTS_ANALYSIS.getOperationCode();
                break;
            }
            case 24: {
                op = AnalysisType.EZSOURCE_DDCLBackwardChainsReport_ANALYSIS.getOperationCode();
                break;
            }
            case 23: {
                op = AnalysisType.EZSOURCE_DDCLForwardChainsReport_ANALYSIS.getOperationCode();
                break;
            }
            case 138: {
                op = AnalysisType.EZSOURCE_EZREPORT_PROGRAMS_VS_DAL_ANALYSIS.getOperationCode();
                break;
            }
            case 139: {
                op = AnalysisType.EZSOURCE_EZREPORT_DAL_VS_PROGRAMS_ANALYSIS.getOperationCode();
                break;
            }
            case 952: {
                op = AnalysisType.EZSOURCE_JOBVSNETWORK_REPORT_ANALYSIS.getOperationCode();
                break;
            }
            case 951: {
                op = AnalysisType.EZSOURCE_NETWORKVSJOB_REPORT_ANALYSIS.getOperationCode();
            }
        }
        return op;
    }

    public static boolean openProject(String prjName, IProgressMonitor pmonitor, Queue<LogMessage> messages) {
        Display display;
        boolean err = true;
        ProjectUtils.VersioningCodes opened = ProjectUtils.VersioningCodes.NO_ERROR;
        try {
            opened = ProjectUtils.openProject((IProgressMonitor)pmonitor, (String)prjName, (ApplicationType)ApplicationType.EZViewer);
        }
        catch (EZSourceAuthorizationConnectionException e) {
            L.error("error at opening of project {}", (Object)prjName, (Object)e);
            display = Display.getDefault();
            L.debug("calling async to show the dialog");
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(null, "", null, MappingConstants.NO_CONNECTION_TO_LICENSE_MSG, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.setBlockOnOpen(true);
                    L.debug("opening message dialog");
                    dialog.open();
                    L.debug("return from open message dialog");
                }
            });
            err = false;
        }
        catch (EZSourceAuthorizatonException e) {
            L.error("error at opening of project {}", (Object)prjName, (Object)e);
            display = Display.getDefault();
            L.debug("calling async to show the dialog");
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(null, "", null, MappingConstants.LICENSE_OPERATION_DENIED_MSG, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.setBlockOnOpen(true);
                    L.debug("opening message dialog");
                    dialog.open();
                    L.debug("return from open message dialog");
                }
            });
            err = false;
        }
        catch (EZSourceConnectionException e) {
            L.error("error at opening of project {}", (Object)prjName, (Object)e);
            if (e instanceof EZSourceNativeException && ((EZSourceNativeException)e).getErrorCode() == 1) {
                display = Display.getDefault();
                L.debug("calling async to show the dialog");
                final String msg = Messages.getString(Utils.class, "locked.prj.msg", new String[]{prjName});
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dialog = new MessageDialog(null, Messages.getString(Utils.class, "eznotif.title"), null, msg, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.setBlockOnOpen(true);
                        L.debug("opening message dialog");
                        dialog.open();
                        L.debug("return from open message dialog");
                    }
                });
            } else {
                messages.add(new LogMessage(Messages.getString(Utils.class, "projectNotOpened.errorView.message", new String[]{prjName}), 4, PLUGIN_ID, (Throwable)e));
            }
            err = false;
        }
        Object[] params = new String[]{prjName};
        switch (opened) {
            case APPLICATION_OBSOLETE_ERROR: {
                messages.add(new LogMessage(Messages.getString(Utils.class, "application.obsolete"), 4, PLUGIN_ID, null));
                err = false;
            }
            case PROJECT_FILE_NOT_FOUND_ERROR: {
                String strMessage = Messages.getString(Utils.class, "errorReadingPrjFile.dialog.text", params);
                messages.add(new LogMessage(strMessage, 4, PLUGIN_ID, null));
                err = false;
            }
            case PROJECT_WITHOUT_TYPE_DEFINITION_ERROR: {
                String strMessage = Messages.getString(Utils.class, "noDefitionProject.log.text", params);
                messages.add(new LogMessage(strMessage, 4, PLUGIN_ID, null));
                err = false;
            }
            case DATABASE_NEEDS_UPGRADE_ERROR: {
                params = new String[]{prjName, String.valueOf("8.7.122.3")};
                String strMessage = Messages.getString(Utils.class, "databaseNeedsUpgrade.error", params);
                messages.add(new LogMessage(strMessage, 4, PLUGIN_ID, null));
                err = false;
            }
        }
        return err;
    }

    public static boolean lockProject(EZSourceConnection conn) {
        boolean ret = VersioningUtils.acquireLock((EZSourceConnection)conn, (LockType)LockType.Shared);
        return ret;
    }

    public static String getExternalizedType4Library(Integer type) {
        switch (type) {
            case 12: {
                return Messages.getString(Utils.class, "libType.12");
            }
            case 13: {
                return Messages.getString(Utils.class, "libType.13");
            }
            case 14: {
                return Messages.getString(Utils.class, "libType.14");
            }
            case 15: {
                return Messages.getString(Utils.class, "libType.15");
            }
            case 16: {
                return Messages.getString(Utils.class, "libType.16");
            }
            case 17: {
                return Messages.getString(Utils.class, "libType.17");
            }
        }
        return type.toString();
    }

    public static Integer getIntegerLibType(String typeAsString) {
        Integer type = null;
        if (typeAsString.equalsIgnoreCase("UNDEF")) {
            type = 12;
        }
        if (typeAsString.equalsIgnoreCase("PDS(MVS)")) {
            type = 13;
        }
        if (typeAsString.equalsIgnoreCase("Endevor")) {
            type = 14;
        }
        if (typeAsString.equalsIgnoreCase("PDS(MVS)_CONTROLM")) {
            type = 15;
        }
        if (typeAsString.equalsIgnoreCase("NATURAL")) {
            type = 16;
        }
        if (typeAsString.equalsIgnoreCase("LIBRARIAN")) {
            type = 17;
        }
        return type;
    }

    @Deprecated
    public static List<ProjectInfo> getUCMDBProjects(SubMonitor monitor, EZSourceConnection bridge) {
        String[] projects = null;
        projects = bridge.getProjects();
        int len = projects.length;
        int delta = 9000 / len;
        if (delta < 1) {
            delta = 1;
        }
        ArrayList<ProjectInfo> ret = new ArrayList<ProjectInfo>();
        int i = 0;
        while (i < projects.length) {
            ProjectInfo info;
            UCMDBStateCertainty isUCMDB;
            block16: {
                HashMap<String, String> opMap;
                EZSourceConnection javaBridge;
                block14: {
                    javaBridge = bridge;
                    isUCMDB = UCMDBStateCertainty.NOT_UCMDB;
                    String prjName = projects[i];
                    opMap = new HashMap<String, String>();
                    opMap.put("Project Name", prjName);
                    try {
                        try {
                            javaBridge.setCurrentOperation(1000, opMap);
                            javaBridge.openProject(prjName);
                        }
                        catch (EZSourceNativeException eZSourceNativeException) {
                            L.error("Cannot open project {}", (Object)projects[i]);
                            javaBridge.unsetCurrentOperation(opMap);
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        javaBridge.unsetCurrentOperation(opMap);
                        throw throwable;
                    }
                    javaBridge.unsetCurrentOperation(opMap);
                }
                info = javaBridge.getProjectInfo();
                if (info != null) {
                    isUCMDB = javaBridge.getProjectInfo().isUMCDB() ? UCMDBStateCertainty.IS_UCMDB : UCMDBStateCertainty.NOT_UCMDB;
                }
                try {
                    try {
                        javaBridge.setCurrentOperation(1001, opMap);
                        javaBridge.closeProject();
                    }
                    catch (EZSourceNativeException eZSourceNativeException) {
                        L.error("Cannot close project {}", (Object)projects[i]);
                        javaBridge.unsetCurrentOperation(opMap);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    javaBridge.unsetCurrentOperation(opMap);
                    throw throwable;
                }
                javaBridge.unsetCurrentOperation(opMap);
            }
            if (isUCMDB.equals((Object)UCMDBStateCertainty.IS_UCMDB)) {
                ret.add(info);
            }
            if (monitor != null) {
                monitor.worked(delta);
            }
            ++i;
        }
        return ret;
    }

    public static String getExternalizedShortType4DDCLComponent(Integer idType) {
        String desc = null;
        switch (idType) {
            case 25: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.25");
                break;
            }
            case 17: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.17");
                break;
            }
            case 28: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.28");
                break;
            }
            case 15: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.15");
                break;
            }
            case 18: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.18");
                break;
            }
            case 11: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.11");
                break;
            }
            case 5: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.5");
                break;
            }
            case 30: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.30");
                break;
            }
            case 8: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.8");
                break;
            }
            case 26: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.26");
                break;
            }
            case 23: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.23");
                break;
            }
            case 16: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.16");
                break;
            }
            case 12: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.12");
                break;
            }
            case 21: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.21");
                break;
            }
            case 19: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.19");
                break;
            }
            case 2: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.2");
                break;
            }
            case 22: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.22");
                break;
            }
            case 1: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.1");
                break;
            }
            case 31: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.31");
                break;
            }
            case 4: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.4");
                break;
            }
            case 3: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.3");
                break;
            }
            case 29: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.29");
                break;
            }
            case 27: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.27");
                break;
            }
            case 6: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.6");
                break;
            }
            case 14: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.14");
                break;
            }
            case 10: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.10");
                break;
            }
            case 13: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.13");
                break;
            }
            case 9: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.9");
                break;
            }
            case 7: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.7");
                break;
            }
            case 20: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.20");
                break;
            }
            case 24: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.24");
                break;
            }
            case 36: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.36");
                break;
            }
            case 34: {
                desc = Messages.getString(Utils.class, "ddcl.resShortType.34");
                break;
            }
            default: {
                L.warn("search for a DDCL unknown type: {}", (Object)idType);
                desc = Messages.getString(Utils.class, "ddcl.genericType");
            }
        }
        return desc;
    }

    public static void exportFile(String f, File file) throws IOException {
        String sourcePath = com.ez.report.generation.common.utils.Utils.getGraphsDirectory().concat(f);
        com.ez.report.generation.common.utils.Utils.exportFile((String)f, (File)file, (String)sourcePath);
    }

    public static RGB asRGB(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException("Null doesn't represent a valid RGB");
        }
        StringTokenizer stok = new StringTokenizer(value, ",");
        try {
            String red = stok.nextToken().trim();
            String green = stok.nextToken().trim();
            String blue = stok.nextToken().trim();
            int rval = 0;
            int gval = 0;
            int bval = 0;
            rval = Integer.parseInt(red);
            gval = Integer.parseInt(green);
            bval = Integer.parseInt(blue);
            return new RGB(rval, gval, bval);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NumberFormatException("incorrect rgb format " + value);
        }
    }

    public static void writeNotePartInCSV(CSVWriter csvWriter, boolean limitNode, boolean markOnlyExpandable, boolean excludedNote) {
        String txt;
        csvWriter.writeLine(Messages.getString(Utils.class, "headerOrAppendix.notes"));
        if (excludedNote) {
            txt = Utils.getPatternNameLimitText();
            csvWriter.writeLine(txt);
        }
        if (limitNode) {
            txt = Utils.getLevelLimitNoteText(markOnlyExpandable);
            csvWriter.writeLine(txt);
        }
        csvWriter.writeLine("");
    }

    public static String getPatternNameLimitText() {
        return Messages.getString(Utils.class, "headerOrAppendix.notes.excludedResults", new String[]{" !".trim()});
    }

    public static String getLevelLimitNoteText(boolean markOnlyExpandable) {
        return markOnlyExpandable ? Messages.getString(Utils.class, "headerOrAppendix.notes.limitReached.onlyexpandables", new String[]{" *".trim()}) : Messages.getString(Utils.class, "headerOrAppendix.notes.limitReached.all", new String[]{" *".trim()});
    }

    public static <T> Predicate<T> distinctByKeys(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

