/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastKeySelectionOnTable
implements KeyListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FastKeySelectionOnTable.class);
    private Table table = null;
    private long lastTimestamp = 0L;
    private static long DELTA = 400L;
    private StringBuffer searchBuffer = new StringBuffer();

    public FastKeySelectionOnTable(Table table) {
        this.table = table;
    }

    public void keyPressed(KeyEvent e) {
        long currentTimestamp = System.currentTimeMillis();
        if (e.keyCode != 65536 && e.keyCode != 131072 && e.keyCode != 262144) {
            if (currentTimestamp - this.lastTimestamp > DELTA) {
                this.lastTimestamp = currentTimestamp;
                this.searchBuffer.delete(0, this.searchBuffer.length());
            }
            this.searchBuffer.append(e.character);
            this.selectInTree();
        }
    }

    private void selectInTree() {
        int start;
        String searchText = this.searchBuffer.toString().toUpperCase();
        L.debug("finding searchBuffer = {} in table", (Object)searchText);
        int itemCount = this.table.getItemCount();
        int n = start = this.searchBuffer.length() == 1 ? this.table.getSelectionIndex() + 1 : 0;
        if (start == -1) {
            start = 0;
        }
        boolean found = false;
        int i = start;
        while (i < itemCount) {
            if (this.table.getItem(i).getText().toUpperCase().startsWith(searchText)) {
                L.debug("selecting {}", (Object)this.table.getItem(i).getText());
                this.table.select(i);
                this.table.showSelection();
                found = true;
                break;
            }
            ++i;
        }
        if (!found && start != 0) {
            i = 0;
            while (i < start) {
                if (this.table.getItem(i).getText().toUpperCase().startsWith(searchText)) {
                    L.debug("selecting {}", (Object)this.table.getItem(i).getText());
                    this.table.select(i);
                    this.table.showSelection();
                    break;
                }
                ++i;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

