/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.datasetflow;

import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDS
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportDS.class);
    private Object4Report currentValue;
    private List<Object4Report> list;
    private ElementGroupInfo summaryElem;
    private ElementGroupInfo legends;

    public ReportDS(List<Object4Report> list, ElementGroupInfo summaryElem) {
        this.list = list;
        this.summaryElem = summaryElem;
    }

    public void setLegends(ElementGroupInfo legends) {
        this.legends = legends;
    }

    public boolean nextItem() throws JRException {
        Object4Report object4Report = this.currentValue = this.list.size() > 0 ? this.list.remove(0) : null;
        return this.currentValue != null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("summaryDataSource")) {
            value = this.summaryElem;
        } else if (field.getName().equals("detailName")) {
            value = this.currentValue.getDetailName();
        } else if (field.getName().equals("detailsDataSource")) {
            value = this.currentValue.getElemDetails();
        } else if (field.getName().equals("legendDataSource")) {
            value = this.legends;
        } else if (field.getName().equals("detailTOC")) {
            value = this.currentValue.getDetailTOC() != null ? this.currentValue.getDetailTOC() : this.currentValue.getDetailName();
        } else if (field.getName().equals("tocTooltip")) {
            value = ReportsUtils.prepareTooltip((String)this.currentValue.getTocTooltip());
        }
        return value;
    }
}

