/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.all;

import java.awt.Image;

public class Obj4HalsteadReport {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String resType;
    private String resName;
    private Integer oprNo;
    private Integer oprdNo;
    private Integer uniqueOprNo;
    private Integer uniqueOprdNo;
    private Double prgLength;
    private Double vocSize;
    private Double prgVolume;
    private Double diffLevel;
    private Double prgLevel;
    private Double effImplement;
    private Double timeImplement;
    private Double deliveredBugs;
    private Image spiderImg;

    public Obj4HalsteadReport(String resType, String resName, Integer oprNo, Integer oprdNo, Integer uniqueOprNo, Integer uniqueOprdNo) {
        this.resType = resType;
        this.resName = resName;
        this.oprNo = oprNo;
        this.oprdNo = oprdNo;
        this.uniqueOprNo = uniqueOprNo;
        this.uniqueOprdNo = uniqueOprdNo;
        this.prgLength = new Double(oprNo + oprdNo);
        this.vocSize = new Double(uniqueOprNo + uniqueOprdNo);
        this.prgVolume = this.vocSize == 0.0 ? new Double(0.0) : new Double((double)this.prgLength.intValue() * Math.log(this.vocSize) / Math.log(2.0));
        this.diffLevel = uniqueOprNo.doubleValue() == 0.0 || uniqueOprdNo.doubleValue() == 0.0 ? new Double(0.0) : new Double(uniqueOprNo.doubleValue() / 2.0 * (oprdNo.doubleValue() / uniqueOprdNo.doubleValue()));
        this.prgLevel = this.diffLevel == 0.0 ? new Double(0.0) : new Double(1.0 / this.diffLevel);
        this.effImplement = new Double(this.prgVolume * this.diffLevel);
        this.timeImplement = new Double(this.effImplement / 18.0);
        this.deliveredBugs = this.effImplement == 0.0 ? new Double(0.0) : new Double(Math.exp(2.0 * Math.log(this.effImplement) / 3.0) / 3000.0);
    }

    public void setSpiderImg(Image spiderImg) {
        this.spiderImg = spiderImg;
    }

    public Object get(String str) {
        Object res = null;
        if (str.equalsIgnoreCase("type")) {
            res = this.resType;
        } else if (str.equalsIgnoreCase("name")) {
            res = this.resName;
        } else if (str.equals("n1")) {
            res = this.uniqueOprNo;
        } else if (str.equals("n2")) {
            res = this.uniqueOprdNo;
        } else if (str.equals("N1")) {
            res = this.oprNo;
        } else if (str.equals("N2")) {
            res = this.oprdNo;
        } else if (str.equals("N")) {
            res = this.prgLength;
        } else if (str.equals("n")) {
            res = this.vocSize;
        } else if (str.equals("V")) {
            res = this.prgVolume;
        } else if (str.equals("D")) {
            res = this.diffLevel;
        } else if (str.equals("L")) {
            res = this.prgLevel;
        } else if (str.equals("E")) {
            res = this.effImplement;
        } else if (str.equals("T")) {
            res = this.timeImplement;
        } else if (str.equals("B")) {
            res = this.deliveredBugs;
        } else if (str.equalsIgnoreCase("spiderImg")) {
            res = this.spiderImg;
        }
        return res;
    }
}

