/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.all;

import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.workspace.model.Utils;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class LegendDataSource
implements SubreportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PATTERN_RESTRICTION_IMAGE_KEY = "patternRestriction";
    public static final String LIMIT_REACHED_IMAGE_KEY = "limitReached";
    private List<String[]> list;
    private String[] currentValue;
    private String legendTitle;

    public LegendDataSource(String legendTitle, List<String[]> desc) {
        this.legendTitle = legendTitle;
        this.list = desc;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("legendTitle")) {
            value = this.legendTitle;
        } else if (field.getName().equals("description")) {
            value = this.currentValue[2];
        } else if (field.getName().equals("color")) {
            value = this.currentValue[1];
        } else if (field.getName().equals("descriptionType")) {
            value = this.currentValue[0];
        } else if (field.getName().equals("indentDescription")) {
            value = this.currentValue.length >= 4 ? this.currentValue[3] : null;
        } else if (field.getName().equals("isDotted")) {
            value = this.currentValue.length > 4 ? Boolean.valueOf(this.currentValue[4]) : Boolean.FALSE;
        } else if (field.getName().equals("img") && this.currentValue.length > 5) {
            if (PATTERN_RESTRICTION_IMAGE_KEY.equals(this.currentValue[5])) {
                value = Utils.class.getClassLoader().getResourceAsStream("icons/funnel.png");
            } else if (LIMIT_REACHED_IMAGE_KEY.equals(this.currentValue[5])) {
                value = Utils.class.getClassLoader().getResourceAsStream("icons/graph_more.png");
            }
        } else if (field.getName().equals("isDoubled")) {
            value = this.currentValue.length > 6 ? Boolean.valueOf(this.currentValue[6]) : Boolean.FALSE;
        } else if (field.getName().equals("rounded")) {
            value = this.currentValue.length > 7 ? Boolean.valueOf(this.currentValue[7]) : Boolean.FALSE;
        }
        return value;
    }

    public boolean next() throws JRException {
        String[] stringArray = this.currentValue = this.list.size() > 0 ? this.list.remove(0) : null;
        return this.currentValue != null;
    }

    public JRDataSource getDataSource() {
        return this;
    }

    public String getReportName() {
        return "/reports/subLegendReport.jasper";
    }

    public void moveFirst() throws JRException {
    }

    public InputStream getReportTemplate() {
        InputStream rs = com.ez.report.generation.common.utils.Utils.getResourceStreamFromPlugin((String)"reports/subLegendReport.jasper", null);
        return rs;
    }
}

