/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.all;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYZDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZXYDataset
implements XYZDataset {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EZXYDataset.class);
    protected ArrayList<PlotGroup> data = new ArrayList();
    protected List<Integer> xValues = new ArrayList<Integer>();

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public int getItemCount(int i) {
        return this.data.size();
    }

    public Number getX(int i, int j) {
        return new Integer(this.data.get((int)j).nrChain);
    }

    public double getXValue(int series, int item) {
        return this.getX(series, item).doubleValue();
    }

    public Number getY(int i, int j) {
        return new Integer(this.data.get((int)j).maxDeep);
    }

    public double getYValue(int series, int item) {
        return this.getY(series, item).doubleValue();
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable getSeriesKey(int i) {
        return "complexity of program";
    }

    public int indexOf(Comparable comparable) {
        return 0;
    }

    public void addChangeListener(DatasetChangeListener datasetchangelistener) {
    }

    public DatasetGroup getGroup() {
        return null;
    }

    public void removeChangeListener(DatasetChangeListener datasetchangelistener) {
    }

    public void setGroup(DatasetGroup datasetgroup) {
    }

    public void addData(PlotGroup group) {
        this.data.add(group);
        this.xValues.add(new Integer(group.nrChain));
    }

    public List<Integer> getXValues() {
        return this.xValues;
    }

    public Number getZ(int series, int item) {
        return null;
    }

    public double getZValue(int series, int item) {
        return -1.0;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public class PlotGroup {
        public String prgName;
        public int nrChain;
        public int maxDeep;

        public PlotGroup(String prgName) {
            this.prgName = prgName;
        }

        public PlotGroup(String prgName, int nrChain, int maxDeep) {
            this(prgName);
            this.nrChain = nrChain;
            this.maxDeep = maxDeep;
        }

        public String getKey() {
            return String.valueOf(this.nrChain) + "-" + this.maxDeep;
        }
    }
}

