/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.all;

import java.text.NumberFormat;
import java.util.List;
import org.jfree.chart.axis.NumberTickUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZNumberTickUnit
extends NumberTickUnit {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EZNumberTickUnit.class);
    public static final int MAXIMUM_TICK_NUMBER = 200;
    List values;
    int visibleTicks = 0;
    boolean tooManyTicks = false;

    public EZNumberTickUnit(double size, NumberFormat formatter, List datasource) {
        super(size, formatter);
        this.values = datasource;
        L.debug("EZNumberTickUnit");
        this.tooManyTicks = this.calculateNrTicks();
    }

    public String valueToString(double value) {
        if (this.tooManyTicks || this.isValue(value)) {
            return super.valueToString(value);
        }
        return "";
    }

    public boolean isValue(double value) {
        int intValue;
        if (this.values != null && this.values.contains(intValue = new Double(value).intValue())) {
            L.debug("value {} is in range. must be printed!", (Object)value);
            ++this.visibleTicks;
            return true;
        }
        return false;
    }

    public double getMaxValue() {
        return ((Integer)this.values.get(this.values.size() - 1)).doubleValue();
    }

    private boolean calculateNrTicks() {
        int minValue = (Integer)this.values.get(0);
        double count = this.getMaxValue() - (double)minValue;
        return count > 200.0;
    }
}

