/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports.all;

import com.ez.report.application.reports.all.EZNumberTickUnit;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZNumberAxis
extends NumberAxis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EZNumberAxis.class);
    private static final int FIXED_NUMBER_OF_TICKS = 10;

    public EZNumberAxis(String label) {
        super(label);
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> result = new ArrayList<NumberTick>();
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        double size = this.getTickUnit().getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        L.debug("count={}", (Object)count);
        L.debug("size={}", (Object)size);
        L.debug("lowestTickValue={}", (Object)lowestTickValue);
        NumberTickUnit unit = this.getTickUnit();
        EZNumberTickUnit myUnit = null;
        if (unit instanceof EZNumberTickUnit) {
            myUnit = (EZNumberTickUnit)unit;
        }
        if (count > 200) {
            count = 10;
            double highestValue = this.calculateHighestVisibleTickValue();
            size = highestValue / (double)count;
            L.debug("recalculate!!! count={}", (Object)count);
            L.debug("recalculate!!! size={}", (Object)size);
        }
        int i = 0;
        while (i < count) {
            double currentTickValue = 0.0;
            currentTickValue = myUnit != null && i == count - 1 ? myUnit.getMaxValue() : lowestTickValue + (double)i * size;
            NumberFormat formatter = this.getNumberFormatOverride();
            String tickLabel = formatter != null ? formatter.format(currentTickValue) : this.getTickUnit().valueToString(currentTickValue);
            TextAnchor anchor = null;
            TextAnchor rotationAnchor = null;
            double angle = 0.0;
            if (this.isVerticalTickLabels()) {
                anchor = TextAnchor.CENTER_RIGHT;
                rotationAnchor = TextAnchor.CENTER_RIGHT;
                angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
            } else if (edge == RectangleEdge.TOP) {
                anchor = TextAnchor.BOTTOM_CENTER;
                rotationAnchor = TextAnchor.BOTTOM_CENTER;
            } else {
                anchor = TextAnchor.TOP_CENTER;
                rotationAnchor = TextAnchor.TOP_CENTER;
            }
            NumberTick tick = new NumberTick((Number)new Double(currentTickValue), tickLabel, anchor, rotationAnchor, angle);
            result.add(tick);
            ++i;
        }
        return result;
    }
}

