/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.data.utils.CloseTestRunnable;
import com.ez.mainframe.model.ApplicationInputNoGUI;
import com.ez.mainframe.model.MultiAppInputNoGUI;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.reports.FinishListener;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportBuilder
extends AbstractBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractReportBuilder.class);
    protected static final String SHOW_INPUTS_PARAMETER = "showInputs";
    protected static final String SHOW_APPENDIX_PARAMETER = "showAppendix";
    protected Map<String, ApplicationInputNoGUI> apps = new HashMap<String, ApplicationInputNoGUI>();
    protected String applicationsName;
    protected static final String COUNT_AVAILABLE_4FUJITSU_PROGRAMS_QUERY = "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 13, 14, 15, 16) ";
    protected static final String APPENDIX_DS_KEY = "appendixDS";
    protected JasperReport jasperReport;
    protected AbstractReportDataSource ds;
    private JRSwapFile swapFile;
    private JRSwapFileVirtualizer virtualizer;
    public boolean mustWrite;
    protected Set<Integer> selectedIds = null;
    protected boolean canceled = false;
    private FinishListener listener;
    protected boolean runInBatch = false;
    protected boolean needsTS = false;
    protected File csvFile;

    protected abstract String getReportTemplatePath();

    protected InputStream getReportStream(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        InputStream stream = com.ez.report.generation.common.utils.Utils.getResourceStreamFromPlugin((String)this.getReportTemplatePath());
        monitor.worked(100);
        return stream;
    }

    public abstract Map<String, Object> getReportParameters(IProgressMonitor var1);

    public abstract AbstractReportDataSource getDataSource(IProgressMonitor var1) throws Exception;

    protected abstract void customizeJasperPrint(JasperPrint var1);

    public IStatus execute(IProgressMonitor pmonitor) {
        IStatus status = Status.OK_STATUS;
        if (this.report == null) {
            this.report = this.getReportModel();
        }
        if (this.report != null) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            IStatus[] statuses = new IStatus[]{status};
            this.buildReport(statuses, monitor);
            status = statuses[0];
            if (status == Status.CANCEL_STATUS && this.canceled) {
                this.displayCancelMessage();
            }
            monitor.setWorkRemaining(0);
        }
        return status;
    }

    private void buildReport(IStatus[] status, SubMonitor monitor) {
        if (status[0] == Status.OK_STATUS) {
            if (this.singleProject) {
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
                try {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                            AbstractReportBuilder.this.pInfo = conn.getProjectInfo();
                        }
                    }, LockType.Shared, (IProgressMonitor)monitor.newChild(5));
                }
                catch (InterruptedException interruptedException) {
                    throw new CanceledException("connection interrupted");
                }
                catch (ExecutionException e) {
                    ErrorUtils.handleExecutionException((ExecutionException)e);
                }
            }
            if (status[0] == Status.OK_STATUS && !monitor.isCanceled()) {
                this.preBuild((IProgressMonitor)monitor.newChild(5));
            }
            if (status[0] == Status.OK_STATUS && !monitor.isCanceled()) {
                status[0] = this.build((IProgressMonitor)monitor.newChild(80));
            }
            if (status[0] == Status.OK_STATUS && !monitor.isCanceled()) {
                this.postBuild((IProgressMonitor)monitor.newChild(10));
            }
            this.pInfo = null;
        }
    }

    protected void addLocaleParameter(Map params) {
        ReportsUtils.addLocaleParameter((Map)params);
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        this.apps.clear();
        Object selectedApps = this.report.getProperty("filtered by app");
        if (this.isMultiApp() && selectedApps != null && ((Boolean)selectedApps).booleanValue()) {
            String noAppStr = "NO_APP";
            for (MultiAppInputNoGUI prg : prgList) {
                if (prg.getApplications() != null && !prg.getApplications().isEmpty()) {
                    for (String appName : prg.getApplications()) {
                        ApplicationInputNoGUI app = this.apps.get(appName);
                        if (app == null) {
                            app = new ApplicationInputNoGUI(appName, "");
                            this.apps.put(appName, app);
                        }
                        app.addProgram(prg.getName());
                    }
                    continue;
                }
                ApplicationInputNoGUI app = this.apps.get(noAppStr);
                if (app == null) {
                    app = new ApplicationInputNoGUI(noAppStr, "");
                    this.apps.put(noAppStr, app);
                }
                app.addProgram(prg.getName());
            }
            this.addEmptyApplications();
            this.setApplicationName(this.apps.keySet());
            ArrayList<String> temp = new ArrayList<String>(this.apps.keySet());
            Collections.sort(temp, String.CASE_INSENSITIVE_ORDER);
            for (String appName : temp) {
                ApplicationInputNoGUI app = this.apps.get(appName);
                ret = ret.concat(app.toString());
                ret = ret.concat("\n");
            }
        } else {
            ret = prgList.toString();
        }
        return ret;
    }

    protected void addEmptyApplications() {
        Collection appNames = (Collection)this.inputs.get("selected applications names");
        for (String app : appNames) {
            if (this.apps.containsKey(app)) continue;
            L.debug("empty application was addedd to appendix: {}", (Object)app);
            this.apps.put(app, new ApplicationInputNoGUI(app, ""));
        }
    }

    public void setApplicationName(Set<String> appNameSet) {
        StringBuffer buff = new StringBuffer();
        ArrayList<String> temp = new ArrayList<String>(appNameSet);
        Collections.sort(temp, String.CASE_INSENSITIVE_ORDER);
        Iterator it = temp.iterator();
        while (it.hasNext()) {
            String appName = (String)it.next();
            buff.append(appName);
            if (!it.hasNext()) continue;
            buff.append(", ");
        }
        this.applicationsName = buff.toString();
    }

    @Override
    public void cleanMemory() {
        this.ds = null;
        if (this.apps != null) {
            this.apps.clear();
            this.apps = null;
        }
        this.jasperReport = null;
        this.swapFile = null;
        this.listener = null;
        this.messages.clear();
        super.cleanMemory();
    }

    public void dispose() {
        if (this.virtualizer != null) {
            this.virtualizer.cleanup();
            this.virtualizer = null;
        }
        if (this.csvFile != null) {
            this.csvFile.delete();
        }
    }

    protected void preBuild(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (this.report.print == null && !this.report.mustRegenerate && this.report.name != null && !"".equals(this.report.name)) {
            String generatedFile = (String)this.inputs.get("");
            String generatedFolder = (String)this.inputs.get("");
            String fileName = this.report.name;
            this.report = Utils.getGeneratedReportModel(fileName, generatedFile, generatedFolder, this.messages);
            if (!this.report.name.equalsIgnoreCase(fileName)) {
                this.report.name = fileName;
            }
        }
        monitor.setWorkRemaining(0);
    }

    protected void postBuild(IProgressMonitor pmonitor) {
    }

    public IStatus build(IProgressMonitor pmonitor) {
        IStatus status = Status.OK_STATUS;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)110);
        this.initStopCode((IProgressMonitor)monitor);
        try {
            monitor.setTaskName(Messages.getString(AbstractReportBuilder.class, "loadingReport.taskName"));
            if (this.report.print == null) {
                if (this.isOkToContinue()) {
                    if (this.needsTS) {
                        this.initializeTS();
                    }
                    this.initialize((IProgressMonitor)monitor.newChild(10));
                    this.prepareReport((IProgressMonitor)monitor.newChild(10));
                    this.checkStop();
                    monitor.setTaskName(Messages.getString(AbstractReportBuilder.class, "getParameters.taskName"));
                    this.parameters = this.getReportParameters((IProgressMonitor)monitor.newChild(10));
                    if (this.singleProject) {
                        boolean isUCMDB = false;
                        if (this.pInfo != null) {
                            isUCMDB = this.pInfo.isUMCDB();
                        } else {
                            L.warn("pInfo null for project {}", (Object)this.project);
                        }
                        Utils.setParamsForTitle(this.parameters, this.project, isUCMDB, this.inputs);
                    } else {
                        com.ez.report.generation.common.utils.Utils.setParamsForTitle((Map)this.parameters, (Map)this.inputs);
                    }
                    L.debug("after load params");
                    this.checkStop();
                    this.putGenericParams(this.parameters);
                    monitor.setTaskName(Messages.getString(AbstractReportBuilder.class, "generatingData.taskName"));
                    this.ds = this.getDataSource((IProgressMonitor)monitor.newChild(45));
                    if (this.ds != null) {
                        this.ds.setIterationCode(this.stopCode);
                    }
                    L.debug("after getting datasource");
                    this.checkStop();
                    this.checkParams();
                    monitor.setTaskName(Messages.getString(AbstractReportBuilder.class, "writingReport.taskName"));
                    this.getReportModel().print = this.prepareDocument(this.jasperReport, this.parameters, (JRDataSource)this.ds, (IProgressMonitor)monitor.newChild(30), status);
                    this.mustWrite = true;
                } else {
                    status = Status.CANCEL_STATUS;
                }
                this.uninitializeTS();
            } else {
                L.debug("report loaded from file");
            }
        }
        catch (Throwable t) {
            status = Status.CANCEL_STATUS;
            if (!(t instanceof CanceledException)) {
                L.error("error at building report", t);
                if (this.report.name == null) {
                    this.report.name = AbstractReport.generateName(this.report);
                }
                this.messages.add(new LogMessage(Messages.getString(AbstractReportBuilder.class, "errorAtGenerate.message", new String[]{this.report.name}), 4, "com.ez.mainframe.reports.core", t));
            }
            L.info("report was canceled", t);
            this.canceled = true;
        }
        monitor.setWorkRemaining(0);
        if (this.listener != null) {
            this.listener.reportFinished(this.report, this.getReportDocument(), this.mustWrite, status);
        }
        return status;
    }

    protected void uninitializeTS() {
    }

    protected void initializeTS() {
    }

    private void checkParams() {
        Object obj = this.parameters.get("REPORT_SCRIPTLET");
        L.trace("scriptlet: {}", obj);
        obj = this.parameters.get("headingsTemplate");
        L.trace("headingsTemplate: {}", obj);
        obj = this.parameters.get(SHOW_APPENDIX_PARAMETER);
        L.trace("showAppendix: {}", obj);
    }

    protected void initStopCode(final IProgressMonitor monitor) {
        this.stopCode = new Runnable(){

            @Override
            public void run() {
                if (monitor.isCanceled()) {
                    AbstractReportBuilder.this.cleanMemory();
                    if (AbstractReportBuilder.this.listener != null) {
                        AbstractReportBuilder.this.listener.reportFinished(AbstractReportBuilder.this.report, AbstractReportBuilder.this.getReportDocument(), false, Status.CANCEL_STATUS);
                    }
                }
                if (monitor.isCanceled()) {
                    AbstractReportBuilder.this.canceled = true;
                    throw new CanceledException("report canceled");
                }
            }
        };
    }

    protected void checkStop() {
        if (this.stopCode != null) {
            this.stopCode.run();
        }
    }

    protected void displayCancelMessage() {
        L.warn("report was not generated");
        this.messages.add(new LogMessage(Messages.getString(AbstractReportBuilder.class, "errorlog.infoMessage.canceled"), 1, "com.ez.mainframe.reports.core", null));
    }

    public boolean isOkToContinue() {
        return true;
    }

    protected void initialize(IProgressMonitor pmonitor) {
    }

    protected void prepareReport(IProgressMonitor pmonitor) throws JRException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)15);
        InputStream reportStream = this.getReportStream((IProgressMonitor)monitor.newChild(5));
        monitor.setTaskName(Messages.getString(AbstractReportBuilder.class, "loadingTemplate.taskName"));
        L.debug("before load object");
        this.jasperReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
        L.debug("after load object");
        monitor.worked(10);
    }

    protected void putGenericParams(Map params) {
        String externalized = Messages.getString(AbstractReportBuilder.class, "toc.title");
        params.put("toc.title", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "genDate.lbl");
        params.put("genDate.lbl", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "page.txt");
        params.put("page", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "of.txt");
        params.put("of", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "report.summary");
        params.put("reportSummary", externalized);
        params.put("report.summary", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "report.detail");
        params.put("reportDetails", externalized);
        params.put("report.details", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "annex.lbl");
        params.put("annexLbl", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "resources.summary.lbl");
        params.put("resourcesSummary", externalized);
        externalized = Messages.getString(AbstractReportBuilder.class, "appendix.numberOfInputs.lbl");
        this.parameters.put("appendixFirstLineLabel", externalized);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReport.jasper", (String)"headingsTemplate", (Map)this.parameters);
        this.parameters.put(SHOW_APPENDIX_PARAMETER, this.getReportModel().getProperty("show appendix"));
        this.parameters.put(SHOW_INPUTS_PARAMETER, this.getReportModel().getProperty("showInputDetails"));
    }

    protected JasperPrint prepareDocument(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
        JasperPrint print;
        block5: {
            print = null;
            Thread currentThread = Thread.currentThread();
            ClassLoader oldLoader = currentThread.getContextClassLoader();
            try {
                try {
                    currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    L.trace("class loader changed to: {}", (Object)currentThread.getContextClassLoader());
                    String swapFolder = (String)this.inputs.get("swap_folder");
                    this.swapFile = new JRSwapFile(swapFolder, 1024, 512);
                    this.virtualizer = new JRSwapFileVirtualizer(this.getMaxCachedPages(), this.swapFile, true);
                    params.put("REPORT_VIRTUALIZER", this.virtualizer);
                    JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (String)Boolean.TRUE.toString());
                    print = JasperFillManager.fillReport((JasperReport)jReport, (Map)params, (JRDataSource)ds);
                    this.virtualizer.setReadOnly(false);
                }
                catch (JRException e) {
                    L.error("prepareDocument", (Throwable)e);
                    this.messages.add(new LogMessage(Messages.getString(AbstractReportBuilder.class, "jasper.Exception.log"), 4, "com.ez.mainframe.reports.core", (Throwable)e));
                    monitor.setCanceled(true);
                    status = Status.CANCEL_STATUS;
                    currentThread.setContextClassLoader(oldLoader);
                    L.trace("class loader changed back to: {}", (Object)currentThread.getContextClassLoader());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                currentThread.setContextClassLoader(oldLoader);
                L.trace("class loader changed back to: {}", (Object)currentThread.getContextClassLoader());
                throw throwable;
            }
            currentThread.setContextClassLoader(oldLoader);
            L.trace("class loader changed back to: {}", (Object)currentThread.getContextClassLoader());
        }
        this.customizeJasperPrint(print);
        this.filterPages(print);
        return print;
    }

    protected void filterPages(JasperPrint jasperPrint) {
        List pages;
        if (jasperPrint != null && (pages = jasperPrint.getPages()) != null && pages.size() > 0) {
            Object showOnlySummary = this.report.getProperty("show summary only");
            if (showOnlySummary != null && ((Boolean)showOnlySummary).booleanValue()) {
                ReportsUtils.removeEmptyPages((List)pages, (String)this.report.name);
            } else {
                this.moveTableOfContents(jasperPrint);
            }
        }
    }

    protected void moveTableOfContents(JasperPrint jasperPrint) {
        ReportsUtils.moveTableOfContents((JasperPrint)jasperPrint);
    }

    protected int getMaxCachedPages() {
        return 100;
    }

    public void setFinishListener(FinishListener lst) {
        this.listener = lst;
    }

    protected boolean putSubreportStream(String templateFilePath, String parameterName) {
        return com.ez.report.generation.common.utils.Utils.putSubreportStream((String)templateFilePath, (String)parameterName, (Map)this.parameters);
    }

    protected boolean putSubreportParam(InputStream stream, String parameterName) {
        return com.ez.report.generation.common.utils.Utils.putSubreportParam((InputStream)stream, (String)parameterName, (Map)this.parameters);
    }

    private String getReportTemplate() {
        return null;
    }

    public void addParameters(Map params) {
    }

    protected List getAvailable() {
        return (List)this.getReportModel().getProperty("available resources");
    }

    protected Collection getSelected() {
        return (Collection)this.getReportModel().getProperty("inputs");
    }

    protected List getAvailableApplications() {
        return (List)this.getReportModel().getProperty("available applications");
    }

    protected Collection getSelectedApplications() {
        return (Collection)this.getReportModel().getProperty("selected applications");
    }

    protected boolean getSelectionFlagFromInputs() {
        boolean ret = false;
        Boolean allRes = (Boolean)this.inputs.get("all resources selected");
        if (allRes != null && !allRes.booleanValue()) {
            L.trace("getSelectionFlagFromInputs().allRes={}", (Object)allRes);
            return ret;
        }
        List available = (List)this.inputs.get("available applications");
        if (available == null) {
            available = (List)this.inputs.get("available resources");
            List sel = (List)this.inputs.get("selected resources");
            if (available == null) {
                L.trace("getSelectionFlagFromInputs().allSelected; available is null, sel={}", (Object)sel);
                boolean bl = ret = sel == null;
                if (ret) {
                    L.warn("report with no inputs?!");
                }
            } else if (available.size() == sel.size()) {
                L.trace("getSelectionFlagFromInputs().allSelected; available={}, sel={}", (Object)available, (Object)sel);
                ret = true;
            } else {
                ret = false;
            }
        }
        return ret;
    }

    protected Collection filterSelectedIDs() {
        return this.filterSelectedIDs((IProgressMonitor)new NullProgressMonitor());
    }

    protected Collection filterSelectedIDs(IProgressMonitor monitor) {
        if (this.selectedIds == null) {
            this.selectedIds = new HashSet<Integer>();
            Collection selectedResources = this.getSelected();
            for (ProgramInputNoGUI inpt : selectedResources) {
                if (inpt.getTypeCode() == 8 || inpt.getTypeCode() == 13) {
                    Collection childrens = inpt.getChildrenIDs();
                    if (childrens != null) {
                        this.selectedIds.addAll(childrens);
                    } else {
                        if (inpt.getTypeCode() == 8) {
                            L.warn("assembler program without children?! {}", (Object)inpt.getName());
                        }
                        this.selectedIds.add(inpt.getResourceID());
                    }
                    if (inpt.getTypeCode() != 13) continue;
                    L.warn("a SCL program appears as input: {}; remove it!", (Object)inpt);
                    continue;
                }
                this.selectedIds.add(inpt.getResourceID());
            }
        }
        return this.selectedIds;
    }

    protected SingleQueryResult queryForData(IProgressMonitor monitor) {
        return this.queryForData(monitor, EZSourceDataType.String);
    }

    protected SingleQueryResult queryForData(IProgressMonitor monitor, EZSourceDataType paramType) {
        String[] procParam = new String[]{};
        return this.queryForData(monitor, procParam, paramType);
    }

    protected SingleQueryResult queryForData(IProgressMonitor monitor, String[] procParam) {
        return this.queryForData(monitor, procParam, EZSourceDataType.String);
    }

    protected SingleQueryResult queryForData(IProgressMonitor monitor, String[] procParam, EZSourceDataType paramType) {
        return this.queryForData((Runnable)new CloseTestRunnable(monitor), procParam, paramType);
    }

    protected SingleQueryResult queryForData(Runnable iterationCode, String[] procParam, EZSourceDataType paramType) {
        Collection selected = this.getSelected();
        return this.queryForData(iterationCode, procParam, paramType, selected);
    }

    protected SingleQueryResult queryForData(IProgressMonitor pmonitor, EZSourceDataType paramType, Collection filterSelectedIDs) {
        Object[] procParam = new String[]{};
        return this.queryForData((Runnable)new CloseTestRunnable(pmonitor), procParam, paramType, filterSelectedIDs);
    }

    protected SingleQueryResult queryForData(Runnable iterationCode, Object[] procParam, EZSourceDataType paramType, Collection selected) {
        return this.queryForData(iterationCode, procParam, null, paramType, selected);
    }

    protected SingleQueryResult queryForData(Runnable iterationCode, final Object[] params, final ParameterInfo[] pInfo, final EZSourceDataType paramType, final Collection selected) {
        final SingleQueryResult queryResult = new SingleQueryResult();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)(iterationCode instanceof CloseTestRunnable ? ((CloseTestRunnable)iterationCode).getMonitor() : new NullProgressMonitor()), (int)100);
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection bridge, IProgressMonitor pmonitor) {
                    AbstractReportBuilder.this.queryForData(params, pInfo, paramType, selected, queryResult, bridge);
                }
            }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return queryResult;
    }

    protected void queryForData(Object[] procParam, EZSourceDataType paramType, Collection selected, SingleQueryResult queryResult, EZSourceConnection conn) {
        this.queryForData(procParam, null, paramType, selected, queryResult, conn);
    }

    protected void queryForData(Object[] procParam, ParameterInfo[] pInfo, EZSourceDataType paramType, Collection selected, SingleQueryResult queryResult, EZSourceConnection conn) {
        EZSourceConnectionException ex = null;
        try {
            Collection app;
            ArrayList<EZSourceDataType> types = new ArrayList<EZSourceDataType>();
            ArrayList values = new ArrayList();
            Object selectedApps = this.report.getProperty("filtered by app");
            if (this.isMultiApp() && selectedApps != null && ((Boolean)selectedApps).booleanValue() && (app = this.report.getSelectedApplications()) != null && !app.isEmpty()) {
                values.addAll(app);
                types.addAll(Arrays.asList(new EZSourceDataType[app.size()]));
                Collections.fill(types, EZSourceDataType.Integer);
            }
            if (this.report.useAllResources()) {
                String proc = this.getProcedure();
                Assert.isNotNull((Object)proc);
                queryResult.data = conn.execNonTransactionalStoredProc(proc, procParam, types, values);
                queryResult.resourcesCount = this.countAvailableProjectPrograms(conn);
            } else if (selected != null) {
                String selectiveProc = this.getSelectiveProcedure();
                Assert.isNotNull((Object)selectiveProc);
                this.prepareSelectedList(paramType, selected, values);
                List<EZSourceDataType> typesTemp = Arrays.asList(new EZSourceDataType[selected.size()]);
                Collections.fill(typesTemp, paramType);
                types.addAll(typesTemp);
                queryResult.data = pInfo != null ? conn.execNonTransactionalStoredProc(selectiveProc, procParam, pInfo, types, values) : conn.execNonTransactionalStoredProc(selectiveProc, procParam, types, values);
                queryResult.resourcesCount = this.getSelected() != null ? this.getSelected().size() : 0;
            }
        }
        catch (EZSourceConnectionException e) {
            ex = e;
            L.error("exception at executing stored procedure", (Throwable)e);
            this.messages.add(new LogMessage(Messages.getString(AbstractReportBuilder.class, "storedProcedureError.logMessage"), 4, "com.ez.mainframe.reports.core", (Throwable)e));
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void prepareSelectedList(EZSourceDataType paramType, Collection selected, List values) {
        boolean addAll = true;
        if (paramType.equals((Object)EZSourceDataType.String)) {
            for (Object o : selected) {
                addAll = o instanceof String;
                if (addAll) break;
                values.add(o.toString());
            }
        }
        if (addAll) {
            values.addAll(selected);
        }
    }

    protected String getProcedure() {
        return null;
    }

    protected String getSelectiveProcedure() {
        return null;
    }

    protected String getSQLQuery() {
        return null;
    }

    protected String getSQLQuerySelective() {
        return null;
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms(conn);
    }

    protected String stripNonValidXMLCharacters(String in) {
        return ReportsUtils.stripNonValidXMLCharacters((String)in, (boolean)false);
    }

    protected static String removeExtension(String filename) {
        int pos = filename.lastIndexOf(".");
        if (pos != -1) {
            filename = filename.substring(0, pos);
        }
        return filename;
    }

    public String getGenDate(AbstractReport report) {
        report.time = String.valueOf(Calendar.getInstance().getTimeInMillis());
        long time = Long.valueOf(report.time);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        String strDate = String.valueOf(c.get(1)).concat("_").concat(String.valueOf(c.get(2) + 1)).concat("_").concat(String.valueOf(c.get(5))).concat("_").concat(String.valueOf(c.get(11))).concat("_").concat(String.valueOf(c.get(12))).concat("_").concat(String.valueOf(c.get(13)));
        L.debug("date in name: {}", (Object)strDate);
        return strDate;
    }

    protected String getSelectiveTempTableName() {
        return null;
    }

    protected SingleQueryResult querySQLForData(String query, IProgressMonitor monitor) {
        return this.querySQLForData(query, EZSourceDataType.String, monitor);
    }

    protected SingleQueryResult querySQLForData(String query, EZSourceDataType paramType, IProgressMonitor monitor) {
        Collection selected = this.getSelected();
        return this.querySQLForData(query, paramType, selected, monitor);
    }

    protected SingleQueryResult querySQLForData(EZSourceDataType paramType, Collection selected, IProgressMonitor monitor) {
        return this.querySQLForData(null, paramType, selected, monitor);
    }

    protected SingleQueryResult querySQLForData(final String q, final EZSourceDataType paramType, final Collection selected, IProgressMonitor monitor) {
        final SingleQueryResult queryResult = new SingleQueryResult();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    block8: {
                        String query = q;
                        try {
                            try {
                                AbstractReportBuilder.this.beforeExecSQLHook(conn, pmonitor);
                                if (AbstractReportBuilder.this.report.useAllResources()) {
                                    if (query == null) {
                                        query = AbstractReportBuilder.this.getSQLQuery();
                                    }
                                    Assert.isNotNull((Object)query);
                                    queryResult.data = conn.executeSQL(query);
                                    queryResult.resourcesCount = AbstractReportBuilder.this.countAvailableProjectPrograms(conn);
                                    break block8;
                                }
                                if (query == null) {
                                    query = AbstractReportBuilder.this.getSQLQuerySelective();
                                }
                                Assert.isNotNull((Object)query);
                                ArrayList values = new ArrayList();
                                AbstractReportBuilder.this.prepareSelectedList(paramType, selected, values);
                                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[selected.size()]);
                                Collections.fill(types, paramType);
                                queryResult.data = conn.executeSQL(query, types, values);
                                queryResult.resourcesCount = selected.size();
                            }
                            catch (EZSourceConnectionException e) {
                                L.error("exception at executing stored procedure", (Throwable)e);
                                AbstractReportBuilder.this.messages.add(new LogMessage(Messages.getString(AbstractReportBuilder.class, "storedProcedureError.logMessage"), 4, "com.ez.mainframe.reports.core", (Throwable)e));
                                AbstractReportBuilder.this.finallyExecSQLHook(conn, pmonitor);
                            }
                        }
                        finally {
                            AbstractReportBuilder.this.finallyExecSQLHook(conn, pmonitor);
                        }
                    }
                }
            }, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return queryResult;
    }

    protected void finallyExecSQLHook(EZSourceConnection conn, IProgressMonitor pmonitor) {
    }

    protected void beforeExecSQLHook(EZSourceConnection conn, IProgressMonitor pmonitor) {
    }

    protected String generateName(AbstractReport report) {
        String strDate = this.getGenDate(report);
        return report.projectName.concat("_").concat(report.getTitle()).concat("_").concat(strDate);
    }

    public String getLegalFileNameFor(String fileName) {
        return fileName.replaceAll("/", "__S__").replaceAll("<", "__L__").replaceAll(">", "__R__").replaceAll(":", "__C__").replaceAll("\\*", "__A__").replaceAll("\\?", "__Q__").replaceAll("\\\"", "__D__").replaceAll("\\|", "__V__").replaceAll("\\\\", "__B__");
    }

    protected boolean isMultiApp() {
        Boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (projectIsUCMDB == null && this.pInfo != null) {
            projectIsUCMDB = this.pInfo.isUMCDB();
        }
        return projectIsUCMDB != null && projectIsUCMDB != false;
    }

    public void setRunInBatch(boolean inBatch) {
        this.runInBatch = inBatch;
    }

    public void setOwnerInfos(Map<String, Object> inputs) {
        if (this.report != null) {
            this.report.addProperty("organization", inputs.get("organization"));
            this.report.addProperty("owner", inputs.get("owner"));
            this.report.addProperty("organization_role", inputs.get("organization_role"));
        } else {
            L.warn("report is null; cannot set owner's info");
        }
    }

    protected String[][] runCollector(ProgramsVsCollector collector, Collection prgIDs, IProgressMonitor pmonitor) {
        CollectorRunnable runn = null;
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        if (ph != null) {
            try {
                runn = new CollectorRunnable(collector, prgIDs);
                ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, pmonitor);
            }
            catch (InterruptedException interruptedException) {
                throw new CanceledException("connection interrupted");
            }
            catch (ExecutionException e) {
                ErrorUtils.handleExecutionException((ExecutionException)e);
            }
        }
        String[][] results = runn != null ? runn.getResults() : null;
        return results;
    }

    protected void addAppendixProperties(AbstractReport report) {
        Boolean showApp = (Boolean)this.inputs.get("show appendix");
        showApp = showApp == null ? false : showApp;
        report.addProperty("show appendix", showApp);
        Boolean showInpts = Boolean.FALSE;
        if (showApp.booleanValue() && (showInpts = (Boolean)this.inputs.get("showInputDetails")) == null) {
            showInpts = Boolean.FALSE;
        }
        report.addProperty("showInputDetails", showInpts);
    }

    protected File createTempCSVFile() {
        String prefix;
        String relativePath = "csv" + File.separator + this.project;
        File csvFile = AbstractReportBuilder.createTempFile(relativePath, prefix = (String)this.parameters.get("report.title"), ".csv");
        if (csvFile == null) {
            L.error("could not create csv file. it will not be available");
        }
        return csvFile;
    }

    public CSVWriter initTempCSVFile() {
        CSVWriter csvWriter = CSVWriter.open((File)this.csvFile);
        csvWriter.setSeparator(";");
        return csvWriter;
    }

    protected static File createTempFile(String relativePath, String prefix, String suffix) {
        String temp;
        String string = temp = ServiceUtils.isOsgi() ? com.ez.workspace.preferences.Utils.getTemporaryFolder() : System.getProperty("java.io.tmpdir");
        if (temp != null) {
            File tempFile = null;
            File tempFolder = new File(String.valueOf(temp) + (relativePath != null ? String.valueOf(File.separator) + relativePath : ""));
            tempFolder.mkdirs();
            String p = prefix == null ? "" : prefix.replaceAll("[:\\\\/*?|<>]", "_");
            String s = suffix == null ? "" : suffix.replaceAll("[:\\\\/*?|<>]", "_");
            try {
                tempFile = File.createTempFile(p, s, tempFolder);
            }
            catch (IOException e1) {
                L.error("could not create temporary file in folder: {}", (Object)tempFolder, (Object)e1);
            }
            return tempFile;
        }
        return null;
    }

    protected void writeCSVHeader(CSVWriter csvWriter, String reportTitle) {
        if (reportTitle == null || reportTitle.isEmpty()) {
            reportTitle = (String)this.parameters.get("report.title");
        }
        csvWriter.writeLine(reportTitle == null ? "" : reportTitle);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm");
        csvWriter.writeLine(Messages.getString(AbstractReportBuilder.class, "csv.header.date", new Object[]{sdf.format(new Date())}));
        csvWriter.writeLine(Messages.getString(AbstractReportBuilder.class, "csv.header.project", new String[]{this.project}));
        csvWriter.writeLine("");
    }

    protected void buildInputs4Appendix(Set<? extends BaseResourceInput> prgList) {
        Boolean val = (Boolean)this.getReportModel().getProperty("show appendix");
        if (val != null && val.booleanValue()) {
            ElementGroupInfo ds = new ElementGroupInfo("");
            DSFactory factory = new DSFactory();
            SC3DataSource elemDS = null;
            ArrayList<ObjectForSubreport> objList = null;
            ObjectForSubreport obj = null;
            Object selectedApps = this.report.getProperty("filtered by app");
            if (this.isMultiApp() && selectedApps != null && ((Boolean)selectedApps).booleanValue()) {
                this.collectData4AppendixonMultiApp(prgList);
            } else {
                this.collectData4AppendixWhenNoApp(prgList, "ez_no_app");
            }
            ArrayList<String> temp = new ArrayList<String>(this.apps.keySet());
            Collections.sort(temp, String.CASE_INSENSITIVE_ORDER);
            Iterator iterator = temp.iterator();
            while (iterator.hasNext()) {
                ApplicationInputNoGUI app;
                Set progs;
                this.checkStop();
                String appName = (String)iterator.next();
                elemDS = new SC3DataSource();
                elemDS.setLayout(4);
                objList = new ArrayList<ObjectForSubreport>();
                elemDS.setList(objList);
                ds.addDataSource((SubreportDataSource)elemDS);
                if (!"ez_no_app".equals(appName)) {
                    elemDS.setTitle(appName);
                }
                if ((progs = (app = this.apps.get(appName)).getPrograms()) != null) {
                    for (String prgName : progs) {
                        String[] results = new String[]{"", prgName};
                        obj = factory.createObj(1, results, "");
                        objList.add(obj);
                    }
                    continue;
                }
                obj = factory.createObj(1, new String[]{"", ""}, "");
                objList.add(obj);
            }
            this.parameters.put("inputs4Appendix", ds);
            com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subBase.jasper", (String)"inputs4appendixTemplate", (Map)this.parameters);
        }
    }

    protected void collectData4AppendixWhenNoApp(Set<? extends BaseResourceInput> prgList, String groupName) {
        ApplicationInputNoGUI app = new ApplicationInputNoGUI("", "");
        if (groupName != null) {
            this.apps.put(groupName, app);
        }
        Iterator<? extends BaseResourceInput> iterator = prgList.iterator();
        while (iterator.hasNext()) {
            this.checkStop();
            String prgName = iterator.next().getListableName();
            prgName = ReportsUtils.stripNonValidXMLCharacters((String)prgName, (boolean)true);
            app.addProgram(prgName);
        }
    }

    protected void collectData4AppendixonMultiApp(Set<? extends BaseResourceInput> inptList) {
        String noAppStr = "NO_APP";
        for (MultiAppInputNoGUI multiAppInputNoGUI : inptList) {
            if (multiAppInputNoGUI.getApplications() != null && !multiAppInputNoGUI.getApplications().isEmpty()) {
                for (String appName : multiAppInputNoGUI.getApplications()) {
                    ApplicationInputNoGUI app = this.apps.get(appName);
                    if (app == null) {
                        app = new ApplicationInputNoGUI(appName, "");
                        this.apps.put(appName, app);
                    }
                    app.addProgram(multiAppInputNoGUI.getName());
                }
                continue;
            }
            ApplicationInputNoGUI app = this.apps.get(noAppStr);
            if (app == null) {
                app = new ApplicationInputNoGUI(noAppStr, "");
                this.apps.put(noAppStr, app);
            }
            app.addProgram(multiAppInputNoGUI.getName());
        }
        this.addEmptyApplications();
        this.setApplicationName(this.apps.keySet());
    }

    private class CollectorRunnable
    implements IMFRunnable {
        ProgramsVsCollector collector;
        Collection ids;
        String[][] results;

        public CollectorRunnable(ProgramsVsCollector collector, Collection prgIDs) {
            this.collector = collector;
            this.ids = prgIDs;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            this.results = this.collector != null ? this.collector.compute(pmonitor, this.ids, conn) : null;
        }

        public String[][] getResults() {
            return this.results;
        }
    }
}

