/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.reports;

import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.GenericCommonReportBuilder;
import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportInformation;
import com.ez.report.generation.common.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.sf.jasperreports.engine.JasperPrint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuilder
extends GenericCommonReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractBuilder.class);
    protected String project;
    protected ProjectInfo pInfo;
    protected Runnable stopCode;
    protected AbstractReport report;
    protected boolean singleProject = true;
    protected int indicator;
    protected Map<ExtraFileType, List<String>> exportedFiles = new HashMap<ExtraFileType, List<String>>();
    protected Queue<LogMessage> messages = new LinkedList<LogMessage>();

    public static AbstractBuilder getBuilder(String reportName, String settings, String indicator, String project) {
        AbstractBuilder builder = null;
        ReportInformation ri = ReportsRepository.getReportInformation((String)indicator);
        String className = ri.getBuilderClassName();
        Class[] params = new Class[]{String.class, String.class};
        Object[] args = new String[]{reportName, settings};
        builder = (AbstractBuilder)((Object)Utils.instantiate((String)className, (Class[])params, (Object[])args));
        if (builder != null) {
            builder.setProject(project);
            builder.setIndicator(Integer.valueOf(indicator));
        } else {
            L.error("could not instantiate builder for {}", (Object)reportName);
        }
        return builder;
    }

    public void setIndicator(int indicator) {
        this.indicator = indicator;
    }

    public int getIndicator() {
        return this.indicator;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public abstract AbstractReport getReportModel();

    public void setModel(AbstractReport model) {
        this.report = model;
    }

    public void setOpenProject(boolean open) {
        this.singleProject = open;
    }

    public abstract JasperPrint getReportDocument();

    public void addExportedFile(ExtraFileType type, String file) {
        List<String> list = this.exportedFiles.get(type);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(file);
        this.exportedFiles.put(type, list);
    }

    public Map<ExtraFileType, List<String>> getExtraFilesToExport() {
        return this.exportedFiles;
    }

    public void cleanMemory() {
        if (this.report != null && this.report.print != null && this.report.print.getStylesMap() != null) {
            this.report.print.getStylesMap().clear();
            this.report.print = null;
            this.report.mustRegenerate = false;
        }
        if (this.exportedFiles != null) {
            this.exportedFiles.clear();
            this.exportedFiles = null;
        }
        if (this.pInfo != null) {
            this.pInfo = null;
        }
        super.cleanMemory();
    }

    public Queue<LogMessage> getMessages() {
        return this.messages;
    }
}

