/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.model;

import com.ez.ezsource.connection.ProjectInfo;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;

public class Properties {
    public AbstractReport report;
    private String fileName;
    private int reportType;
    public boolean isDefault = false;
    public boolean isGenerated = false;
    public ProjectInfo projInfo;
    private String identificator;
    private String defIdentif;
    public boolean reloadIdentif = true;

    public Properties(AbstractReport rep, String fileName, ProjectInfo projectInfo) {
        this.report = rep;
        this.setFileName(fileName);
        this.projInfo = projectInfo;
    }

    public Properties(String fileName, int reportType, ProjectInfo projectInfo) {
        this.reportType = reportType;
        this.setFileName(fileName);
        this.projInfo = projectInfo;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if ("default".equalsIgnoreCase(fileName)) {
            this.isDefault = true;
        }
    }

    public String getIdentificator() {
        if (this.identificator == null || this.reloadIdentif) {
            this.identificator = this.computeIdentificator();
            this.reloadIdentif = false;
        }
        return this.identificator;
    }

    public String getDefaultIdentificator() {
        if (this.defIdentif == null) {
            StringBuffer idBuf = new StringBuffer();
            idBuf.append("default - ");
            idBuf.append(this.report.identifier);
            idBuf.append("(").append(this.getProjectName()).append(")");
            this.defIdentif = idBuf.toString();
        }
        return this.defIdentif;
    }

    private String computeIdentificator() {
        StringBuffer idBuf = new StringBuffer();
        String name = this.fileName != null && !"".equalsIgnoreCase(this.fileName) ? this.fileName : this.report.name;
        idBuf.append(name).append(" - ");
        idBuf.append(this.report != null ? String.valueOf(this.report.identifier) : String.valueOf(this.reportType));
        idBuf.append("(");
        idBuf.append(this.report != null ? this.report.projectName : this.projInfo.getProjectName());
        idBuf.append(")");
        return idBuf.toString();
    }

    public String getIdentificator(String name, String reportType, String projectName) {
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(name).append(" - ");
        idBuf.append(reportType != null ? reportType : String.valueOf(this.report.identifier));
        idBuf.append("(");
        idBuf.append(projectName != null ? projectName : this.getProjectName());
        idBuf.append(")");
        return idBuf.toString();
    }

    public String getName() {
        return this.fileName != null && !"".equals(this.fileName) ? (this.fileName.equals("default") ? "default properties" : this.fileName) : this.report.name;
    }

    public String getTitle() {
        String name = this.getFileName() != null && !"".equals(this.getFileName()) ? this.getFileName() : this.report.name;
        return Messages.getString(Properties.class, "view.title", new String[]{this.report.getType(), name, this.getProjectName()});
    }

    public String getProjectName() {
        String name = null;
        if (this.report != null && this.report.projectName != null) {
            name = this.report.projectName;
        } else if (this.projInfo != null && this.projInfo.getProjectName() != null) {
            name = this.projInfo.getProjectName();
        }
        return name;
    }
}

