/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.model;

import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportInformation;
import com.ez.report.generation.common.utils.Utils;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JasperPrint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReport
implements Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractReport.class);
    private static final long serialVersionUID = 2L;
    public static final String INPUTS = "inputs";
    public static final String SETTINGS_FILE = "settings file";
    public static final String SHOW_ONLY_SUMMARY = "show summary only";
    public static final String SHOW_APPENDIX = "show appendix";
    public static final String HIDE_IMAGES = "hide images";
    public static final String FILTERED_BY_APPLICATION = "filtered by app";
    public static final String SELECTED_APPLICATIONS = "selected app";
    public static final String TOTAL_NUMBER_OF_POSSIBLE_INPUTS = "totalResources";
    public static final String PDF_METADATA_TITLE = "pdf_metadata_title";
    public static final String PDF_METADATA_AUTHOR = "pdf_metadata_author";
    public static final String PDF_HYPERLINK_EXPORTER = "pdf_hyperlink_export";
    public static final String DOCX_HYPERLINK_EXPORTER = "docx_hyperlink_export";
    public static final String SELECTED_APPLICATION_NAMES = "selected app names";
    public JasperPrint print;
    public int identifier = -1;
    public String name;
    public Map properties;
    public String projectName;
    public String time;
    public boolean mustRegenerate = true;
    protected boolean allResources = true;
    public boolean hasPostBuild = false;

    public void setInput(Object input) {
        TreeSet<Object> inpts;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((inpts = (TreeSet<Object>)this.properties.get(INPUTS)) == null) {
            inpts = new TreeSet<Object>();
        }
        if (input instanceof Collection) {
            inpts.addAll((Collection)input);
        } else if (input != null) {
            inpts.add(input);
        }
        this.properties.put(INPUTS, inpts);
    }

    public void addProperty(String propertyKey, Object propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(propertyKey, propertyValue);
    }

    public Object getProperty(String propertyKey) {
        return this.properties != null ? this.properties.get(propertyKey) : null;
    }

    public String getType() {
        return ReportsRepository.getReportInformation((int)this.identifier).getReportName();
    }

    public String computeIndentifier() {
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(this.name).append(" - ");
        idBuf.append(this.time);
        idBuf.append("(").append(this.projectName).append(")");
        return idBuf.toString();
    }

    public abstract String getTitle();

    public abstract void loadPropertiesFromFile(File var1);

    public abstract void loadPropertiesFromFile(String var1);

    public static AbstractReport getReportFor(String indicator, String prjName) {
        AbstractReport report = null;
        ReportInformation ri = ReportsRepository.getReportInformation((String)indicator);
        if (ri != null) {
            Class[] params = new Class[]{String.class};
            Object[] args = new String[]{prjName};
            report = (AbstractReport)Utils.instantiate((String)ri.getReportClassName(), (Class[])params, (Object[])args);
        }
        return report;
    }

    public boolean useAllResources() {
        return this.allResources;
    }

    public String getMetadataTitle() {
        return this.getTitle();
    }

    public Collection getSelectedApplications() {
        return (Set)this.getProperty(SELECTED_APPLICATIONS);
    }

    public static String getGenDate(AbstractReport report) {
        report.time = String.valueOf(Calendar.getInstance().getTimeInMillis());
        long time = Long.valueOf(report.time);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        String strDate = String.valueOf(c.get(1)).concat("_").concat(String.valueOf(c.get(2) + 1)).concat("_").concat(String.valueOf(c.get(5))).concat("_").concat(String.valueOf(c.get(11))).concat("_").concat(String.valueOf(c.get(12))).concat("_").concat(String.valueOf(c.get(13)));
        L.debug("date in name: {}", (Object)strDate);
        return strDate;
    }

    public static String generateName(AbstractReport report) {
        String strDate = AbstractReport.getGenDate(report);
        return report.projectName.concat("_").concat(report.getTitle()).concat("_").concat(strDate);
    }
}

