/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.weight;

import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ezreport.reports.threshold.ThresholdAbstractReportBuilder;
import com.ez.report.application.ezreport.reports.weight.Obj4WeightReport;
import com.ez.report.application.ezreport.reports.weight.Obj4WeightReportComparator;
import com.ez.report.application.ezreport.reports.weight.WeightReport;
import com.ez.report.application.ezreport.reports.weight.WeightStmtDataSource;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.model.HeadingBeanComparator;
import com.ez.report.generation.common.utils.RGB;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightReportBuilder
extends ThresholdAbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(WeightReportBuilder.class);
    private static final String STORED_PROCEDURE = "EZViewer_Heuristic";
    private static final String DEFAULT_WEIGHT = "1";
    private String greaterPrg = "";
    private Properties defaultProp;

    public WeightReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected void initializeFromPreferences() {
        try {
            String simpleThresholdFromModel = (String)this.report.getProperty("simpleThresholdPreference");
            this.firstPrag = simpleThresholdFromModel != null ? Integer.parseInt(simpleThresholdFromModel) : Utils.DEF_COMPLEXITY_SIMPLE;
            String moderateThresholdFromModel = (String)this.report.getProperty("mediumThresholdPreference");
            this.secondPrag = moderateThresholdFromModel != null ? Integer.parseInt(moderateThresholdFromModel) : Utils.DEF_COMPLEXITY_MEDIUM;
            String color = (String)this.report.getProperty("simpleColorPreference");
            RGB rgbColor = null;
            rgbColor = color != null ? Utils.asRGB(color) : Utils.DEF_COMPLEXITY_SIMPLE_COLOR;
            this.firstColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            color = (String)this.report.getProperty("mediumColorPreference");
            rgbColor = color != null ? Utils.asRGB(color) : Utils.DEF_COMPLEXITY_MEDIUM_COLOR;
            this.secondColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            color = (String)this.report.getProperty("complexColorPreference");
            rgbColor = color != null ? Utils.asRGB(color) : Utils.DEF_COMPLEXITY_COMPLEX_COLOR;
            this.thirdColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            this.parameters.put("simplePragValue", new Integer(this.firstPrag));
            this.parameters.put("moderatePragValue", new Integer(this.secondPrag));
        }
        catch (NumberFormatException e) {
            L.error("error at initializind report parameters from report properties", (Throwable)e);
        }
    }

    @Override
    protected void data(IProgressMonitor pmonitor) {
        this.initializeFromPreferences();
        this.writeCSVThresHolds();
        this.clearForJasperReport();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        HashMap<Integer, ProgramInputNoGUI> inputMap = new HashMap<Integer, ProgramInputNoGUI>();
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        Set<Integer> selectedIds = this.processInputs(prgList, inputMap, temp);
        this.checkStop();
        int no = prgList.size();
        this.parameters.put("prgNumber", new Integer(no));
        this.parameters.put("inputResourcesCount", Messages.getString(WeightReportBuilder.class, "resources.lbl", new Object[]{no}));
        this.buildInputs4Appendix(prgList);
        prgList = null;
        Boolean showAppendix = (Boolean)this.getReportModel().getProperty("show appendix");
        Boolean showWeights = (Boolean)this.getReportModel().getProperty("showWeights");
        if (showAppendix.booleanValue() && showWeights.booleanValue()) {
            this.buildWeights4Appendix();
        }
        this.parameters.put("title.appFieldValues", this.applicationsName);
        this.checkStop();
        String[][] repResults = null;
        Map stmsMap = com.ez.mainframe.data.utils.Utils.readStmtTypes();
        if (stmsMap != null) {
            IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
            try {
                ComputeWithLock runn = new ComputeWithLock(selectedIds);
                ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pmonitor));
                repResults = runn.results;
            }
            catch (InterruptedException interruptedException) {
                throw new CanceledException("connection interrupted");
            }
            catch (ExecutionException e) {
                ErrorUtils.handleExecutionException((ExecutionException)e);
            }
        } else {
            L.warn("no statements, procedure was not called!");
        }
        Map<String, List<StmtType>> results = null;
        if (repResults == null || stmsMap == null) {
            L.warn("no results from HEURISTIC");
        } else {
            L.debug("processing raw HEURISTIC results");
            results = this.processDBResults(repResults, stmsMap, inputMap, temp);
            repResults = null;
        }
        temp = null;
        inputMap = null;
        if (results != null) {
            this.addOtherInfosInCVS();
            this.processResults(results);
            results.clear();
            results = null;
        }
        this.checkStop();
        this.finalCalculations();
    }

    @Override
    protected void addOtherInfosInCVS() {
        if (this.csvWriter != null) {
            this.csvWriter.write(new String[]{Messages.getString(WeightReportBuilder.class, "programs.column.title"), Messages.getString(((Object)((Object)this)).getClass(), "stmt.column.title"), Messages.getString(((Object)((Object)this)).getClass(), "number.column.title"), Messages.getString(((Object)((Object)this)).getClass(), "weight.column.title"), Messages.getString(((Object)((Object)this)).getClass(), "complexity.label")});
        }
    }

    private Set<Integer> processInputs(Set<ProgramInputNoGUI> prgList, Map<Integer, ProgramInputNoGUI> inputMap, Map<String, Integer> temp) {
        HashSet<Integer> selectedIds = new HashSet<Integer>();
        for (ProgramInputNoGUI prg : prgList) {
            if (prg == null) continue;
            if (prg.getTypeCode() == 8) {
                Collection childerenIds = prg.getChildrenIDs();
                if (childerenIds != null && !childerenIds.isEmpty()) {
                    selectedIds.addAll(childerenIds);
                    for (Integer id : childerenIds) {
                        temp.put(id.toString(), prg.getResourceID());
                    }
                } else {
                    L.warn("assembler program without children?! {}", (Object)prg.getName());
                    selectedIds.add(prg.getResourceID());
                }
            } else {
                selectedIds.add(prg.getResourceID());
            }
            inputMap.put(prg.getProgramID(), prg);
        }
        return selectedIds;
    }

    private void finalCalculations() {
        Collections.sort(this.resultList, new Obj4WeightReportComparator());
        if (this.scores != null && this.scores.size() > 1) {
            this.putSubreportStream("reports/EZReportScoresReport.jasper", "ScoresSubreport");
            Collections.sort(this.scores, new HeadingBeanComparator(false));
            this.parameters.put("scoresValues", this.scores);
            this.parameters.put("scores.title", Messages.getString(WeightReportBuilder.class, "scores.page.title"));
            this.parameters.put("programs.column.title", Messages.getString(WeightReportBuilder.class, "programs.column.title"));
            this.parameters.put("scores.column.title", Messages.getString(WeightReportBuilder.class, "scores.column.title"));
        }
        if (this.result4BarChart.keySet() != null && this.result4BarChart.keySet().size() > 1) {
            this.checkStop();
            this.createStackedBarChartImage(Messages.getString(WeightReportBuilder.class, "bar.diagram.title"), true);
            this.checkStop();
            this.parameters.put("weightPie", this.createPieChartImage(Messages.getString(WeightReportBuilder.class, "pie.title")));
        } else {
            this.parameters.put("SubreportStream", null);
        }
    }

    private Map<String, List<StmtType>> processDBResults(String[][] repResults, Map stmsMap, Map<Integer, ProgramInputNoGUI> inputMap, Map<String, Integer> family) {
        HashMap<String, List<StmtType>> results = new HashMap<String, List<StmtType>>();
        HashMap temp2 = new HashMap();
        int i = 0;
        while (i < repResults.length) {
            HashMap<Integer, StmtType> stmts;
            this.checkStop();
            String prgID = repResults[i][0];
            Integer parentID = family.get(prgID);
            Integer key = parentID != null ? parentID : Integer.valueOf(prgID);
            ProgramInputNoGUI pi = inputMap.get(key);
            String prgName = pi.getListableName();
            ArrayList<StmtType> stmsList = (ArrayList<StmtType>)results.get(prgName);
            if (stmsList == null) {
                stmsList = new ArrayList<StmtType>();
                results.put(prgName, stmsList);
            }
            if ((stmts = (HashMap<Integer, StmtType>)temp2.get(key)) == null) {
                stmts = new HashMap<Integer, StmtType>();
                temp2.put(key, stmts);
            }
            try {
                L.debug("processing results of program: {}, with id={}", (Object)prgName, (Object)prgID);
                Integer stmtType = null;
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)repResults[i][1]) == null) {
                    L.warn("null stmtType for program: {}; statements count: {}", (Object)prgName, (Object)repResults[i][2]);
                } else {
                    stmtType = Integer.valueOf(repResults[i][1]);
                }
                StmtType dbStmtType = (StmtType)stmsMap.get(stmtType);
                if (dbStmtType != null) {
                    StmtType newStmtType = (StmtType)stmts.get(stmtType);
                    if (newStmtType == null) {
                        newStmtType = new StmtType(dbStmtType.getId(), dbStmtType.getName());
                        stmts.put(stmtType, newStmtType);
                        stmsList.add(newStmtType);
                    }
                    int c = newStmtType.getCount();
                    newStmtType.setCount(c + Integer.valueOf(repResults[i][2]));
                    L.debug("program: {}", (Object)prgName);
                    L.debug("programId: {}", (Object)repResults[i][0]);
                    L.debug("statement type: {}", (Object)repResults[i][1]);
                    L.debug("stmt: {}", (Object)dbStmtType);
                    L.debug("statements count: {}", (Object)repResults[i][2]);
                    L.debug("statements count all: {}", (Object)newStmtType.getCount());
                    L.debug(" --------------- ");
                }
            }
            catch (NumberFormatException nfe) {
                L.error("error at parsing results from stored procedure", (Throwable)nfe);
            }
            ++i;
        }
        temp2 = null;
        return results;
    }

    private void buildWeights4Appendix() {
        List availableGroups = com.ez.mainframe.data.utils.Utils.readAvailableStmtGroups((int)5, (ProjectInfo)this.pInfo);
        Iterator availableGroupsIt = availableGroups.iterator();
        HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
        String weight = Messages.getString(WeightReportBuilder.class, "weight.lbl");
        boolean isCustom = false;
        while (availableGroupsIt.hasNext()) {
            StmtGroup group = (StmtGroup)availableGroupsIt.next();
            Set stmtTypes = group.getTypes();
            for (StmtType stmtType : stmtTypes) {
                String name = stmtType.getListableName();
                String value = this.getWeightValue(stmtType);
                Integer intWeight = new Integer(value);
                if (intWeight > 0) {
                    String str;
                    if (intWeight > Integer.valueOf(DEFAULT_WEIGHT)) {
                        isCustom = true;
                    }
                    if ((str = (String)tempMap.get(intWeight)) == null) {
                        str = "\n     " + weight + " " + value + ": ";
                        str = String.valueOf(str) + name;
                    } else {
                        str = String.valueOf(str) + ", " + name;
                    }
                    tempMap.put(intWeight, str);
                    continue;
                }
                L.info("stmt {} was skipped because has weight={}", (Object)name, (Object)intWeight);
                isCustom = true;
            }
        }
        StringBuffer buff4WeightAnex = new StringBuffer();
        if (isCustom) {
            ArrayList temp = new ArrayList(tempMap.keySet());
            Collections.sort(temp);
            Iterator iterator = temp.iterator();
            while (iterator.hasNext()) {
                Integer weightValue = (Integer)iterator.next();
                String text = (String)tempMap.remove(weightValue);
                buff4WeightAnex.append(text);
                if (!iterator.hasNext()) continue;
                buff4WeightAnex.append("\n");
            }
        } else {
            buff4WeightAnex.append(Messages.getString(WeightReportBuilder.class, "appendix.onlyDefaultWeights", new String[]{DEFAULT_WEIGHT}));
        }
        this.parameters.put("inputWeights", buff4WeightAnex.toString());
    }

    @Override
    protected String getWizardTitle() {
        return Messages.getString(WeightReportBuilder.class, "wizzard.title");
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        boolean showWeights = (Boolean)this.getReportModel().getProperty("showWeights");
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            params.put("showWeights", Boolean.TRUE.equals(params.get("showAppendix")) ? showWeights : Boolean.FALSE);
            params.put("showTOC", Boolean.FALSE);
        } else {
            params.put("showWeights", showWeights);
            params.put("showTOC", Boolean.TRUE);
        }
        String externalized = Messages.getString(WeightReportBuilder.class, "stmt.column.title");
        params.put("stmtName", externalized);
        externalized = Messages.getString(WeightReportBuilder.class, "number.column.title");
        params.put("stmtNr", externalized);
        externalized = Messages.getString(WeightReportBuilder.class, "weight.column.title");
        params.put("stmtWeight", externalized);
        externalized = Messages.getString(WeightReportBuilder.class, "count.stmt.label");
        params.put("countLabel", externalized);
        externalized = Messages.getString(WeightReportBuilder.class, "total.weight.label");
        params.put("totalLabel", externalized);
        externalized = Messages.getString(WeightReportBuilder.class, "weights.summary.lbl");
        params.put("weightsSummary", externalized);
        externalized = Messages.getString(WeightReportBuilder.class, "summary2.lbl");
        params.put("summ2.lbl", externalized);
    }

    private void processResults(Map results) {
        int sum = 0;
        Iterator iRes = results.keySet().iterator();
        while (iRes.hasNext()) {
            this.checkStop();
            String prgName = (String)iRes.next();
            Integer value = this.countStmts4Report(prgName, results);
            this.result4BarChart.put(prgName, value);
            sum += value.intValue();
        }
        int nr = results.size();
        BigDecimal divisor = nr != 0 ? new BigDecimal(nr) : BigDecimal.valueOf(1L);
        double average = new BigDecimal(sum).divide(divisor, 2, 6).doubleValue();
        L.debug("average: {} --- for sum={} of {} programs", new Object[]{average, sum, nr});
        this.parameters.put("report.average", String.valueOf(average));
        if (!this.greaterPrg.equals("")) {
            Object[] msgParams = new String[]{this.greaterPrg, String.valueOf(new Float(this.maxWeight).intValue())};
            String paramValue = Messages.getString(WeightReportBuilder.class, "mostComplexPrg.lbl", msgParams);
            this.parameters.put("summ3.lbl", paramValue);
        }
    }

    private Integer countStmts4Report(String program, Map results) {
        int result = 0;
        List stmts = (List)results.get(program);
        String resourceType = Messages.getString(WeightReportBuilder.class, "resource.name");
        String fileName = program;
        if (stmts == null || stmts.size() == 0) {
            Obj4WeightReport dataSourceObj = new Obj4WeightReport(resourceType, fileName, this.getRegionString(result));
            this.resultList.add(dataSourceObj);
            Integer score = new Integer(result);
            this.addScore(fileName, score);
            return score;
        }
        Iterator stmtsIt = stmts.iterator();
        int count = 0;
        String type = null;
        int stmtTypeCount = 0;
        Obj4WeightReport.StmtTypesCount total = new Obj4WeightReport.StmtTypesCount();
        int weight = 1;
        while (stmtsIt.hasNext()) {
            StmtType currentType = (StmtType)stmtsIt.next();
            count = currentType.getCount();
            type = currentType.getName();
            weight = Integer.parseInt(this.getWeightValue(currentType));
            if (this.csvWriter != null) {
                this.csvWriter.write(new String[]{fileName, type, String.valueOf(count), String.valueOf(weight), this.getRegionString(result)});
            }
            Obj4WeightReport dataSourceObj = new Obj4WeightReport(resourceType, fileName, type, new Integer(count), new Integer(weight), total, stmtTypeCount);
            result += count * weight;
            this.resultList.add(dataSourceObj);
            ++stmtTypeCount;
        }
        Integer score = new Integer(result);
        this.resultList.add(new Obj4WeightReport(resourceType, fileName, score, this.getRegionString(result)));
        this.addScore(fileName, score);
        if ((double)result > this.maxWeight) {
            this.maxWeight = result;
            this.greaterPrg = fileName;
        } else if ((double)result == this.maxWeight) {
            this.greaterPrg = this.greaterPrg.concat(", ").concat(fileName);
        }
        total.setStmtTypesCount(new Integer(stmtTypeCount));
        return score;
    }

    private String getWeightValue(StmtType type) {
        String propValue;
        if (this.defaultProp == null) {
            this.defaultProp = (Properties)this.inputs.get("settings");
        }
        String string = propValue = this.report.getProperty(type.getId().toString()) != null ? (String)this.report.getProperty(type.getId().toString()) : this.defaultProp.getProperty(type.getId().toString());
        if (propValue == null) {
            propValue = DEFAULT_WEIGHT;
        }
        return propValue;
    }

    @Override
    protected AbstractReport getReport() {
        return new WeightReport(this.project);
    }

    @Override
    protected void addAppendixProperties(AbstractReport report) {
        super.addAppendixProperties(report);
        Boolean value = (Boolean)this.inputs.get("showWeights");
        if (value == null) {
            value = false;
        }
        report.addProperty("showWeights", (boolean)value);
    }

    @Override
    protected AbstractReportDataSource getReportDataSource() {
        return new WeightStmtDataSource(this.resultList);
    }

    @Override
    public void cleanMemory() {
        this.defaultProp = null;
        this.greaterPrg = null;
        super.cleanMemory();
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/weight_withTOC.jasper";
    }

    @Override
    protected String getDomainAxis4VerticalChart() {
        return Messages.getString(((Object)((Object)this)).getClass(), "procent.of.label");
    }

    class ComputeWithLock
    implements IMFRunnable {
        String[][] results;
        private Set<Integer> selectedIds;

        public ComputeWithLock(Set<Integer> selectedIds) {
            this.selectedIds = selectedIds;
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            try {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.selectedIds.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                this.results = conn.execNonTransactionalStoredProc(WeightReportBuilder.STORED_PROCEDURE, new String[0], types, new ArrayList<Integer>(this.selectedIds));
            }
            catch (Throwable t) {
                L.error("error at executing stored procedure", t);
                WeightReportBuilder.this.messages.add(new LogMessage(Messages.getString(WeightReportBuilder.class, "storeProcedureError.logMessage"), 4, "com.ez.mainframe.reports.core", t));
            }
        }
    }
}

