/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.threshold;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.computation.McCabeValue;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ezreport.reports.threshold.ThresholdAbstractReport;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.model.HeadingBean;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThresholdAbstractReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ThresholdAbstractReportBuilder.class);
    protected static final String COUNT_AVAILABLE_4CYCLOMATIC_PROGRAMS_QUERY = "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 10, 11, 13, 14, 15, 16,19) ";
    protected List resultList = null;
    String viewTabLabel = "";
    protected int firstPrag = 0;
    protected int secondPrag = 0;
    protected String firstString = Messages.getString(ThresholdAbstractReportBuilder.class, "diagram.simple.prag");
    protected String secondString = Messages.getString(ThresholdAbstractReportBuilder.class, "diagram.moderate.prag");
    protected String thirdString = Messages.getString(ThresholdAbstractReportBuilder.class, "diagram.complex.prag");
    protected Color firstColor = null;
    protected Color secondColor = null;
    protected Color thirdColor = null;
    protected double maxWeight = 0.0;
    private Color GREEN_COLOR = new Color(166, 203, 149);
    private String settingsName = null;
    private JFreeChart pieChart;
    private Font labelFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)10, (boolean)false);
    private Font titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)14, (boolean)false);
    private int firstThresholdCount = 0;
    private int secondThresholdCount = 0;
    private int thirdThresholdCount = 0;
    protected Map result4BarChart = null;
    protected List scores = null;
    protected CSVWriter csvWriter;

    public ThresholdAbstractReportBuilder(String reportName, String settings) {
        this.report = null;
        this.settingsName = settings != null && "default".equalsIgnoreCase(settings) ? settings : "default";
        this.result4BarChart = new HashMap();
        this.scores = new ArrayList();
        this.resultList = new LinkedList();
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        boolean showSummaryOnly;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ThresholdAbstractReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        this.csvWriter = this.initTempCSVFile();
        if (this.csvWriter != null) {
            this.writeCSVHeader(this.csvWriter, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        this.data((IProgressMonitor)monitor.newChild(100));
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        if (showSummaryOnly = ((Boolean)this.getReportModel().getProperty("show summary only")).booleanValue()) {
            return null;
        }
        AbstractReportDataSource dataSource = this.getReportDataSource();
        return dataSource;
    }

    protected void writeCSVThresHolds() {
        if (this.csvWriter != null) {
            this.csvWriter.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "thresholds.summary.lbl"));
            this.csvWriter.write(new String[]{this.firstString, "0 .. " + String.valueOf(this.firstPrag)});
            this.csvWriter.write(new String[]{this.secondString, String.valueOf(String.valueOf(this.firstPrag)) + " .. " + String.valueOf(this.secondPrag)});
            this.csvWriter.write(new String[]{this.thirdString, ">" + String.valueOf(this.secondPrag)});
            this.csvWriter.writeLine("");
        }
    }

    protected void addOtherInfosInCVS() {
        if (this.csvWriter != null) {
            this.csvWriter.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "programs.column.title"), Messages.getString(((Object)((Object)this)).getClass(), "value.lbl"), Messages.getString(((Object)((Object)this)).getClass(), "complexity.label")});
        }
    }

    protected abstract AbstractReportDataSource getReportDataSource();

    @Override
    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ThresholdAbstractReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/weight_subreport.jasper", (String)"SubreportStream", (Map)this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    protected abstract void initializeFromPreferences();

    protected abstract void data(IProgressMonitor var1);

    protected abstract AbstractReport getReport();

    protected String getRegionString(int value) {
        String region = "";
        region = value <= this.firstPrag ? this.firstString : (value <= this.secondPrag ? this.secondString : this.thirdString);
        return region;
    }

    protected void clearForJasperReport() {
        this.resultList.clear();
        this.viewTabLabel = "";
        this.result4BarChart.clear();
        this.scores.clear();
        this.firstThresholdCount = 0;
        this.secondThresholdCount = 0;
        this.thirdThresholdCount = 0;
        this.parameters.put("weightChartVertical", null);
        this.parameters.put("weightPie", null);
        this.GREEN_COLOR = null;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = null;
        boolean showInputs = (Boolean)this.getReportModel().getProperty("showInputDetails");
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            externalized = Messages.getString(((Object)((Object)this)).getClass(), "onlySummaryReport.title");
            params.put("report.title", externalized);
            params.put("summary", null);
            Boolean val = (Boolean)this.getReportModel().getProperty("show appendix");
            params.put("showAppendix", val);
            params.put("showInputs", Boolean.TRUE.equals(val) ? showInputs : Boolean.FALSE);
            params.put("showTOC", Boolean.FALSE);
        } else {
            externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
            params.put("report.title", externalized);
            externalized = Messages.getString(((Object)((Object)this)).getClass(), "reportSummary.lbl");
            params.put("summary", externalized);
            params.put("showAppendix", Boolean.TRUE);
            params.put("showInputs", showInputs);
            params.put("showTOC", Boolean.TRUE);
        }
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "summary1.lbl");
        params.put("summ1.lbl", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "value.lbl");
        params.put("countLabel", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "complexity.label");
        params.put("complexityLabel", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "thresholds.summary.lbl");
        params.put("thresholdsSummary", externalized);
        params.put("simple.prag", this.firstString);
        params.put("moderate.prag", this.secondString);
        params.put("complex.prag", this.thirdString);
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = this.getReport();
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput(prgList);
            Boolean value = (Boolean)this.inputs.get("show summary only");
            value = value != null ? value : false;
            this.report.addProperty("show summary only", value);
            this.addAppendixProperties(this.report);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", selectedApps != null);
            Properties prop = (Properties)this.inputs.get("settings");
            if (prop == null) {
                ((ThresholdAbstractReport)this.report).loadPropertiesFromFile(this.settingsName);
            } else {
                ((ThresholdAbstractReport)this.report).saveSettingsInModel(prop);
            }
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
        if (print != null) {
            JRStyle[] styles = print.getStyles();
            JRStyle customStyle = null;
            int i = 0;
            while (i < styles.length) {
                JRStyle st = styles[i];
                if ("colorStyle".equalsIgnoreCase(st.getName())) {
                    customStyle = styles[i];
                    i = styles.length + 1;
                }
                ++i;
            }
            if (customStyle != null) {
                i = 1;
                while (i < styles.length) {
                    if (styles[i].getName().startsWith("colorStyle|100")) {
                        styles[i].setForecolor(this.firstColor);
                    }
                    if (styles[i].getName().startsWith("colorStyle|010")) {
                        styles[i].setForecolor(this.secondColor);
                    }
                    if (styles[i].getName().startsWith("colorStyle|001")) {
                        styles[i].setForecolor(this.thirdColor);
                    }
                    ++i;
                }
            }
        }
    }

    protected void createStackedBarChartImage(String title, boolean isComplexity) {
        int count0 = 0;
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        int count5 = 0;
        int count6 = 0;
        int count7 = 0;
        int count8 = 0;
        int count9 = 0;
        DefaultCategoryDataset datasetBar = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetCountBar = null;
        ArrayList dbResourceList = new ArrayList(this.result4BarChart.keySet());
        Collections.sort(dbResourceList);
        for (String program : dbResourceList) {
            if (program == null || this.result4BarChart.get(program) == null) continue;
            Integer weight = (Integer)this.result4BarChart.get(program);
            String region = "";
            double value = weight.doubleValue();
            datasetBar.addValue(0.0, (Comparable)((Object)this.firstString), (Comparable)((Object)program));
            datasetBar.addValue(0.0, (Comparable)((Object)this.secondString), (Comparable)((Object)program));
            datasetBar.addValue(0.0, (Comparable)((Object)this.thirdString), (Comparable)((Object)program));
            if (weight <= this.firstPrag) {
                region = this.firstString;
                ++this.firstThresholdCount;
            } else if (weight <= this.secondPrag) {
                region = this.secondString;
                ++this.secondThresholdCount;
            } else {
                region = this.thirdString;
                ++this.thirdThresholdCount;
            }
            datasetBar.addValue(value, (Comparable)((Object)region), (Comparable)((Object)program));
            if (value < this.maxWeight / 10.0) {
                ++count0;
                continue;
            }
            if (value < 2.0 * this.maxWeight / 10.0) {
                ++count1;
                continue;
            }
            if (value < 3.0 * this.maxWeight / 10.0) {
                ++count2;
                continue;
            }
            if (value < 4.0 * this.maxWeight / 10.0) {
                ++count3;
                continue;
            }
            if (value < 5.0 * this.maxWeight / 10.0) {
                ++count4;
                continue;
            }
            if (value < 6.0 * this.maxWeight / 10.0) {
                ++count5;
                continue;
            }
            if (value < 7.0 * this.maxWeight / 10.0) {
                ++count6;
                continue;
            }
            if (value < 8.0 * this.maxWeight / 10.0) {
                ++count7;
                continue;
            }
            if (value < 9.0 * this.maxWeight / 10.0) {
                ++count8;
                continue;
            }
            ++count9;
        }
        if (this.result4BarChart.size() > 15) {
            L.debug("{} {} {} {} {} {} {} {} {} {}", new Object[]{count0, count1, count2, count3, count4, count5, count6, count7, count8, count9});
            datasetCountBar = new DefaultCategoryDataset();
            datasetCountBar.addValue((double)count0, (Comparable)((Object)"region"), (Comparable)((Object)"10%"));
            datasetCountBar.addValue((double)count1, (Comparable)((Object)"region"), (Comparable)((Object)"20%"));
            datasetCountBar.addValue((double)count2, (Comparable)((Object)"region"), (Comparable)((Object)"30%"));
            datasetCountBar.addValue((double)count3, (Comparable)((Object)"region"), (Comparable)((Object)"40%"));
            datasetCountBar.addValue((double)count4, (Comparable)((Object)"region"), (Comparable)((Object)"50%"));
            datasetCountBar.addValue((double)count5, (Comparable)((Object)"region"), (Comparable)((Object)"60%"));
            datasetCountBar.addValue((double)count6, (Comparable)((Object)"region"), (Comparable)((Object)"70%"));
            datasetCountBar.addValue((double)count7, (Comparable)((Object)"region"), (Comparable)((Object)"80%"));
            datasetCountBar.addValue((double)count8, (Comparable)((Object)"region"), (Comparable)((Object)"90%"));
            datasetCountBar.addValue((double)count9, (Comparable)((Object)"region"), (Comparable)((Object)"100%"));
            this.createVerticalChart(title, datasetCountBar, true);
        } else {
            this.createVerticalChart(title, datasetBar, false);
        }
    }

    private void createVerticalChart(String titleStr, DefaultCategoryDataset dataset, boolean isWithPercent) {
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        chart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.black);
        axis.setLabelFont(this.labelFont);
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        ValueAxis valueaxis = plot.getRangeAxis();
        valueaxis.setAxisLinePaint((Paint)Color.black);
        valueaxis.setLabelFont(this.labelFont);
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        renderer.setMaximumBarWidth(0.1);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setBaseOutlinePaint((Paint)Color.LIGHT_GRAY);
        renderer.setSeriesPaint(0, (Paint)this.firstColor);
        renderer.setSeriesPaint(1, (Paint)this.secondColor);
        renderer.setSeriesPaint(2, (Paint)this.thirdColor);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (isWithPercent) {
            String rangeAxisLabel = Messages.getString(ThresholdAbstractReportBuilder.class, "occurrences.label");
            rangeAxis.setLabel(rangeAxisLabel);
            rangeAxis.setUpperMargin(0.1);
            axis.setLabel(this.getDomainAxis4VerticalChart());
            renderer.setSeriesPaint(0, (Paint)this.GREEN_COLOR);
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            renderer.setBaseItemLabelsVisible(true);
            renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition());
            renderer.setBaseItemLabelFont(this.labelFont);
        }
        TextTitle title = new TextTitle(titleStr, this.titleFont);
        chart.setTitle(title);
        BufferedImage img = chart.createBufferedImage(1068, 680, 534.0, 340.0, null);
        this.parameters.put("chartVertical", img);
        this.putSubreportStream("reports/weight_chartVertical.jasper", "SubreportStream1");
    }

    @Override
    protected String getReportTemplatePath() {
        return null;
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    protected abstract String getDomainAxis4VerticalChart();

    protected Image createPieChartImage(String title) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)this.firstString), (Number)new Double(this.firstThresholdCount));
        dataset.setValue((Comparable)((Object)this.secondString), (Number)new Double(this.secondThresholdCount));
        dataset.setValue((Comparable)((Object)this.thirdString), (Number)new Double(this.thirdThresholdCount));
        TextTitle texttitle = new TextTitle(title, this.titleFont);
        PiePlot plot = new PiePlot((PieDataset)dataset);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        plot.setLabelFont(this.labelFont);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setShadowPaint((Paint)Color.white);
        plot.setLabelShadowPaint((Paint)Color.white);
        plot.setInteriorGap(0.1);
        this.pieChart = new JFreeChart(null, this.titleFont, (Plot)plot, true);
        this.pieChart.setTitle(texttitle);
        this.pieChart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legendTitle = this.pieChart.getLegend();
        legendTitle.setItemFont(this.labelFont);
        StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator("{0} {2}");
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setSectionPaint((Comparable)((Object)this.firstString), (Paint)this.firstColor);
        plot.setSectionPaint((Comparable)((Object)this.secondString), (Paint)this.secondColor);
        plot.setSectionPaint((Comparable)((Object)this.thirdString), (Paint)this.thirdColor);
        return this.pieChart.createBufferedImage(790, 432, 395.0, 216.0, null);
    }

    protected Map<String, Integer> computeCyclomatic(SubMonitor monitor, Set<ProgramInputNoGUI> prgList) {
        return this.computeCyclomatic(monitor, prgList, null);
    }

    protected Map<String, Integer> computeCyclomatic(SubMonitor monitor, Set<ProgramInputNoGUI> prgList, EZSourceConnection conn) {
        McCabeValue val = new McCabeValue();
        return val.computeCyclomatic(monitor, prgList, conn);
    }

    protected Map<String, Integer> computeCyclomaticWithLock(Set<ProgramInputNoGUI> prgList, IProgressMonitor monitor) {
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ComputeCyclomatic runn = new ComputeCyclomatic(prgList);
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, monitor);
            return runn.results;
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
            return null;
        }
    }

    protected void addScore(String fileName, Integer score) {
        Boolean val = (Boolean)this.getReportModel().getProperty("show summary only");
        if (!val.booleanValue()) {
            String text = fileName;
            String reference = fileName;
            HeadingBean bean = new HeadingBean(HeadingBean.HEADING_THREE, text, reference, ThresholdAbstractReportBuilder.getScoreReference(reference), new Integer(0), score);
            this.scores.add(bean);
        }
    }

    private static String getScoreReference(String reference) {
        return "score_" + reference;
    }

    protected abstract String getWizardTitle();

    @Override
    protected int getMaxCachedPages() {
        return 2;
    }

    @Override
    public void cleanMemory() {
        this.pieChart = null;
        if (this.result4BarChart != null) {
            this.result4BarChart.clear();
            this.result4BarChart = null;
        }
        this.GREEN_COLOR = null;
        this.firstColor = null;
        this.secondColor = null;
        this.thirdColor = null;
        this.labelFont = null;
        this.titleFont = null;
        this.resultList = null;
        this.scores = null;
        super.cleanMemory();
    }

    @Override
    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms(this.getQueryCount4Wizard(), conn);
    }

    protected String getQueryCount4Wizard() {
        return "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 13, 14, 15, 16) ";
    }

    class ComputeCyclomatic
    implements IMFRunnable {
        Set<ProgramInputNoGUI> inpts;
        Map<String, Integer> results = null;

        public ComputeCyclomatic(Set<ProgramInputNoGUI> inputs) {
            this.inpts = inputs;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            this.results = ThresholdAbstractReportBuilder.this.computeCyclomatic(SubMonitor.convert((IProgressMonitor)pmonitor, (int)20), this.inpts, conn);
        }

        Map<String, Integer> getResults() {
            return this.results;
        }
    }
}

