/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.threshold;

import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.model.Constants;
import java.io.File;
import java.util.Properties;

public abstract class ThresholdAbstractReport
extends AbstractReport {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1L;

    @Override
    public void loadPropertiesFromFile(File f) {
        if (f == null) {
            String analysisName = this.getType();
            String prjPath = Utils.getProjectPathName((String)this.projectName);
            String path = prjPath.concat(File.separator).concat(analysisName).concat(Constants.PATH_SEPARATOR).concat("default.properties");
            f = new File(path);
        }
        this.addProperty("settings file", f.getName().substring(0, f.getName().lastIndexOf(46)));
        Properties prop = Utils.readSettings((File)f);
        this.saveSettingsInModel(prop);
    }

    protected void saveSettingsInModel(Properties prop) {
        this.addProperty("simpleThresholdPreference", prop.getProperty("simpleThresholdPreference"));
        this.addProperty("mediumThresholdPreference", prop.getProperty("mediumThresholdPreference"));
        this.addProperty("simpleColorPreference", prop.getProperty("simpleColorPreference"));
        this.addProperty("mediumColorPreference", prop.getProperty("mediumColorPreference"));
        this.addProperty("complexColorPreference", prop.getProperty("complexColorPreference"));
        for (String string : prop.keySet()) {
            try {
                Integer.parseInt(string);
                this.addProperty(string, prop.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void loadPropertiesFromFile(String settingsFile) {
        File f = null;
        String analysisName = this.getType();
        String prjPath = Utils.getProjectPathName((String)this.projectName);
        if (settingsFile != null && !"".equals(settingsFile)) {
            String path = prjPath.concat(File.separator).concat(analysisName).concat(Constants.PATH_SEPARATOR).concat(settingsFile);
            if (!path.endsWith(".properties")) {
                path = path.concat(".properties");
            }
            f = new File(path);
        } else {
            String path = prjPath.concat(File.separator).concat(analysisName).concat(Constants.PATH_SEPARATOR).concat("default.properties");
            f = new File(path);
        }
        this.loadPropertiesFromFile(f);
    }
}

