/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.maintainabilityIndex;

import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.computation.HalsteadValue;
import com.ez.mainframe.computation.NumberOfStatementsCollector;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ezreport.reports.cyclomatic.CyclomaticDataSource;
import com.ez.report.application.ezreport.reports.cyclomatic.Obj4CyclomaticReportComparator;
import com.ez.report.application.ezreport.reports.maintainabilityIndex.MaintainabilityIdxReport;
import com.ez.report.application.ezreport.reports.threshold.ThresholdAbstractReportBuilder;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.properties.ReportPreferenceUtils;
import com.ez.report.application.reports.all.Obj4CyclomaticReport;
import com.ez.report.application.reports.all.Obj4HalsteadReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.model.HeadingBeanComparator;
import com.ez.report.generation.common.utils.RGB;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainabilityIdxReportBuilder
extends ThresholdAbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MaintainabilityIdxReportBuilder.class);

    public MaintainabilityIdxReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.firstString = Messages.getString(MaintainabilityIdxReportBuilder.class, "diagram.complex.prag");
        this.secondString = Messages.getString(MaintainabilityIdxReportBuilder.class, "diagram.moderate.prag");
        this.thirdString = Messages.getString(MaintainabilityIdxReportBuilder.class, "diagram.simple.prag");
    }

    @Override
    protected void initializeFromPreferences() {
        try {
            String simpleThresholdFromModel = (String)this.report.getProperty("simpleThresholdPreference");
            this.firstPrag = simpleThresholdFromModel != null ? Integer.parseInt(simpleThresholdFromModel) : ReportPreferenceUtils.DEF_MAINTAINABILITY_DIFFICULT;
            String moderateThresholdFromModel = (String)this.report.getProperty("mediumThresholdPreference");
            this.secondPrag = moderateThresholdFromModel != null ? Integer.parseInt(moderateThresholdFromModel) : ReportPreferenceUtils.DEF_MAINTAINABILITY_MEDIUM;
            String color = (String)this.report.getProperty("simpleColorPreference");
            RGB rgbColor = null;
            rgbColor = color != null ? Utils.asRGB(color) : ReportPreferenceUtils.DEF_MAINTAINABILITY_DIFFICULT_COLOR;
            this.firstColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            color = (String)this.report.getProperty("mediumColorPreference");
            rgbColor = color != null ? Utils.asRGB(color) : ReportPreferenceUtils.DEF_MAINTAINABILITY_MEDIUM_COLOR;
            this.secondColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            color = (String)this.report.getProperty("complexColorPreference");
            rgbColor = color != null ? Utils.asRGB(color) : ReportPreferenceUtils.DEF_MAINTAINABILITY_EASY_COLOR;
            this.thirdColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            this.parameters.put("simplePragValue", new Integer(this.firstPrag));
            this.parameters.put("moderatePragValue", new Integer(this.secondPrag));
        }
        catch (NumberFormatException e) {
            L.error("error at initializind report parameters from report properties", (Throwable)e);
        }
    }

    @Override
    protected void data(IProgressMonitor pmonitor) {
        this.initializeFromPreferences();
        this.writeCSVThresHolds();
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(MaintainabilityIdxReportBuilder.class, "computeData.taskName"));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        int no = prgList.size();
        this.parameters.put("color", "green");
        this.parameters.put("inputResourcesCount", new Integer(no).toString());
        this.buildInputs4Appendix(prgList);
        this.parameters.put("appendixFirstLineValue", String.valueOf(no));
        this.putSubreportStream("reports/EZReportScoresReport.jasper", "ScoresSubreport");
        this.parameters.put("title.appFieldValues", this.applicationsName);
        monitor.worked(10);
        this.addOtherInfosInCVS();
        HashMap<Integer, Double> maintainabilityResults = new HashMap<Integer, Double>();
        HashMap<Integer, ProgramInputNoGUI> inputMap = new HashMap<Integer, ProgramInputNoGUI>();
        for (ProgramInputNoGUI pi : prgList) {
            maintainabilityResults.put(pi.getProgramID(), 171.0);
            inputMap.put(pi.getProgramID(), pi);
        }
        monitor.setTaskName(Messages.getString(MaintainabilityIdxReportBuilder.class, "prepareData.taskName"));
        monitor.worked(10);
        this.checkStop();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        GetDbData runn = new GetDbData(prgList, inputMap, maintainabilityResults, this.messages);
        try {
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        Map<String, Integer> cyclomaticResults = runn.cyclomaticResults;
        for (Integer prgID : maintainabilityResults.keySet()) {
            this.checkStop();
            ProgramInputNoGUI prgInpt = (ProgramInputNoGUI)inputMap.get(prgID);
            if (prgInpt == null) {
                L.debug("Parent with ID={} was not selected as input. Skip from report.", (Object)prgID);
                continue;
            }
            String prg = prgInpt.getListableName();
            Double value = (Double)maintainabilityResults.get(prgID);
            if (cyclomaticResults != null && cyclomaticResults.containsKey(prg)) {
                value = value - 0.23 * (double)cyclomaticResults.get(prg).intValue();
            }
            if (this.maxWeight < value) {
                this.maxWeight = value;
            }
            int intValue = Math.round(value.floatValue());
            this.csvWriter.write(new String[]{prg, String.valueOf(intValue), this.getRegionString(intValue)});
            Obj4CyclomaticReport obj = new Obj4CyclomaticReport(Messages.getString(MaintainabilityIdxReportBuilder.class, "resource.name"), prg, intValue, this.getRegionString(intValue));
            this.result4BarChart.put(prg, intValue);
            this.resultList.add(obj);
            this.addScore(prg, intValue);
        }
        monitor.setTaskName(Messages.getString(MaintainabilityIdxReportBuilder.class, "processData.taskName"));
        Collections.sort(this.resultList, new Obj4CyclomaticReportComparator());
        if (this.scores != null && this.scores.size() > 1) {
            Collections.sort(this.scores, new HeadingBeanComparator(false));
            this.parameters.put("scoresValues", this.scores);
            this.parameters.put("scores.title", Messages.getString(MaintainabilityIdxReportBuilder.class, "scores.page.title"));
            this.parameters.put("programs.column.title", Messages.getString(MaintainabilityIdxReportBuilder.class, "programs.column.title"));
            this.parameters.put("scores.column.title", Messages.getString(MaintainabilityIdxReportBuilder.class, "scores.column.title"));
        }
        this.checkStop();
        if (this.result4BarChart.keySet() != null && this.result4BarChart.keySet().size() > 1) {
            String title = Messages.getString(MaintainabilityIdxReportBuilder.class, "bar.diagram.title");
            this.createStackedBarChartImage(title, false);
            this.checkStop();
            String pieTitle = Messages.getString(MaintainabilityIdxReportBuilder.class, "pie.title");
            this.parameters.put("mcCabePie", this.createPieChartImage(pieTitle));
        } else {
            this.parameters.put("SubreportStream", null);
        }
        monitor.worked(10);
        monitor.setWorkRemaining(0);
    }

    private SubMonitor extractStmtNo(SubMonitor monitor, Map<Integer, Double> maintainabilityResults, String[][] numberOfStatements, int position) {
        SubMonitor resMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(40), (int)numberOfStatements.length);
        int i = 0;
        while (i < numberOfStatements.length) {
            String prgName = numberOfStatements[i][0];
            String stmtCount = numberOfStatements[i][position];
            String prgID = numberOfStatements[i][position + 1];
            L.debug("program: {}", (Object)prgName);
            L.debug("numberOfStatements value: {}", (Object)stmtCount);
            L.debug("\n");
            if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)stmtCount) != null && !stmtCount.equals("0")) {
                Double existing = maintainabilityResults.get(Integer.valueOf(prgID));
                if (existing == null) {
                    existing = new Double(0.0);
                    L.warn("null value for programname={}", (Object)prgName);
                }
                maintainabilityResults.put(Integer.valueOf(prgID), existing - 16.2 * Math.log(Integer.valueOf(stmtCount).intValue()));
            }
            resMonitor.worked(1);
            ++i;
        }
        return resMonitor;
    }

    @Override
    protected AbstractReport getReport() {
        return new MaintainabilityIdxReport(this.project);
    }

    @Override
    protected AbstractReportDataSource getReportDataSource() {
        return new CyclomaticDataSource(this.resultList);
    }

    @Override
    protected String getWizardTitle() {
        return Messages.getString(MaintainabilityIdxReportBuilder.class, "wizzard.title");
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/threshold.jasper";
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    @Override
    protected String getQueryCount4Wizard() {
        return "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 10, 11, 13, 14, 15, 16,19) ";
    }

    @Override
    protected String getDomainAxis4VerticalChart() {
        return Messages.getString(((Object)((Object)this)).getClass(), "procent.of.label");
    }

    class GetDbData
    implements IMFRunnable {
        private Set<ProgramInputNoGUI> prgList;
        private Map<Integer, Double> maintainabilityResults;
        private Map<Integer, ProgramInputNoGUI> inputMap;
        private Queue<LogMessage> messages;
        Map<String, Integer> cyclomaticResults;

        public GetDbData(Set<ProgramInputNoGUI> inputs, Map<Integer, ProgramInputNoGUI> inputMap, Map<Integer, Double> maintainabilityResults, Queue<LogMessage> msg) {
            this.prgList = inputs;
            this.maintainabilityResults = maintainabilityResults;
            this.inputMap = inputMap;
            this.messages = msg;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            monitor.setTaskName(Messages.getString(MaintainabilityIdxReportBuilder.class, "getData.taskName"));
            HalsteadValue hVal = new HalsteadValue(!MaintainabilityIdxReportBuilder.this.runInBatch, MaintainabilityIdxReportBuilder.this.project);
            hVal.setReportProperties(((MaintainabilityIdxReportBuilder)MaintainabilityIdxReportBuilder.this).report.properties);
            String[][] halResults = hVal.computeHalsteadResults(monitor, this.prgList, MaintainabilityIdxReportBuilder.this.parameters, this.inputMap, MaintainabilityIdxReportBuilder.this.pInfo, conn);
            Queue mess = hVal.getMessages();
            if (mess != null && !mess.isEmpty()) {
                this.messages.addAll(mess);
            }
            monitor.worked(30);
            if (halResults == null) {
                L.warn("no results for HALSTEAD values");
            } else {
                L.debug("HALSTEAD results:");
                SubMonitor resMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(40), (int)halResults.length);
                Double zero = 0.0;
                int i = 0;
                while (i < halResults.length) {
                    MaintainabilityIdxReportBuilder.this.checkStop();
                    L.debug("program ID: {}", (Object)halResults[i][0]);
                    L.debug("N1: {}", (Object)halResults[i][1]);
                    L.debug("n1: {}", (Object)halResults[i][2]);
                    L.debug("N2: {}", (Object)halResults[i][3]);
                    L.debug("n2: {}", (Object)halResults[i][4]);
                    L.debug("\n");
                    String prgID = halResults[i][0];
                    ProgramInputNoGUI pi = this.inputMap.get(Integer.valueOf(prgID));
                    String prgName = pi.getListableName();
                    Obj4HalsteadReport obj = new Obj4HalsteadReport(Messages.getString(MaintainabilityIdxReportBuilder.class, "resource.name"), prgName, Integer.valueOf(halResults[i][1]), Integer.valueOf(halResults[i][3]), Integer.valueOf(halResults[i][2]), Integer.valueOf(halResults[i][4]));
                    Double programVolum = (Double)obj.get("V");
                    L.debug("halstead program volum: {}", (Object)programVolum);
                    if (!zero.equals(programVolum) && this.maintainabilityResults.containsKey(Integer.valueOf(prgID))) {
                        Double existing = this.maintainabilityResults.get(Integer.valueOf(prgID));
                        Double d = existing - 5.2 * Math.log(programVolum);
                        this.maintainabilityResults.put(Integer.valueOf(prgID), d);
                    }
                    resMonitor.worked(1);
                    ++i;
                }
                resMonitor.setWorkRemaining(0);
                halResults = null;
            }
            NumberOfStatementsCollector countCls = new NumberOfStatementsCollector();
            String[][] numberOfStatements1 = countCls.compute(conn, this.prgList, (IProgressMonitor)monitor);
            if (numberOfStatements1 == null) {
                L.warn("no results numberOfStatements for maintainability report");
            } else {
                L.debug("MAINTAINABILITY results:");
                if (numberOfStatements1 != null) {
                    SubMonitor resMonitor = MaintainabilityIdxReportBuilder.this.extractStmtNo(monitor, this.maintainabilityResults, numberOfStatements1, 1);
                    resMonitor.setWorkRemaining(0);
                }
            }
            MaintainabilityIdxReportBuilder.this.checkStop();
            this.cyclomaticResults = MaintainabilityIdxReportBuilder.this.computeCyclomatic(monitor, this.prgList, conn);
        }
    }
}

