/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailsDataSource
extends BaseSubreportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DetailsDataSource.class);
    protected ObjectForSubreport3Link currentValue;
    private ArrayList<ObjectForSubreport3Link> values = new ArrayList();
    String col1Title;
    String col2Title;
    String col3Title;
    String titleAnchor;
    String titleTooltip = null;
    String subTitle;
    String subTitle2;
    String subtitleLink;
    Boolean isFirst = null;
    private int type;
    private ElementGroupInfo progDetails;

    public DetailsDataSource(String title, List list, int type) {
        super(title, list);
        this.type = type;
        switch (type) {
            case 3: 
            case 6: 
            case 8: {
                this.columns = 3;
                break;
            }
            case 4: 
            case 5: {
                this.columns = 2;
            }
        }
        if (type == 6) {
            this.isFirst = Boolean.TRUE;
        }
    }

    public DetailsDataSource(int type) {
        this(null, null, type);
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("titleField")) {
            value = this.getTitle();
        } else if (field.getName().equals("parentTOC")) {
            value = null;
        } else if (field.getName().equals("subreportType4TOC")) {
            value = this.tocEntry;
        } else if (field.getName().equals("leftField")) {
            value = this.currentValue.getLeftValue();
        } else if (field.getName().equals("middleField")) {
            value = this.currentValue.getMiddleValue();
        } else if (field.getName().equals("rightField")) {
            value = this.currentValue.getRightValue();
        } else if (field.getName().equals("extraTitle")) {
            value = this.getTitle();
        } else if (field.getName().equals("title.anchor")) {
            value = this.currentValue.getTitleAnchor();
            value = this.titleAnchor;
        } else if (field.getName().equals("column1.title")) {
            value = this.col1Title;
        } else if (field.getName().equals("column2.title")) {
            value = this.col2Title;
        } else if (field.getName().equals("column3.title")) {
            value = this.col3Title;
        } else if (field.getName().equals("leftHyperlink")) {
            value = this.currentValue.getLeftLink();
        } else if (field.getName().equals("leftAnchor")) {
            value = this.currentValue.getLeftAnchor();
        } else if (field.getName().equals("middleAnchor")) {
            value = this.currentValue.getMiddleAnchor();
        } else if (field.getName().equals("middleHyperlink")) {
            value = this.currentValue.getMiddleLink();
        } else if (field.getName().equals("rightHyperlink")) {
            value = this.currentValue.getRightLink();
        } else if (field.getName().equals("subTitle")) {
            L.trace("-------------> subtitle text!!");
            value = this.getSubTitle();
        } else if (field.getName().equals("subTitle2")) {
            value = this.getSubTitle2();
        } else if (field.getName().equals("subtitleHyperlink")) {
            value = this.getSubtitleLink();
        } else if (field.getName().equals("totalsTemplate")) {
            try {
                value = Utils.loadReport((String)"reports/subBase.jasper");
            }
            catch (JRException e) {
                L.error("error at loading programDetails template", (Throwable)e);
            }
        } else if (field.getName().equals("totalsDS")) {
            value = this.progDetails;
        } else if (field.getName().equals("rightAnchor")) {
            value = this.currentValue.getRightAnchor();
        } else if (field.getName().equals("printHeader")) {
            if (this.isFirst != null) {
                value = this.isFirst;
                this.isFirst = Boolean.FALSE;
            }
        } else if (field.getName().equals("leftTooltip")) {
            value = this.currentValue.leftTooltip;
        } else if (field.getName().equals("titleTooltip")) {
            value = this.titleTooltip;
        }
        if (value == null) {
            L.debug("null value for field: {}", (Object)field.getName());
        }
        return value;
    }

    public boolean next() throws JRException {
        this.currentValue = this.getList() != null && this.getList().size() > 0 ? this.getList().remove(0) : null;
        return this.currentValue != null;
    }

    protected void setColumns(int columns) {
        if (columns > 3 || columns < 1) {
            throw new IllegalArgumentException("columns must be in [1,3]");
        }
        this.columns = columns;
    }

    public JRDataSource getDataSource() {
        return this;
    }

    public String getReportName() {
        return "/reports/fieldRenaming_subCols3.jasper";
    }

    public InputStream getReportTemplate() {
        String fileName = 8 == this.type ? "reports/impactDetails_subCols3.jasper" : "reports/fieldRenaming_subCols3.jasper";
        InputStream rs = Utils.getResourceStreamFromPlugin((String)fileName, null);
        return rs;
    }

    public void setCol1Title(String col1Title) {
        this.col1Title = col1Title;
    }

    public void setCol2Title(String col2Title) {
        this.col2Title = col2Title;
    }

    public void setCol3Title(String col3Title) {
        this.col3Title = col3Title;
    }

    public String getTitleAnchor() {
        return this.titleAnchor;
    }

    public void setTitleAnchor(String titleAnchor) {
        this.titleAnchor = titleAnchor;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getSubTitle2() {
        return this.subTitle2;
    }

    public void setSubTitle2(String subTitle2) {
        this.subTitle2 = subTitle2;
    }

    public String getSubtitleLink() {
        return this.subtitleLink;
    }

    public void setSubtitleLink(String subtitleLink) {
        this.subtitleLink = subtitleLink;
    }

    public void setPrgDetails(ElementGroupInfo programDetails) {
        this.progDetails = programDetails;
    }

    public ElementGroupInfo getDatasourceDetails() {
        return this.progDetails;
    }

    public void setTitleTooltip(String tooltip) {
        this.titleTooltip = tooltip;
    }
}

