/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.halstead;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.data.category.CategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalCategoryLabel
extends StandardCategoryItemLabelGenerator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IntervalCategoryLabel.class);
    private Object[] values;
    private static final long serialVersionUID = 5056909225610630529L;

    public IntervalCategoryLabel(String labelFormat, NumberFormat formatter, Object[] values) {
        super(labelFormat, formatter);
        this.values = values;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result = new Object[2];
        Number val = dataset.getValue((Comparable)((Object)"region"), (Comparable)((Object)String.valueOf((column + 1) * 10).concat("%")));
        if (val.intValue() == 0) {
            result[0] = "";
            result[1] = "";
        } else {
            result[0] = this.normalize(this.values[column * 2]);
            result[1] = this.normalize(this.values[column * 2 + 1]);
        }
        return result;
    }

    private Object normalize(Object object) {
        Double value = (Double)object;
        String ret = "";
        if (value == 0.0) {
            ret = "0";
        } else {
            DecimalFormat formatter = new DecimalFormat("0.#E0");
            ret = formatter.format(value);
            L.debug("{} was normalized to: {}", object, (Object)ret);
        }
        return ret;
    }
}

