/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.halstead;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.computation.HalsteadValue;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ezreport.reports.halstead.HalsteadDataSource;
import com.ez.report.application.ezreport.reports.halstead.HalsteadReport;
import com.ez.report.application.ezreport.reports.halstead.IntervalCategoryLabel;
import com.ez.report.application.ezreport.reports.halstead.Obj4HalsteadComparator;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.all.Obj4HalsteadReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalsteadReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HalsteadReportBuilder.class);
    List resultList = null;
    private double maxV = 0.0;
    private double maxD = 0.0;
    private double maxL = 0.0;
    private double maxE = 0.0;
    private double maxT = 0.0;
    private double maxB = 0.0;
    private double maxN = 0.0;
    private double maxn = 0.0;
    String viewTabLabel = "";
    private int diagramItemsNumber = 0;
    private Font labelFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)10, (boolean)false);
    private Font titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)14, (boolean)false);
    private Font intervalFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)8, (boolean)false);
    private JFreeChart verticalChart;
    private JFreeChart barChart;
    private CSVWriter csvWriter;

    public HalsteadReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new LinkedList();
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        boolean showSummaryOnly;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(HalsteadReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        this.csvWriter = this.initTempCSVFile();
        if (this.csvWriter != null) {
            this.writeCSVHeader(this.csvWriter);
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        this.data((IProgressMonitor)monitor.newChild(100));
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        if (showSummaryOnly = ((Boolean)this.getReportModel().getProperty("show summary only")).booleanValue()) {
            return null;
        }
        HalsteadDataSource dataSource = new HalsteadDataSource(this.maxN, this.maxn, this.maxV, this.maxD, this.maxL, this.maxE, this.maxT, this.maxB, this.resultList);
        return dataSource;
    }

    protected void writeCSVHeader(CSVWriter csvWriter) {
        super.writeCSVHeader(csvWriter, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
        csvWriter.write(new String[]{Messages.getString(HalsteadReportBuilder.class, "resource.name"), Messages.getString(HalsteadReportBuilder.class, "program.length"), Messages.getString(HalsteadReportBuilder.class, "vocabulary.size"), Messages.getString(HalsteadReportBuilder.class, "program.volume"), Messages.getString(HalsteadReportBuilder.class, "difficulty.level"), Messages.getString(HalsteadReportBuilder.class, "program.level"), Messages.getString(HalsteadReportBuilder.class, "effort.implement"), Messages.getString(HalsteadReportBuilder.class, "time.implement"), Messages.getString(HalsteadReportBuilder.class, "number.of.bugs")});
    }

    @Override
    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(HalsteadReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    private void data(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(HalsteadReportBuilder.class, "computeData.taskName"));
        monitor.setTaskName(Messages.getString(HalsteadReportBuilder.class, "getParams.taskName"));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        int no = prgList.size();
        this.parameters.put("inputResourcesCount", new Integer(no).toString());
        this.buildInputs4Appendix(prgList);
        this.parameters.put("appendixFirstLineValue", String.valueOf(no));
        this.parameters.put("title.appFieldValues", this.applicationsName);
        monitor.worked(10);
        this.checkStop();
        HashMap<Integer, ProgramInputNoGUI> inputMap = new HashMap<Integer, ProgramInputNoGUI>();
        monitor.setTaskName(Messages.getString(HalsteadReportBuilder.class, "getData.taskName"));
        HalsteadValue hVal = new HalsteadValue(!this.runInBatch, this.project);
        hVal.setReportProperties(this.report.properties);
        String[][] halResults = null;
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ComputeWithLock runn = new ComputeWithLock(hVal, prgList, inputMap, this.pInfo, this.parameters);
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)monitor);
            halResults = runn.results;
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        monitor.worked(30);
        Queue mess = hVal.getMessages();
        if (mess != null && !mess.isEmpty()) {
            this.messages.addAll(mess);
        }
        prgList = null;
        if (halResults == null) {
            L.warn("no results for HALSTEAD report");
        } else {
            L.debug("HALSTEAD results:");
            SubMonitor resMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(40), (int)halResults.length);
            int i = 0;
            while (i < halResults.length) {
                this.checkStop();
                L.debug("program id: {}", (Object)halResults[i][0]);
                L.debug("N1: {}", (Object)halResults[i][1]);
                L.debug("n1: {}", (Object)halResults[i][2]);
                L.debug("N2: {}", (Object)halResults[i][3]);
                L.debug("n2: {}", (Object)halResults[i][4]);
                L.debug("\n");
                String prgID = halResults[i][0];
                ProgramInputNoGUI pi = (ProgramInputNoGUI)inputMap.get(Integer.valueOf(prgID));
                String prgName = pi.getListableName();
                Obj4HalsteadReport obj = new Obj4HalsteadReport(Messages.getString(HalsteadReportBuilder.class, "resource.name"), prgName, Integer.valueOf(halResults[i][1]), Integer.valueOf(halResults[i][3]), Integer.valueOf(halResults[i][2]), Integer.valueOf(halResults[i][4]));
                ++this.diagramItemsNumber;
                if (this.maxN < (Double)obj.get("N")) {
                    this.maxN = (Double)obj.get("N");
                }
                if (this.maxn < (Double)obj.get("n")) {
                    this.maxn = (Double)obj.get("n");
                }
                if (this.maxB < (Double)obj.get("B")) {
                    this.maxB = (Double)obj.get("B");
                }
                if (this.maxT < (Double)obj.get("T")) {
                    this.maxT = (Double)obj.get("T");
                }
                if (this.maxE < (Double)obj.get("E")) {
                    this.maxE = (Double)obj.get("E");
                }
                if (this.maxL < (Double)obj.get("L")) {
                    this.maxL = (Double)obj.get("L");
                }
                if (this.maxD < (Double)obj.get("D")) {
                    this.maxD = (Double)obj.get("D");
                }
                if (this.maxV < (Double)obj.get("V")) {
                    this.maxV = (Double)obj.get("V");
                }
                if (this.csvWriter != null) {
                    this.csvWriter.write(new String[]{prgName, String.valueOf((Double)obj.get("N")), String.valueOf((Double)obj.get("n")), String.valueOf((Double)obj.get("V")), String.valueOf((Double)obj.get("D")), String.valueOf((Double)obj.get("L")), String.valueOf((Double)obj.get("E")), String.valueOf((Double)obj.get("T")), String.valueOf((Double)obj.get("B"))});
                }
                this.resultList.add(obj);
                resMonitor.worked(1);
                ++i;
            }
            resMonitor.setWorkRemaining(0);
        }
        inputMap.clear();
        inputMap = null;
        monitor.setTaskName(Messages.getString(HalsteadReportBuilder.class, "processData.taskName"));
        Collections.sort(this.resultList, new Obj4HalsteadComparator());
        this.checkStop();
        if (this.resultList.size() > 1) {
            this.createStackedBarChartImages();
        }
        monitor.worked(10);
        monitor.setWorkRemaining(0);
    }

    private void clearForJasperReport() {
        this.resultList.clear();
        this.diagramItemsNumber = 0;
        this.viewTabLabel = "";
        this.maxV = 0.0;
        this.maxD = 0.0;
        this.maxL = 0.0;
        this.maxE = 0.0;
        this.maxT = 0.0;
        this.maxB = 0.0;
        this.maxN = 0.0;
        this.maxn = 0.0;
        this.parameters.put("halsteadChartVertical", null);
        this.parameters.put("halsteadChartVertical1", null);
        this.parameters.put("halsteadChartVertical2", null);
        this.parameters.put("halsteadChartVertical3", null);
        this.parameters.put("halsteadChartVertical4", null);
        this.parameters.put("halsteadChartVertical5", null);
        this.parameters.put("halsteadChartVertical6", null);
        this.parameters.put("halsteadChartVertical7", null);
    }

    private void createStackedBarChartImages() {
        if (this.diagramItemsNumber > 15) {
            String title = Messages.getString(HalsteadReportBuilder.class, "program.length.title");
            String domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis1");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxN, "N"), "halsteadChartVertical", this.maxN);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "vocabulary.size.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis2");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxn, "n"), "halsteadChartVertical1", this.maxn);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "program.volume.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis3");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxV, "V"), "halsteadChartVertical2", this.maxV);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "difficulty.level.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis4");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxD, "D"), "halsteadChartVertical3", this.maxD);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "program.level.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis5");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxL, "L"), "halsteadChartVertical4", this.maxL);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "effort.implement.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis6");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxE, "E"), "halsteadChartVertical5", this.maxE);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "time.implement.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis7");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxT, "T"), "halsteadChartVertical6", this.maxT);
            this.checkStop();
            title = Messages.getString(HalsteadReportBuilder.class, "number.bugs.title");
            domainAxisLabel = Messages.getString(HalsteadReportBuilder.class, "procent.of.domainAxis8");
            this.createVerticalChart(title, domainAxisLabel, this.getCountBarDataset(this.maxB, "B"), "halsteadChartVertical7", this.maxB);
        } else {
            DefaultCategoryDataset datasetN = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetn = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetV = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetD = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetL = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetE = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetT = new DefaultCategoryDataset();
            DefaultCategoryDataset datasetB = new DefaultCategoryDataset();
            Iterator itt = this.resultList.iterator();
            while (itt.hasNext()) {
                this.checkStop();
                Obj4HalsteadReport halsteadObj = (Obj4HalsteadReport)itt.next();
                String name = (String)halsteadObj.get("name");
                datasetN.addValue(((Double)halsteadObj.get("N")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetn.addValue(((Double)halsteadObj.get("n")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetV.addValue(((Double)halsteadObj.get("V")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetD.addValue(((Double)halsteadObj.get("D")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetL.addValue(((Double)halsteadObj.get("L")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetE.addValue(((Double)halsteadObj.get("E")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetT.addValue(((Double)halsteadObj.get("T")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
                datasetB.addValue(((Double)halsteadObj.get("B")).doubleValue(), (Comparable)((Object)"region"), (Comparable)((Object)name));
            }
            TextTitle title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "program.length.title"), this.titleFont);
            this.createVerticalChart(title, datasetN, "halsteadChartVertical");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "vocabulary.size.title"), this.titleFont);
            this.createVerticalChart(title, datasetn, "halsteadChartVertical1");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "program.volume.title"), this.titleFont);
            this.createVerticalChart(title, datasetV, "halsteadChartVertical2");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "difficulty.level.title"), this.titleFont);
            this.createVerticalChart(title, datasetD, "halsteadChartVertical3");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "program.level.title"), this.titleFont);
            this.createVerticalChart(title, datasetL, "halsteadChartVertical4");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "effort.implement.title"), this.titleFont);
            this.createVerticalChart(title, datasetE, "halsteadChartVertical5");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "time.implement.title"), this.titleFont);
            this.createVerticalChart(title, datasetT, "halsteadChartVertical6");
            this.checkStop();
            title = new TextTitle(Messages.getString(HalsteadReportBuilder.class, "number.bugs.title"), this.titleFont);
            this.createVerticalChart(title, datasetB, "halsteadChartVertical7");
        }
        InputStream is = com.ez.report.generation.common.utils.Utils.getResourceStreamFromPlugin((String)"reports/halstead_chartVertical.jasper", (String)"com.ez.jasperreports");
        this.parameters.put("SubreportStream1", is);
        is = com.ez.report.generation.common.utils.Utils.getResourceStreamFromPlugin((String)"reports/halstead_chartVertical1.jasper", (String)"com.ez.jasperreports");
        this.parameters.put("SubreportStream2", is);
        is = com.ez.report.generation.common.utils.Utils.getResourceStreamFromPlugin((String)"reports/halstead_chartVertical2.jasper", (String)"com.ez.jasperreports");
        this.parameters.put("SubreportStream3", is);
        is = com.ez.report.generation.common.utils.Utils.getResourceStreamFromPlugin((String)"reports/halstead_chartVertical3.jasper", (String)"com.ez.jasperreports");
        this.parameters.put("SubreportStream4", is);
    }

    private DefaultCategoryDataset getCountBarDataset(double max, String field) {
        int count0 = 0;
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        int count5 = 0;
        int count6 = 0;
        int count7 = 0;
        int count8 = 0;
        int count9 = 0;
        for (Obj4HalsteadReport halsteadObj : this.resultList) {
            double obj = (Double)halsteadObj.get(field);
            if (obj < max / 10.0) {
                ++count0;
                continue;
            }
            if (obj < 2.0 * max / 10.0) {
                ++count1;
                continue;
            }
            if (obj < 3.0 * max / 10.0) {
                ++count2;
                continue;
            }
            if (obj < 4.0 * max / 10.0) {
                ++count3;
                continue;
            }
            if (obj < 5.0 * max / 10.0) {
                ++count4;
                continue;
            }
            if (obj < 6.0 * max / 10.0) {
                ++count5;
                continue;
            }
            if (obj < 7.0 * max / 10.0) {
                ++count6;
                continue;
            }
            if (obj < 8.0 * max / 10.0) {
                ++count7;
                continue;
            }
            if (obj < 9.0 * max / 10.0) {
                ++count8;
                continue;
            }
            ++count9;
        }
        L.debug("{} {} {} {} {} {} {} {} {} {}", new Object[]{count0, count1, count2, count3, count4, count5, count6, count7, count8, count9});
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue((double)count0, (Comparable)((Object)"region"), (Comparable)((Object)"10%"));
        dataset.addValue((double)count1, (Comparable)((Object)"region"), (Comparable)((Object)"20%"));
        dataset.addValue((double)count2, (Comparable)((Object)"region"), (Comparable)((Object)"30%"));
        dataset.addValue((double)count3, (Comparable)((Object)"region"), (Comparable)((Object)"40%"));
        dataset.addValue((double)count4, (Comparable)((Object)"region"), (Comparable)((Object)"50%"));
        dataset.addValue((double)count5, (Comparable)((Object)"region"), (Comparable)((Object)"60%"));
        dataset.addValue((double)count6, (Comparable)((Object)"region"), (Comparable)((Object)"70%"));
        dataset.addValue((double)count7, (Comparable)((Object)"region"), (Comparable)((Object)"80%"));
        dataset.addValue((double)count8, (Comparable)((Object)"region"), (Comparable)((Object)"90%"));
        dataset.addValue((double)count9, (Comparable)((Object)"region"), (Comparable)((Object)"100%"));
        return dataset;
    }

    private void createVerticalChart(String title, String domainAxisLabel, DefaultCategoryDataset dataset, String paramName, double max) {
        String rangeAxisLabel = Messages.getString(HalsteadReportBuilder.class, "occurrences.label");
        this.verticalChart = ChartFactory.createStackedBarChart(null, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.verticalChart.setTitle(new TextTitle(title, this.titleFont));
        this.verticalChart.setBackgroundPaint((Paint)Color.white);
        this.verticalChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.verticalChart.setBorderVisible(false);
        CategoryPlot plot = this.verticalChart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.black);
        axis.setLabelFont(this.labelFont);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.1);
        rangeAxis.setAxisLinePaint((Paint)Color.black);
        rangeAxis.setLabelFont(this.labelFont);
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        renderer.setMaximumBarWidth(0.1);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setBaseOutlinePaint((Paint)Color.LIGHT_GRAY);
        Color color = new Color(255, 142, 149);
        renderer.setSeriesPaint(0, (Paint)color);
        double min9 = 9.0 * max / 10.0;
        double max9 = max;
        double min8 = 8.0 * max / 10.0;
        double max8 = 9.0 * max / 10.0;
        double min7 = 7.0 * max / 10.0;
        double max7 = 8.0 * max / 10.0;
        double min6 = 6.0 * max / 10.0;
        double max6 = 7.0 * max / 10.0;
        double min5 = 5.0 * max / 10.0;
        double max5 = 6.0 * max / 10.0;
        double min4 = 4.0 * max / 10.0;
        double max4 = 5.0 * max / 10.0;
        double min3 = 3.0 * max / 10.0;
        double max3 = 4.0 * max / 10.0;
        double min2 = 2.0 * max / 10.0;
        double max2 = 3.0 * max / 10.0;
        double min1 = max / 10.0;
        double max1 = 2.0 * max / 10.0;
        double min0 = 0.0;
        double max0 = max / 10.0;
        Object[] values = new Object[]{min0, max0, min1, max1, min2, max2, min3, max3, min4, max4, min5, max5, min6, max6, min7, max7, min8, max8, min9, max9};
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new IntervalCategoryLabel("{0} - {1}", NumberFormat.getInstance(), values));
        renderer.setBaseItemLabelsVisible(true);
        double angle = Math.toRadians(-60.0);
        ItemLabelPosition lblPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER, TextAnchor.TOP_CENTER, angle);
        renderer.setBasePositiveItemLabelPosition(lblPosition);
        renderer.setBaseItemLabelFont(this.intervalFont);
        BufferedImage img = this.verticalChart.createBufferedImage(1100, 760, 550.0, 380.0, null);
        this.parameters.put(paramName, img);
    }

    private void createVerticalChart(TextTitle title, DefaultCategoryDataset dataset, String paramName) {
        this.barChart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.barChart.setBackgroundPaint((Paint)Color.white);
        this.barChart.setBorderVisible(false);
        CategoryPlot plot = this.barChart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.black);
        axis.setLabelFont(this.labelFont);
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setAxisLinePaint((Paint)Color.black);
        rangeAxis.setLabelFont(this.labelFont);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setMaximumBarWidth(0.1);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setBaseOutlinePaint((Paint)Color.LIGHT_GRAY);
        Color color = new Color(255, 142, 149);
        renderer.setSeriesPaint(0, (Paint)color);
        this.barChart.setTitle(title);
        BufferedImage img = this.barChart.createBufferedImage(1100, 760, 550.0, 380.0, null);
        this.parameters.put(paramName, img);
    }

    private void putExternalizedParameters(Map params) {
        String externalized = null;
        boolean showInputs = (Boolean)this.getReportModel().getProperty("showInputDetails");
        boolean showOperators = (Boolean)this.getReportModel().getProperty("showOperators");
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            externalized = Messages.getString(HalsteadReportBuilder.class, "onlySummaryReport.title");
            params.put("report.title", externalized);
            params.put("summary", null);
            Boolean val = (Boolean)this.getReportModel().getProperty("show appendix");
            params.put("showAppendix", val);
            params.put("showInputs", Boolean.TRUE.equals(val) ? showInputs : Boolean.FALSE);
            params.put("showOperators", Boolean.TRUE.equals(val) ? showOperators : Boolean.FALSE);
            params.put("showTOC", Boolean.FALSE);
        } else {
            externalized = Messages.getString(HalsteadReportBuilder.class, "report.title");
            params.put("report.title", externalized);
            externalized = Messages.getString(HalsteadReportBuilder.class, "reportSummary.lbl");
            params.put("summary", externalized);
            params.put("showAppendix", Boolean.TRUE);
            params.put("showInputs", showInputs);
            params.put("showOperators", showOperators);
            params.put("showTOC", Boolean.TRUE);
        }
        externalized = Messages.getString(HalsteadReportBuilder.class, "scope.resources.text");
        params.put("4resources", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "program.length");
        params.put("indicator1.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "program.length.short");
        params.put("indicator1.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "vocabulary.size");
        params.put("indicator2.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "vocabulary.size.short");
        params.put("indicator2.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "program.volume");
        params.put("indicator3.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "program.volume.short");
        params.put("indicator3.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "difficulty.level");
        params.put("indicator4.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "difficulty.level.short");
        params.put("indicator4.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "program.level");
        params.put("indicator5.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "program.level.short");
        params.put("indicator5.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "effort.implement");
        params.put("indicator6.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "effort.implement.short");
        params.put("indicator6.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "time.implement");
        params.put("indicator7.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "time.implement.short");
        params.put("indicator7.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "number.of.bugs");
        params.put("indicator8.description", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "number.of.bugs.short");
        params.put("indicator8.short", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "operators.summary.lbl");
        params.put("operatorsSummary", externalized);
        externalized = Messages.getString(HalsteadReportBuilder.class, "summary1.lbl");
        params.put("summ1.lbl", externalized);
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new HalsteadReport(this.project);
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput(prgList);
            Boolean value = (Boolean)this.inputs.get("show summary only");
            if (value == null) {
                value = false;
            }
            this.report.addProperty("show summary only", (boolean)value);
            this.addAppendixProperties(this.report);
            value = (Boolean)this.inputs.get("showOperators");
            if (value == null) {
                value = false;
            }
            this.report.addProperty("showOperators", (boolean)value);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", selectedApps != null);
            Properties prop = (Properties)this.inputs.get("settings");
            if (prop != null) {
                for (String string : prop.keySet()) {
                    try {
                        Integer.parseInt(string);
                        Boolean val1 = Boolean.parseBoolean(prop.getProperty(string));
                        this.report.addProperty(string, val1.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
    }

    @Override
    protected int getMaxCachedPages() {
        return 2;
    }

    @Override
    public void cleanMemory() {
        this.barChart = null;
        this.verticalChart = null;
        this.intervalFont = null;
        this.labelFont = null;
        this.titleFont = null;
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        super.cleanMemory();
    }

    @Override
    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms("SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 13, 14, 15, 16) ", conn);
    }

    @Override
    public void addParameters(Map params) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.putAll(params);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/halstead_withTOC.jasper";
    }

    class ComputeWithLock
    implements IMFRunnable {
        private HalsteadValue h;
        String[][] results;
        private Set prgList;
        private Map<Integer, ProgramInputNoGUI> inputMap;

        public ComputeWithLock(HalsteadValue hVal, Set prgList, Map<Integer, ProgramInputNoGUI> inputMap, ProjectInfo pInfo, Map parameters) {
            this.prgList = prgList;
            this.inputMap = inputMap;
            this.h = hVal;
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            this.results = this.h.computeHalsteadResults(SubMonitor.convert((IProgressMonitor)monitor), this.prgList, HalsteadReportBuilder.this.parameters, this.inputMap, HalsteadReportBuilder.this.pInfo, conn);
        }
    }
}

