/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.halstead;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import java.io.File;
import java.util.Properties;

public class HalsteadReport
extends AbstractReport {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1L;
    public static final String SHOW_OPERATORS_IN_APPENDIX = "showOperators";

    public HalsteadReport(String projectName) {
        this.identifier = 4;
        this.projectName = projectName;
    }

    @Override
    public String getTitle() {
        Boolean showOnlySumm = (Boolean)this.getProperty("show summary only");
        if (showOnlySumm != null && showOnlySumm.booleanValue()) {
            return "HalsteadReportSummary";
        }
        return "HalsteadReport";
    }

    @Override
    public void loadPropertiesFromFile(File f) {
        if (f == null) {
            String prjPath = Utils.getProjectPathName((String)this.projectName);
            String analysisName = this.getType();
            String string = prjPath.concat(File.separator).concat(analysisName).concat(File.separator).concat("default.properties");
            f = new File(string);
        }
        this.addProperty("settings file", f.getName().substring(0, f.getName().lastIndexOf(46)));
        Properties prop = Utils.readSettings((File)f);
        for (String string : prop.keySet()) {
            try {
                Integer.parseInt(string);
                this.addProperty(string, prop.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void loadPropertiesFromFile(String settingsFile) {
        File f = null;
        String analysisName = this.getType();
        if (settingsFile != null && !"".equals(settingsFile)) {
            String prjPath = Utils.getProjectPathName((String)this.projectName);
            String path = prjPath.concat(File.separator).concat(analysisName).concat(File.separator).concat(settingsFile);
            if (!path.endsWith(".properties")) {
                path = path.concat(".properties");
            }
            f = new File(path);
        } else {
            String prjPath = Utils.getProjectPathName((String)this.projectName);
            String path = prjPath.concat(File.separator).concat(analysisName).concat(File.separator).concat("default.properties");
            f = new File(path);
        }
        this.loadPropertiesFromFile(f);
    }

    @Override
    public String getType() {
        return AnalysisType.EZSOURCE_EZREPORT_HALSTEAD_ANALYSIS.toString();
    }
}

