/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.halstead;

import com.ez.report.application.reports.all.Obj4HalsteadReport;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalsteadDataSource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HalsteadDataSource.class);
    private double maxN;
    private double maxn;
    private double maxV;
    private double maxD;
    private double maxL;
    private double maxE;
    private double maxT;
    private double maxB;
    private Object currentValue;
    private JFreeChart spiderChart;
    private List list = null;

    public HalsteadDataSource(double maxN, double maxn, double maxV, double maxD, double maxL, double maxE, double maxT, double maxB, List list) {
        this.maxN = maxN;
        this.maxn = maxn;
        this.maxV = maxV;
        this.maxD = maxD;
        this.maxL = maxL;
        this.maxE = maxE;
        this.maxT = maxT;
        this.maxB = maxB;
        this.list = list;
    }

    public HalsteadDataSource(List list) {
        this.list = list;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        Obj4HalsteadReport values = (Obj4HalsteadReport)this.currentValue;
        value = values.get(field.getName());
        L.debug("{}={}", (Object)field.getName(), value);
        return value;
    }

    public boolean nextItem() throws JRException {
        if (this.list == null) {
            return false;
        }
        Object object = this.currentValue = this.list.size() > 0 ? (Object)this.list.remove(0) : null;
        if (this.currentValue != null) {
            Obj4HalsteadReport obj = (Obj4HalsteadReport)this.currentValue;
            this.createSpiderDiagram(obj);
            return true;
        }
        return false;
    }

    private void createSpiderDiagram(Obj4HalsteadReport obj) {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        this.setValue(ds, obj, "N", this.maxN);
        this.setValue(ds, obj, "n", this.maxn);
        this.setValue(ds, obj, "V", this.maxV);
        this.setValue(ds, obj, "D", this.maxD);
        this.setValue(ds, obj, "L", this.maxL);
        this.setValue(ds, obj, "E", this.maxE);
        this.setValue(ds, obj, "T", this.maxT);
        this.setValue(ds, obj, "B", this.maxB);
        SpiderWebPlot spiderWebPlot = new SpiderWebPlot((CategoryDataset)ds);
        spiderWebPlot.setOutlinePaint((Paint)Color.white);
        spiderWebPlot.setMaxValue(1.0);
        this.spiderChart = new JFreeChart(null, null, (Plot)spiderWebPlot, false);
        this.spiderChart.setBackgroundPaint((Paint)Color.white);
        this.spiderChart.setBorderVisible(false);
        obj.setSpiderImg(this.spiderChart.createBufferedImage(520, 346, 260.0, 173.0, null));
    }

    private void setValue(DefaultCategoryDataset ds, Obj4HalsteadReport obj, String key, double max) {
        double value = max != 0.0 ? (Double)obj.get(key) / max : 0.0;
        if (value == 0.0) {
            value = 1.0E-4;
        }
        ds.addValue(value, (Comparable)((Object)"serie 1"), (Comparable)((Object)key));
    }
}

