/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.deadCode.unusedProcInPrgs;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.CloseTestRunnable;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.report.application.ezreport.reports.EZPiePlot;
import com.ez.report.application.ezreport.reports.ProgramComparator;
import com.ez.report.application.ezreport.reports.deadCode.unusedProcInPrgs.Obj4UnusedProcComparator;
import com.ez.report.application.ezreport.reports.deadCode.unusedProcInPrgs.Obj4UnusedProcReport;
import com.ez.report.application.ezreport.reports.deadCode.unusedProcInPrgs.UnusedProcInPrgsReport;
import com.ez.report.application.ezreport.reports.deadCode.unusedProcInPrgs.UnusedProceduresDataSource;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedProcInPrgsReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UnusedProcInPrgsReportBuilder.class);
    private static final String EZREP_UNUSED_PROC = "EZReports_UnusedProceduresReport";
    private static final String EZREP_UNUSED_PROC_COBOL = "EZReports_UnusedProceduresReport_Cobol";
    private static final String FILTER_UNUSED_EXIT_PROCEDURES = "0";
    private static final String NOT_FILTER_UNUSED_EXIT_PROCEDURES = "1";
    private static final String EZREP_UNUSED_PROC_VME_COBOL = "EZReports_UnusedProceduresReport_VME_Cobol";
    private List resultList = new ArrayList();
    private Font labelFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)10, (boolean)false);
    private Font titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)14, (boolean)false);
    private JFreeChart pieChart;
    Color RED_COLOR = new Color(217, 79, 79);
    Color BLUE_COLOR = new Color(105, 177, 148);
    private Map<String, Integer> progrWithUnusedProc = new HashMap<String, Integer>();
    JFreeChart verticalChart;
    private static final int MAX_BAR_COUNT = 20;
    private int countsSame = 0;
    boolean isVME = false;
    private int dataPhase = 0;
    private CSVWriter csvWriter;

    public UnusedProcInPrgsReportBuilder(String reportName, String settings) {
        this.report = null;
    }

    @Override
    protected void preBuild(IProgressMonitor pmonitor) {
        super.preBuild(pmonitor);
        this.findVME(pmonitor);
    }

    private void findVME(IProgressMonitor pmonitor) {
        if (this.pInfo != null && this.pInfo.getEnvironment() != null && !this.pInfo.getEnvironment().equals("") && this.pInfo.getEnvironment().equalsIgnoreCase("VME")) {
            this.isVME = true;
        }
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UnusedProcInPrgsReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        this.csvWriter = this.initTempCSVFile();
        if (this.csvWriter != null) {
            this.writeCSVHeader(this.csvWriter, Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.title"));
            this.csvWriter.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "program.name"), Messages.getString(((Object)((Object)this)).getClass(), "procedure.column.name"), Messages.getString(((Object)((Object)this)).getClass(), "stmtNo.column.name"), Messages.getString(((Object)((Object)this)).getClass(), "line.column.name"), Messages.getString(((Object)((Object)this)).getClass(), "copybook.name")});
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        this.data((IProgressMonitor)monitor.newChild(100));
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        UnusedProceduresDataSource dataSource = new UnusedProceduresDataSource(this.resultList);
        return dataSource;
    }

    @Override
    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new UnusedProcInPrgsReport(this.project, this.getSelectionFlagFromInputs());
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput(prgList);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", selectedApps != null);
            Boolean value = Boolean.TRUE;
            if (this.runInBatch) {
                Object val;
                Properties prop = (Properties)this.inputs.get("settings");
                if (prop != null && (val = prop.get("filterExitProcedures")) != null) {
                    value = Boolean.valueOf(val.toString());
                }
            } else {
                value = (Boolean)this.inputs.get("filterExitProcedures");
            }
            this.report.addProperty("filterExitProcedures", value != null ? value : true);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        params.put("summary", params.get("report.summary"));
        params.put("detail", params.get("report.details"));
        Boolean val = (Boolean)this.getReportModel().getProperty("show appendix");
        params.put("showAppendix", val);
        boolean showInputs = (Boolean)this.getReportModel().getProperty("showInputDetails");
        params.put("showInputs", showInputs);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    @Override
    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UnusedProcInPrgsReportBuilder.class, "computeParameters.process.name"));
        this.addLocaleParameter(this.parameters);
        this.parameters.put("noInclude", "noIncludeValue");
        this.putExternalizedParameters(this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    private void putExternalizedParameters(Map<String, Object> params) {
        String externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "procedure.column.name");
        params.put("proc_lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "line.column.name");
        params.put("line_lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "stmtNo.column.name");
        params.put("stmts_no_lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "program.name");
        params.put("prg_lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "copybook.name");
        params.put("copybook_lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "direct.in.program");
        params.put("inProgramLbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "total.procedure.lbl");
        params.put("total_lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.sum1.lbl");
        params.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.sum2.lbl");
        params.put("report.sum2.lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.sum3.lbl");
        params.put("report.sum3.lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.sum4.lbl");
        params.put("report.sum4.lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.sum5.lbl");
        params.put("report.sum5.lbl", externalized);
        externalized = Messages.getString(UnusedProcInPrgsReportBuilder.class, "report.sum6.lbl");
        params.put("report.sum6.lbl", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/unusedProcedures.jasper";
    }

    @Override
    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        String countQuery = "select count(ProgramName) from programs where Programs.OccurID<>0 and Programs.ProgramTypeID not in (8, 9, 11, 13, 14, 15,16, 19)";
        return Utils.countAvailablePrograms(countQuery, conn);
    }

    private void clearForJasperReport() {
        this.progrWithUnusedProc.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrTop20Bar", null);
    }

    @Override
    protected String getProcedure() {
        if (this.dataPhase == 0) {
            if (this.isVME) {
                return EZREP_UNUSED_PROC_VME_COBOL;
            }
            return EZREP_UNUSED_PROC_COBOL;
        }
        return EZREP_UNUSED_PROC;
    }

    @Override
    protected String getSelectiveProcedure() {
        if (this.dataPhase == 0) {
            if (this.isVME) {
                return "EZReports_UnusedProceduresReport_VME_Cobol_Selective";
            }
            return "EZReports_UnusedProceduresReport_Cobol_Selective";
        }
        return "EZReports_UnusedProceduresReport_Selective";
    }

    private String[][] data(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UnusedProcInPrgsReportBuilder.class, "compute.taskName"));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("appendixFirstLineValue", String.valueOf(prgList.size()));
        this.parameters.put("title.appFieldValues", this.applicationsName);
        HashMap<Integer, String> inputPrgMap = new HashMap<Integer, String>();
        for (ProgramInputNoGUI prg : prgList) {
            inputPrgMap.put(prg.getResourceID(), prg.getListableName());
        }
        this.dataPhase = 0;
        boolean filterExitProcs = (Boolean)this.report.getProperty("filterExitProcedures");
        L.debug("{}={}", (Object)"filterExitProcedures", (Object)filterExitProcs);
        this.parameters.put("filterExits", filterExitProcs ? Messages.getString(UnusedProcInPrgsReportBuilder.class, "filter.exits.msg") : null);
        Object[] paramProc = new String[]{filterExitProcs ? FILTER_UNUSED_EXIT_PROCEDURES : NOT_FILTER_UNUSED_EXIT_PROCEDURES};
        SingleQueryResult cobolQueryResult = this.queryForData((Runnable)new CloseTestRunnable(pmonitor), paramProc, EZSourceDataType.Integer, this.report.useAllResources() ? null : this.filterSelectedIDs());
        this.dataPhase = 1;
        SingleQueryResult othersQueryResult = this.queryForData(pmonitor, EZSourceDataType.Integer, this.report.useAllResources() ? null : this.filterSelectedIDs());
        SingleQueryResult queryResult = null;
        if (cobolQueryResult.data == null && othersQueryResult.data == null) {
            L.warn("no results for UnusedProcedures report");
            Integer noPrgs = new Integer(cobolQueryResult.resourcesCount);
            this.parameters.put("report.sum1", noPrgs);
            this.parameters.put("report.sum2", new Integer(0));
            this.parameters.put("detail", null);
            this.parameters.put("report.sum5", new BigDecimal(0));
        } else {
            if (cobolQueryResult.data == null) {
                queryResult = othersQueryResult;
            } else if (othersQueryResult.data == null) {
                queryResult = cobolQueryResult;
            } else {
                boolean startOnCobol = cobolQueryResult.data.length >= othersQueryResult.data.length;
                queryResult = startOnCobol ? cobolQueryResult : othersQueryResult;
                int[] nArray = new int[3];
                nArray[1] = 3;
                nArray[2] = 1;
                queryResult.addOrderedResult(!startOnCobol ? cobolQueryResult : othersQueryResult, nArray);
                cobolQueryResult = null;
                othersQueryResult = null;
            }
            L.debug("UnusedProcedures results:");
            this.parameters.put("report.sum1", new Integer(queryResult.resourcesCount));
            String currentProgram = null;
            int count = 0;
            int totalProcedures = 0;
            ArrayList<Obj4UnusedProcReport> tempList = new ArrayList<Obj4UnusedProcReport>();
            int i = 0;
            while (i < queryResult.data.length) {
                String prgName = queryResult.data[i][0];
                String procName = queryResult.data[i][1];
                String path = queryResult.data[i][2];
                String includeName = queryResult.data[i][3];
                Integer lineNo = new Integer(Integer.parseInt(queryResult.data[i][4]));
                Integer prgID = new Integer(Integer.parseInt(queryResult.data[i][6]));
                prgName = inputPrgMap.get(prgID) != null ? (String)inputPrgMap.get(prgID) : prgName;
                Integer stmtsNo = new Integer(0);
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)queryResult.data[i][5]) != null) {
                    stmtsNo = new Integer(Integer.parseInt(queryResult.data[i][5]));
                }
                L.debug("program: {}", (Object)prgName);
                L.debug("proc name: {}", (Object)procName);
                L.debug("path: {}", (Object)path);
                L.debug("include: {}", (Object)includeName);
                L.debug("line: {}", (Object)lineNo);
                L.debug("stmtsNo: {}", (Object)stmtsNo);
                L.debug("\n");
                if (this.csvWriter != null) {
                    this.csvWriter.write(new String[]{prgName, procName, String.valueOf(stmtsNo), String.valueOf(lineNo), includeName != null ? includeName : ""});
                }
                Obj4UnusedProcReport obj = new Obj4UnusedProcReport(prgName, procName, path, includeName, lineNo, stmtsNo);
                if (currentProgram == null) {
                    currentProgram = prgName;
                    ++count;
                    tempList.add(obj);
                } else if (!currentProgram.equalsIgnoreCase(prgName)) {
                    Collections.sort(tempList, new Obj4UnusedProcComparator());
                    this.resultList.addAll(tempList);
                    tempList.clear();
                    tempList.add(obj);
                    this.progrWithUnusedProc.put(currentProgram, new Integer(count));
                    totalProcedures += count;
                    currentProgram = prgName;
                    count = 1;
                } else {
                    ++count;
                    tempList.add(obj);
                }
                if (i == queryResult.data.length - 1) {
                    this.progrWithUnusedProc.put(currentProgram, new Integer(count));
                    totalProcedures += count;
                    Collections.sort(tempList, new Obj4UnusedProcComparator());
                    this.resultList.addAll(tempList);
                }
                ++i;
            }
            this.parameters.put("report.sum2", new Integer(this.progrWithUnusedProc.size()));
            BigDecimal average = new BigDecimal(totalProcedures).divide(new BigDecimal(this.progrWithUnusedProc.size()), 2, 5);
            this.parameters.put("report.sum5", average);
        }
        if (queryResult != null && queryResult.resourcesCount != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(UnusedProcInPrgsReportBuilder.class, "used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(UnusedProcInPrgsReportBuilder.class, "unused.category.lbl");
            String withUnusedKey = Messages.getString(UnusedProcInPrgsReportBuilder.class, "unused.category.tooltip");
            String withoutUnusedKey = Messages.getString(UnusedProcInPrgsReportBuilder.class, "used.category.tooltip");
            dataset.setValue((Comparable)((Object)withUnusedKey), (Number)new Double(this.progrWithUnusedProc.size()));
            dataset.setValue((Comparable)((Object)withoutUnusedKey), (Number)new Double(queryResult.resourcesCount - this.progrWithUnusedProc.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(withUnusedKey, unusedCategory);
            formatsMap.put(withoutUnusedKey, usedCategory);
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap));
            if (this.progrWithUnusedProc.size() > 0) {
                this.parameters.put("progrTop20Bar", this.createStackedBar(this.buildDataSet()));
            }
            com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/unusedProceduresCharts.jasper", (String)"SubreportStream1", (Map)this.parameters);
        }
        monitor.setWorkRemaining(0);
        return queryResult != null ? queryResult.data : null;
    }

    private DefaultCategoryDataset buildDataSet() {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        ArrayList<String> prgrList = new ArrayList<String>(this.progrWithUnusedProc.keySet());
        ProgramComparator pComparator = new ProgramComparator();
        pComparator.setMapWithCounts(this.progrWithUnusedProc);
        Collections.sort(prgrList, pComparator);
        int i = 0;
        int prag = 0;
        this.countsSame = 0;
        boolean endOfBars = false;
        for (String prg : prgrList) {
            Integer nr = this.progrWithUnusedProc.get(prg);
            if (i < 20) {
                ds.addValue((Number)nr, (Comparable)((Object)"program"), (Comparable)((Object)prg));
                prag = nr;
            } else if (!endOfBars) {
                if (prag == nr) {
                    ++this.countsSame;
                } else {
                    endOfBars = true;
                }
            }
            ++i;
        }
        return ds;
    }

    private Image createPieChartImage(DefaultPieDataset dataset, Map formatsMap) {
        TextTitle title = null;
        EZPiePlot plot = new EZPiePlot((PieDataset)dataset);
        plot.setFormatsMap(formatsMap);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        plot.setInteriorGap(0.1);
        plot.setLabelFont(this.labelFont);
        plot.setShadowPaint(Color.white);
        plot.setLabelShadowPaint(Color.white);
        StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator("{0} {2}");
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setSectionPaint(0, this.RED_COLOR);
        plot.setSectionPaint(1, this.BLUE_COLOR);
        this.pieChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        this.pieChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.pieChart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = new LegendTitle((LegendItemSource)plot);
        legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        legend.setFrame((BlockFrame)new BlockBorder());
        legend.setBackgroundPaint((Paint)Color.white);
        legend.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.addSubtitle((Title)legend);
        LegendTitle legendTitle = this.pieChart.getLegend();
        legendTitle.setItemFont(this.labelFont);
        title = new TextTitle(Messages.getString(UnusedProcInPrgsReportBuilder.class, "pie1.title"), this.titleFont);
        this.pieChart.setTitle(title);
        return this.pieChart.createBufferedImage(880, 540, 440.0, 270.0, null);
    }

    private Image createStackedBar(DefaultCategoryDataset dataset) {
        String titleStr = Messages.getString(UnusedProcInPrgsReportBuilder.class, "pie2.title");
        if (this.progrWithUnusedProc.keySet().size() >= 20) {
            Object[] params = new String[]{String.valueOf(20)};
            titleStr = titleStr.concat(" ").concat(Messages.getString(UnusedProcInPrgsReportBuilder.class, "bar.title", params));
            if (this.countsSame != 0) {
                titleStr = titleStr.concat("*");
            }
        }
        TextTitle title = new TextTitle(titleStr, this.titleFont);
        this.verticalChart = ChartFactory.createBarChart(null, (String)Messages.getString(UnusedProcInPrgsReportBuilder.class, "bar.category.axis"), (String)Messages.getString(UnusedProcInPrgsReportBuilder.class, "bar.value.axis"), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.verticalChart.setTitle(title);
        this.verticalChart.setBackgroundPaint((Paint)Color.white);
        this.verticalChart.setBorderVisible(false);
        this.verticalChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        CategoryPlot plot = this.verticalChart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        if (this.countsSame != 0) {
            Object[] msgParams = new String[]{String.valueOf(this.countsSame)};
            String subtitle = Messages.getString(UnusedProcInPrgsReportBuilder.class, "bar.subtitle", msgParams);
            this.parameters.put("footerNote", subtitle);
        }
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.black);
        axis.setLabelFont(this.labelFont);
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.1);
        rangeAxis.setAxisLinePaint((Paint)Color.black);
        rangeAxis.setLabelFont(this.labelFont);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setMaximumBarWidth(0.1);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setBaseOutlinePaint((Paint)Color.LIGHT_GRAY);
        renderer.setSeriesPaint(0, (Paint)this.RED_COLOR);
        return this.verticalChart.createBufferedImage(880, 600, 440.0, 300.0, null);
    }

    @Override
    public void cleanMemory() {
        this.titleFont = null;
        this.labelFont = null;
        this.pieChart = null;
        this.verticalChart = null;
        this.BLUE_COLOR = null;
        this.RED_COLOR = null;
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        if (this.progrWithUnusedProc != null) {
            this.progrWithUnusedProc.clear();
            this.progrWithUnusedProc = null;
        }
        super.cleanMemory();
    }
}

