/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.deadCode.unusedPrgs;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.report.application.ezreport.reports.EZPiePlot;
import com.ez.report.application.ezreport.reports.deadCode.unusedPrgs.Obj4UnusedPrograms;
import com.ez.report.application.ezreport.reports.deadCode.unusedPrgs.UnusedPrgsReport;
import com.ez.report.application.ezreport.reports.deadCode.unusedPrgs.UnusedProgramsDataSource;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedPrgsReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UnusedPrgsReportBuilder.class);
    private static final String EZREP_UNUSED_PROGRAMS = "EZReports_UnusedProgramsReport";
    private static final String EZREP_UNUSED_PROGRAMS_SELECTIVE = "EZReports_UnusedProgramsReport_Selective";
    private static final String EZREP_UNUSED_PROGRAMS_TRAN = "EZReports_UnusedPrograms_MappedTran";
    private static final String EZREP_UNUSED_PROGRAMS_TRAN_SELECTIVE = "EZReports_UnusedPrograms_MappedTran_Selective";
    private Obj4UnusedPrograms unusedObj;
    private Font labelFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)10, (boolean)false);
    private Font titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)14, (boolean)false);
    private static final String PIECHART_UNREFERENCED_KEY = Messages.getString(UnusedPrgsReportBuilder.class, "unused.pie.label");
    private static final String PIECHART_REFERENCED_KEY = Messages.getString(UnusedPrgsReportBuilder.class, "used.pie.label");
    private JFreeChart pieChart;
    Color RED_COLOR = new Color(217, 79, 79);
    Color BLUE_COLOR = new Color(105, 177, 148);
    private Set unusedProgram = null;
    private CSVWriter csvWriter;
    private int step = 0;

    public UnusedPrgsReportBuilder(String reportName, String settings) {
        this.report = null;
        this.unusedProgram = new HashSet();
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UnusedPrgsReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        this.csvWriter = this.initTempCSVFile();
        if (this.csvWriter != null) {
            this.writeCSVHeader(this.csvWriter, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            this.csvWriter.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "unusedListLbl"));
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        this.data((IProgressMonitor)monitor.newChild(100));
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        UnusedProgramsDataSource dataSource = new UnusedProgramsDataSource(this.unusedObj);
        return dataSource;
    }

    @Override
    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new UnusedPrgsReport(this.project, this.getSelectionFlagFromInputs());
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput(prgList);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", selectedApps != null);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        params.put("summary", params.get("report.summary"));
        params.put("detail", params.get("report.details"));
        this.parameters.put("appendixFirstLineValue", String.valueOf(this.getSelected().size()));
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UnusedPrgsReportBuilder.class, "computeParameters.process.name"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.putSubreportStream("/reports/subCols1-layout7.jasper", "detailsSubreportTemplate_prg");
        this.putSubreportStream("/reports/subCols1-layout4.jasper", "detailsSubreportTemplate");
        monitor.worked(100);
        return this.parameters;
    }

    private void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(UnusedPrgsReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(UnusedPrgsReportBuilder.class, "unusedListLbl");
        params.put("unusedListLbl", externalized);
        externalized = Messages.getString(UnusedPrgsReportBuilder.class, "tranNotExecListLbl");
        params.put("tranNotExecListLbl", externalized);
        externalized = Messages.getString(UnusedPrgsReportBuilder.class, "report.sum1.lbl");
        params.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(UnusedPrgsReportBuilder.class, "report.sum2.lbl");
        params.put("report.sum2.lbl", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/unusedPrograms.jasper";
    }

    private void clearForJasperReport() {
        this.unusedProgram.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("unusedList", null);
    }

    @Override
    protected String getProcedure() {
        if (this.step == 0) {
            return EZREP_UNUSED_PROGRAMS;
        }
        return EZREP_UNUSED_PROGRAMS_TRAN;
    }

    @Override
    protected String getSelectiveProcedure() {
        if (this.step == 0) {
            return EZREP_UNUSED_PROGRAMS_SELECTIVE;
        }
        return EZREP_UNUSED_PROGRAMS_TRAN_SELECTIVE;
    }

    private String[][] data(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(UnusedPrgsReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer, this.filterSelectedIDs());
        String[][] results = queryResult.data;
        int allPrgNo = queryResult.resourcesCount;
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        HashMap<Integer, String> inputPrgMap = new HashMap<Integer, String>();
        for (ProgramInputNoGUI prg : prgList) {
            inputPrgMap.put(prg.getResourceID(), prg.getListableName());
        }
        DSFactory factory = new DSFactory();
        SC1DataSource prgDS = (SC1DataSource)factory.createDS(3);
        prgDS.setLayout(4);
        ArrayList<ObjectForSubreport> pList = new ArrayList<ObjectForSubreport>();
        prgDS.setList(pList);
        if (results == null) {
            L.warn("no results for UnusedPrograms report");
        } else {
            L.debug("UnusedPrograms results:");
            this.parameters.put("report.sum1", new Integer(allPrgNo));
            boolean first = true;
            ObjectForSubreport obj4UnusedPrg = null;
            int i = 0;
            while (i < results.length) {
                String prgName = this.computePrgName(results[i], inputPrgMap);
                this.unusedProgram.add(prgName);
                if (this.csvWriter != null) {
                    this.csvWriter.writeLine(prgName);
                }
                L.debug("program: {}", (Object)prgName);
                L.debug("\n");
                if (first) {
                    obj4UnusedPrg = new ObjectForSubreport();
                    obj4UnusedPrg.setExp(prgName);
                    pList.add(obj4UnusedPrg);
                } else {
                    obj4UnusedPrg.setExpVal(prgName);
                }
                first = !first;
                ++i;
            }
            this.parameters.put("report.sum2", new Integer(this.unusedProgram.size()));
        }
        this.step = 1;
        SingleQueryResult queryResult2 = this.queryForData(pmonitor, EZSourceDataType.Integer, this.filterSelectedIDs());
        String[][] results2 = queryResult2.data;
        SC1DataSource mappedPrgDS = (SC1DataSource)factory.createDS(3);
        mappedPrgDS.setLayout(7);
        ArrayList<ObjectForSubreport> objList = new ArrayList<ObjectForSubreport>();
        mappedPrgDS.setList(objList);
        if (this.csvWriter != null) {
            this.csvWriter.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "tranNotExecListLbl"));
        }
        if (results2 == null) {
            L.warn("no results for UnusedPrograms report for mapped transaction not being used");
        } else {
            if (this.csvWriter != null) {
                this.csvWriter.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "tranInfo"));
            }
            int i = 0;
            while (i < results2.length) {
                String prgName = this.computePrgName(results2[i], inputPrgMap);
                ObjectForSubreport objectForSubreport = new ObjectForSubreport();
                String reg = results2[i][6] == null || results2[i][6].isEmpty() ? null : results2[i][6];
                String env = String.valueOf(14).equals(results2[i][5]) ? "CICS" : "IMS";
                String msg = reg == null ? Messages.getString(UnusedPrgsReportBuilder.class, "tran.mapped.info", new Object[]{prgName, results2[i][4], env}) : Messages.getString(UnusedPrgsReportBuilder.class, "tran.mapped.info.region", new Object[]{prgName, results2[i][4], env, reg});
                objectForSubreport.setExp(msg);
                if (this.csvWriter != null) {
                    this.csvWriter.writeLine(msg);
                }
                objList.add(objectForSubreport);
                ++i;
            }
        }
        this.unusedObj = new Obj4UnusedPrograms((BaseSubreportDataSource)prgDS, (BaseSubreportDataSource)mappedPrgDS);
        if (allPrgNo != 0) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(UnusedPrgsReportBuilder.class, "used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(UnusedPrgsReportBuilder.class, "unused.category.lbl");
            dataset.setValue((Comparable)((Object)PIECHART_UNREFERENCED_KEY), (Number)new Double(this.unusedProgram.size()));
            dataset.setValue((Comparable)((Object)PIECHART_REFERENCED_KEY), (Number)new Double(allPrgNo - this.unusedProgram.size()));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(PIECHART_UNREFERENCED_KEY, unusedCategory);
            formatsMap.put(PIECHART_REFERENCED_KEY, usedCategory);
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap));
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    private String computePrgName(String[] results, Map<Integer, String> inputPrgMap) {
        String prgName = results[0];
        String parentName = results[1];
        Integer prgID = new Integer(Integer.parseInt(results[3]));
        String string = prgName = inputPrgMap.get(prgID) != null ? inputPrgMap.get(prgID) : prgName;
        if (Utils.filterNullValue((String)parentName) != null && !parentName.isEmpty()) {
            prgName = String.valueOf(parentName) + ": " + prgName;
        }
        return prgName;
    }

    private Image createPieChartImage(DefaultPieDataset dataset, Map formatsMap) {
        TextTitle title = null;
        EZPiePlot plot = new EZPiePlot((PieDataset)dataset);
        plot.setFormatsMap(formatsMap);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        this.pieChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        this.pieChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.pieChart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = new LegendTitle((LegendItemSource)plot);
        legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        legend.setBorder(new BlockBorder());
        legend.setBackgroundPaint((Paint)Color.white);
        legend.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.addSubtitle((Title)legend);
        LegendTitle legendTitle = this.pieChart.getLegend();
        legendTitle.setItemFont(this.labelFont);
        plot.setLabelFont(this.labelFont);
        plot.setShadowPaint(Color.white);
        plot.setLabelShadowPaint(Color.white);
        title = new TextTitle(Messages.getString(UnusedPrgsReportBuilder.class, "pie1.title"), this.titleFont);
        StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator("{0} {2}");
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setSectionPaint(0, this.RED_COLOR);
        plot.setSectionPaint(1, this.BLUE_COLOR);
        this.pieChart.setTitle(title);
        return this.pieChart.createBufferedImage(880, 540, 440.0, 270.0, null);
    }

    @Override
    public void cleanMemory() {
        if (this.unusedProgram != null) {
            this.unusedProgram.clear();
            this.unusedProgram = null;
        }
        this.BLUE_COLOR = null;
        this.RED_COLOR = null;
        this.labelFont = null;
        this.titleFont = null;
        this.pieChart = null;
        super.cleanMemory();
    }
}

