/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.cyclomatic;

import com.ez.report.application.ezreport.reports.cyclomatic.CyclomaticComplexityReport;
import com.ez.report.application.ezreport.reports.cyclomatic.CyclomaticDataSource;
import com.ez.report.application.ezreport.reports.cyclomatic.Obj4CyclomaticReportComparator;
import com.ez.report.application.ezreport.reports.threshold.ThresholdAbstractReportBuilder;
import com.ez.report.application.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.all.Obj4CyclomaticReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.model.HeadingBeanComparator;
import com.ez.report.generation.common.utils.RGB;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyclomaticReportBuilder
extends ThresholdAbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CyclomaticReportBuilder.class);

    public CyclomaticReportBuilder(String reportName) {
        this(reportName, null);
    }

    public CyclomaticReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.firstString = Messages.getString(CyclomaticReportBuilder.class, "diagram.easy.prag");
        this.secondString = Messages.getString(CyclomaticReportBuilder.class, "diagram.moderate.prag");
        this.thirdString = Messages.getString(CyclomaticReportBuilder.class, "diagram.difficult.prag");
    }

    @Override
    protected void initializeFromPreferences() {
        try {
            String simpleThresholdFromModel = (String)this.report.getProperty("simpleThresholdPreference");
            this.firstPrag = simpleThresholdFromModel != null ? Integer.parseInt(simpleThresholdFromModel) : Utils.DEF_CYCLOMATIC_EASY;
            String moderateThresholdFromModel = (String)this.report.getProperty("mediumThresholdPreference");
            this.secondPrag = moderateThresholdFromModel != null ? Integer.parseInt(moderateThresholdFromModel) : Utils.DEF_CYCLOMATIC_MEDIUM;
            String color = (String)this.report.getProperty("simpleColorPreference");
            RGB rgbColor = null;
            rgbColor = color != null ? Utils.asRGB(color) : Utils.DEF_CYCLOMATIC_EASY_COLOR;
            this.firstColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            color = (String)this.report.getProperty("mediumColorPreference");
            rgbColor = color != null ? Utils.asRGB(color) : Utils.DEF_CYCLOMATIC_MEDIUM_COLOR;
            this.secondColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            color = (String)this.report.getProperty("complexColorPreference");
            rgbColor = color != null ? Utils.asRGB(color) : Utils.DEF_CYCLOMATIC_DIFFICULT_COLOR;
            this.thirdColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            this.parameters.put("simplePragValue", new Integer(this.firstPrag));
            this.parameters.put("moderatePragValue", new Integer(this.secondPrag));
        }
        catch (NumberFormatException e) {
            L.error("error at initializind report parameters from report properties", (Throwable)e);
        }
    }

    @Override
    protected void data(IProgressMonitor pmonitor) {
        this.initializeFromPreferences();
        this.writeCSVThresHolds();
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CyclomaticReportBuilder.class, "computeData.taskName"));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        int no = prgList.size();
        this.parameters.put("inputResourcesCount", new Integer(no).toString());
        this.buildInputs4Appendix(prgList);
        this.parameters.put("appendixFirstLineValue", String.valueOf(no));
        this.putSubreportStream("reports/EZReportScoresReport.jasper", "ScoresSubreport");
        this.parameters.put("title.appFieldValues", this.applicationsName);
        monitor.worked(10);
        Map<String, Integer> generalCyclomaticResults = this.computeCyclomaticWithLock(prgList, (IProgressMonitor)monitor);
        if (generalCyclomaticResults.isEmpty()) {
            L.warn("no results for cyclomatic report");
        } else {
            L.debug("CYCLOMATIC results:");
            SubMonitor resMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(40), (int)generalCyclomaticResults.size());
            this.addOtherInfosInCVS();
            for (String programName : generalCyclomaticResults.keySet()) {
                Integer value = (int)generalCyclomaticResults.get(programName);
                L.debug("program: {}", (Object)programName);
                L.debug("base cyclomatic value: {}", (Object)value);
                L.debug("\n");
                if (this.maxWeight < (double)value.intValue()) {
                    this.maxWeight = value.intValue();
                }
                if (this.csvWriter != null) {
                    this.csvWriter.write(new String[]{programName, String.valueOf(value), this.getRegionString(value)});
                }
                Obj4CyclomaticReport obj = new Obj4CyclomaticReport(Messages.getString(CyclomaticReportBuilder.class, "resource.name"), programName, value, this.getRegionString(value));
                this.result4BarChart.put(programName, value);
                this.resultList.add(obj);
                this.addScore(programName, value);
                resMonitor.worked(1);
            }
            resMonitor.setWorkRemaining(0);
        }
        monitor.setTaskName(Messages.getString(CyclomaticReportBuilder.class, "processData.taskName"));
        Collections.sort(this.resultList, new Obj4CyclomaticReportComparator());
        if (this.scores != null && this.scores.size() > 1) {
            Collections.sort(this.scores, new HeadingBeanComparator(false));
            this.parameters.put("scoresValues", this.scores);
            this.parameters.put("scores.title", Messages.getString(CyclomaticReportBuilder.class, "scores.page.title"));
            this.parameters.put("programs.column.title", Messages.getString(CyclomaticReportBuilder.class, "programs.column.title"));
            this.parameters.put("scores.column.title", Messages.getString(CyclomaticReportBuilder.class, "scores.column.title"));
        }
        if (this.result4BarChart.keySet() != null && this.result4BarChart.keySet().size() > 1) {
            String title = Messages.getString(CyclomaticReportBuilder.class, "bar.diagram.title");
            this.createStackedBarChartImage(title, true);
            String pieTitle = Messages.getString(CyclomaticReportBuilder.class, "pie.title");
            this.parameters.put("mcCabePie", this.createPieChartImage(pieTitle));
        } else {
            this.parameters.put("SubreportStream", null);
        }
        monitor.worked(10);
        monitor.setWorkRemaining(0);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/threshold.jasper";
    }

    @Override
    protected String getWizardTitle() {
        return Messages.getString(CyclomaticReportBuilder.class, "wizzard.title");
    }

    @Override
    protected AbstractReportDataSource getReportDataSource() {
        return new CyclomaticDataSource(this.resultList);
    }

    @Override
    protected AbstractReport getReport() {
        return new CyclomaticComplexityReport(this.project);
    }

    @Override
    protected String getQueryCount4Wizard() {
        return "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 10, 11, 13, 14, 15, 16,19) ";
    }

    @Override
    protected String getDomainAxis4VerticalChart() {
        return Messages.getString(((Object)((Object)this)).getClass(), "procent.of.label");
    }
}

