/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules;

import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource;
import com.ez.report.application.internal.Messages;
import com.ez.report.generation.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryRulesDS
extends DetailsDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SummaryRulesDS.class);
    private Pair<Integer, Integer> totalValues;
    private DetailsDataSource totalsDS;

    public SummaryRulesDS(String title, List list, int type) {
        super(title, list, type);
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("totalsTemplate")) {
            try {
                value = Utils.loadReport((String)"reports/subCols3_totals.jasper");
            }
            catch (JRException e) {
                L.error("error at loading totalsTemplate", (Throwable)e);
            }
        } else {
            value = field.getName().equals("totalsDS") ? this.getTotals() : super.getFieldValue(field);
        }
        return value;
    }

    private Object getTotals() {
        if (this.totalsDS == null) {
            this.totalsDS = new DetailsDataSource(3);
            ArrayList<ObjectForSubreport3Link> totalsLst = new ArrayList<ObjectForSubreport3Link>();
            this.totalsDS.setList(totalsLst);
            ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
            obj.setLeftValue(Messages.getString(SummaryRulesDS.class, "totals.label"));
            if (this.totalValues != null) {
                obj.setMiddleValue(((Integer)this.totalValues.getFirst()).toString());
                obj.setRightValue(((Integer)this.totalValues.getSecond()).toString());
            }
            totalsLst.add(obj);
        }
        return this.totalsDS;
    }

    public void setTotals(Pair<Integer, Integer> totals) {
        this.totalValues = totals;
    }
}

