/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules;

import com.ez.codingrules.Rule;
import com.ez.codingrules.cobol.CobolRule;
import com.ez.codingrules.cobol.CobolRuleResult;
import com.ez.codingrules.cobol.CobolRuleResultWithIterators;
import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.report.application.internal.Messages;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesExecutor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RulesExecutor.class);
    static RulesExecutor instance = new RulesExecutor();
    Rule rule;
    Collection<ProgramInputNoGUI> inputs;

    public static RulesExecutor getInstance() {
        return instance;
    }

    private RulesExecutor() {
    }

    public void setRule(Rule r) {
        this.rule = r;
    }

    public void setInputPrograms(Collection<ProgramInputNoGUI> inputs) {
        this.inputs = inputs;
    }

    public CobolRuleResult execute(IProgressMonitor monitor, CobolRule r, Collection<Integer> inputs, EZSourceConnection bridge) {
        L.debug("before executing rule: {}", (Object)r.getName());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CobolRuleResult newRes = null;
        HashMap<String, Collection<Integer>> params = new HashMap<String, Collection<Integer>>();
        if (inputs != null || r.isCustom()) {
            params.put("programs", inputs);
        }
        params.put("bridge", (Collection<Integer>)bridge);
        try {
            newRes = r.execute((IProgressMonitor)subMonitor.newChild(90), params);
            L.debug("after executing rule: {}", (Object)r.getName());
        }
        catch (RuntimeException ex) {
            L.error("error at executing rule {}", (Object)r.getName(), (Object)ex);
            newRes.addMessage(new LogMessage(Messages.getString(RulesExecutor.class, "errorAtExecuting", new String[]{r.getName()}), 4, "com.ez.mainframe.reports.core", (Throwable)ex));
            newRes.hadError = true;
        }
        subMonitor.setWorkRemaining(0);
        return newRes;
    }

    public CobolRuleResultWithIterators begin(IProgressMonitor monitor, CobolRule r, Collection<Integer> inputs, EZSourceConnection bridge) {
        L.debug("before executing rule: {}", (Object)r.getName());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<String, Collection<Integer>> params = new HashMap<String, Collection<Integer>>();
        if (inputs != null) {
            params.put("programs", inputs);
        }
        params.put("bridge", (Collection<Integer>)bridge);
        CobolRuleResultWithIterators newRes = r.begin((IProgressMonitor)subMonitor.newChild(90), params);
        L.debug("after executing rule: {}", (Object)r.getName());
        subMonitor.setWorkRemaining(0);
        return newRes;
    }
}

