/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules;

import com.ez.codingrules.Rule;
import com.ez.codingrules.RuleInput;
import com.ez.codingrules.RuleParameter;
import com.ez.codingrules.cobol.CobolRule;
import com.ez.codingrules.cobol.CobolRuleResult;
import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.PathUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.report.application.ezreport.reports.codingrules.CSInput;
import com.ez.report.application.ezreport.reports.codingrules.RulesExecutor;
import com.ez.report.application.internal.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RuleBasedUtils.class);
    public static final String RULE_BASED_DIRECTORY = File.separator.concat("RuleBased").concat(File.separator);
    private static final String EMPTY_STRING = "";
    private static final String CSV_EXTENSION = ".csv";
    private static final String UNDERSCORE = "_";

    public static String getKeyForSelected(String paramkey) {
        String key = null;
        key = paramkey.equals("allCobolPrograms") ? "selected resources" : "selection".concat(paramkey);
        return key;
    }

    public static Map<String, Triplet<String, List<Rule>, String>> prepareInputs(List<Rule> rules) {
        HashMap<String, Triplet<String, List<Rule>, String>> queriesMap = new HashMap<String, Triplet<String, List<Rule>, String>>();
        for (Rule r : rules) {
            Map inputs = r.getInputs();
            if (inputs == null) continue;
            for (RuleInput inp : inputs.values()) {
                String queryKey = inp.getKey();
                if (queryKey == null || inp.getQuery() == null) continue;
                Triplet info = (Triplet)queriesMap.get(queryKey);
                ArrayList<Rule> list = null;
                if (info == null) {
                    info = new Triplet();
                    info.setFirst((Object)inp.getQuery());
                    list = new ArrayList<Rule>();
                    info.setSecond(list);
                    list.add(r);
                    info.setThird((Object)inp.getName());
                    queriesMap.put(queryKey, (Triplet<String, List<Rule>, String>)info);
                    continue;
                }
                list = (ArrayList<Rule>)info.getSecond();
                list.add(r);
            }
        }
        return queriesMap;
    }

    public static boolean resolveRules(Collection<CobolRule> rules, Collection<CobolRule> rulesForReport, Collection<CobolRule> rulesForCVS, Map<String, Object> inputs) {
        boolean hasPredefinedRule = false;
        for (CobolRule rule : rules) {
            boolean isPredefinedRule = false;
            isPredefinedRule = !rule.isSourceBased() ? RuleBasedUtils.resolveRule(rulesForCVS, rule, inputs) : RuleBasedUtils.resolveRule(rulesForReport, rule, inputs);
            if (!isPredefinedRule) continue;
            hasPredefinedRule = true;
        }
        return hasPredefinedRule;
    }

    private static boolean resolveRule(Collection<CobolRule> rules, CobolRule rule, Map<String, Object> inputs) {
        boolean isPredefinedRule = false;
        String query = rule.getQuery();
        if (query == null) {
            rules.add(rule);
            isPredefinedRule = true;
        } else if (!rule.hasInputs() && !rule.hasParameters()) {
            rules.add(rule);
        } else {
            HashMap<String, String> keys = new HashMap<String, String>();
            if (rule.hasParameters()) {
                Map params = rule.getParameters();
                for (RuleParameter param : params.values()) {
                    String value = param.getValue();
                    String paramKey = param.getKey();
                    keys.put(paramKey, value);
                }
            }
            boolean isApplicable = true;
            if (rule.hasInputs()) {
                Map ruleInputs = rule.getInputs();
                boolean manyInputs = ruleInputs.values().size() > 1;
                for (RuleInput input : ruleInputs.values()) {
                    String inputkey = input.getKey();
                    String keyFromWizard = RuleBasedUtils.getKeyForSelected(inputkey);
                    List selectedInputs = (List)inputs.get(keyFromWizard);
                    if (selectedInputs != null) {
                        String tblName;
                        HashSet<String> vals = new HashSet<String>();
                        RuleInput.InputWrap wrap = new RuleInput.InputWrap(input);
                        wrap.values = vals;
                        if (!selectedInputs.isEmpty()) {
                            for (CSInput inp : selectedInputs) {
                                if (input.isNumeric()) {
                                    wrap.isNumeric = true;
                                }
                                vals.add(inp.getName());
                            }
                        }
                        input.setWrap(wrap);
                        wrap.tblName = tblName = manyInputs ? "tempTbl" + inputkey : (wrap.isNumeric ? "numeric_param_temp" : "string_param_temp");
                        keys.put(inputkey, tblName);
                        continue;
                    }
                    isApplicable = false;
                    L.warn("there is not any input {} required by rule {}, so this rule will be ignored", (Object)inputkey, (Object)rule.getListableName());
                }
            }
            if (isApplicable) {
                query = RuleBasedUtils.replaceKeys(query, keys);
                rule.setQuery(query);
                rules.add(rule);
                keys.clear();
            }
        }
        return isPredefinedRule;
    }

    public static String replaceKeys(String text, Map<String, String> keys) {
        Pattern p = Pattern.compile("\\{[^{}:]*(:[^{}:]*)?\\}");
        Matcher m = p.matcher(text);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (m.find()) {
            int i = 0;
            while (i < m.groupCount()) {
                int start = m.start();
                int end = m.end();
                String group = m.group(i).substring(1, m.group(i).length() - 1);
                String[] parts = group.split(":");
                sb.append(text.substring(pos, start));
                String val = keys.get(parts[0]);
                if (parts.length == 1) {
                    if (val != null) {
                        sb.append(val);
                    }
                } else if (val == null) {
                    sb.append(parts[1]);
                } else {
                    sb.append(val);
                }
                pos = end;
                ++i;
            }
        }
        if (pos < text.length()) {
            sb.append(text.substring(pos, text.length()));
        }
        return sb.toString();
    }

    public static List<CobolRule> exportInCSV(Collection<CobolRule> rulesForCVS, Collection<Integer> programIds, IProgressMonitor pMonitor, Map<String, Object> inputs, String project, Queue<LogMessage> messages) {
        L.debug("start export in csv");
        ArrayList<CobolRule> notApplicable = new ArrayList<CobolRule>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)(60 * rulesForCVS.size()));
        RulesExecutor exec = RulesExecutor.getInstance();
        EZSourceConnection bridge = EZSourceConnectionManager.getCurrent();
        try {
            try {
                File exportDir = null;
                String exportPath = (String)inputs.get("csvOutFolder");
                if (exportPath != null && !exportPath.isEmpty()) {
                    exportDir = new File(exportPath);
                    exportDir.mkdirs();
                }
                if (exportDir == null || !exportDir.exists()) {
                    exportPath = String.valueOf(PathUtils.METADATA_FOLDER.getPath()) + RULE_BASED_DIRECTORY;
                    exportDir = new File(exportPath);
                }
                for (CobolRule r : rulesForCVS) {
                    if (monitor.isCanceled()) {
                        throw new CanceledException("export in csv is canceled by user");
                    }
                    String name = r.getName();
                    String subTaskName = Messages.getString(RuleBasedUtils.class, "monitor.buildcvsdata.subtask", new String[]{name});
                    monitor.subTask(subTaskName);
                    CobolRuleResult res = exec.execute((IProgressMonitor)monitor.newChild(50), r, programIds, bridge);
                    if (res != null) {
                        if (res.getMessages() != null) {
                            messages.addAll(res.getMessages());
                        }
                        if (res.hadError) {
                            L.warn("rule: {} had errors", (Object)r);
                            notApplicable.add(r);
                            continue;
                        }
                        String ruleNameForFile = RuleBasedUtils.sanitizeFilename(name);
                        StringBuilder exportContent = res.getExportCSV();
                        String fileName = project.concat(UNDERSCORE).concat(ruleNameForFile).concat(UNDERSCORE + System.currentTimeMillis() + CSV_EXTENSION);
                        File exportFile = new File(exportDir, fileName);
                        L.debug("exporting results for {} in file: {}", (Object)name, (Object)fileName);
                        RuleBasedUtils.exportInFile(exportFile, monitor.newChild(10), exportContent, messages);
                        exportContent = null;
                        continue;
                    }
                    L.warn("null result for rule: {}", (Object)r);
                    notApplicable.add(r);
                }
            }
            catch (Exception e) {
                L.error("while exporting csv", (Throwable)e);
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
            }
        }
        finally {
            EZSourceConnectionManager.release((EZSourceConnection)bridge);
        }
        return notApplicable;
    }

    private static void exportInFile(File exportFile, SubMonitor monitor, StringBuilder content, Queue<LogMessage> messages) {
        block12: {
            new File(exportFile.getParent()).mkdirs();
            BufferedWriter bw = null;
            try {
                try {
                    bw = new BufferedWriter(new FileWriter(exportFile));
                    bw.write(content.toString());
                }
                catch (IOException e) {
                    L.error("Failed to write to CSV export file: {}", (Object)exportFile.getAbsolutePath(), (Object)e);
                    messages.add(new LogMessage(Messages.getString(RuleBasedUtils.class, "export.csv.write.error.msg"), 4, "com.ez.mainframe.reports.core", (Throwable)e));
                    if (bw == null) break block12;
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        L.warn("Failed to close CSV export file {}", (Object)exportFile.getAbsolutePath(), (Object)e2);
                        messages.add(new LogMessage(Messages.getString(RuleBasedUtils.class, "export.csv.close.warn.msg"), 2, "com.ez.mainframe.reports.core", (Throwable)e2));
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        L.warn("Failed to close CSV export file {}", (Object)exportFile.getAbsolutePath(), (Object)e);
                        messages.add(new LogMessage(Messages.getString(RuleBasedUtils.class, "export.csv.close.warn.msg"), 2, "com.ez.mainframe.reports.core", (Throwable)e));
                    }
                }
            }
        }
    }

    private static String sanitizeFilename(String name) {
        return name.replaceAll("[:\\\\/*?|<>]", UNDERSCORE);
    }
}

