/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules;

import com.ez.codingrules.cobol.CobolRule;
import com.ez.codingrules.cobol.CobolRuleResult;
import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.codingrules.DetailsDataSource;
import com.ez.report.application.ezreport.reports.codingrules.ObjectForDetailsSubreport;
import com.ez.report.application.ezreport.reports.codingrules.ResultPathComparator;
import com.ez.report.application.ezreport.reports.codingrules.RuleElement;
import com.ez.report.application.ezreport.reports.codingrules.RulesComparator;
import com.ez.report.application.ezreport.reports.codingrules.RulesExecutor;
import com.ez.report.application.ezreport.reports.codingrules.SummaryDS;
import com.ez.report.application.ezreport.reports.codingrules.SummaryRulesDS;
import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.application.internal.Messages;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datasource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Datasource.class);
    private static final String NEW_LINE_STRING = "\n";
    private RuleElement currentValue;
    private Collection<Integer> programIds;
    private List<CobolRule> rules;
    private boolean onAllResources = false;
    private RulesExecutor exec;
    private SubMonitor monitor;
    private EZSourceConnection bridge;
    SummaryDS summaryElement;
    private List<ObjectForSubreport3Link> summList = null;
    Map<String, Pair<Set<String>, Integer>> progSummary = null;
    Integer totalFailures = 0;
    Integer totalWeight = 0;
    private SummaryRulesDS summaryRulesDS;
    Queue<LogMessage> messages;

    public Datasource(Collection<CobolRule> rules, Collection<Integer> programs, boolean onAllResources, IProgressMonitor pmonitor, Queue<LogMessage> builderMsg) {
        this.programIds = programs;
        this.rules = new ArrayList<CobolRule>(rules);
        Collections.sort(this.rules, new RulesComparator());
        this.onAllResources = onAllResources;
        this.monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(rules.size() * 10));
        this.monitor.subTask(Messages.getString(Datasource.class, "monitor.startprocess.subtask"));
        this.messages = builderMsg;
        this.init();
    }

    private void init() {
        L.debug("start init of DS");
        this.exec = RulesExecutor.getInstance();
        this.bridge = EZSourceConnectionManager.getCurrent();
        this.buildSummaryDS();
    }

    private void buildSummaryDS() {
        this.summaryElement = new SummaryDS("summary");
        String title = Messages.getString(Datasource.class, "rules.summary.section.title");
        this.summList = new ArrayList<ObjectForSubreport3Link>();
        this.summaryRulesDS = new SummaryRulesDS(title, this.summList, 3);
        this.summaryRulesDS.setTitleAnchor("rules summary anchor");
        this.summaryRulesDS.setCol1Title(Messages.getString(Datasource.class, "rules.summary.section.column1.title"));
        this.summaryRulesDS.setCol2Title(Messages.getString(Datasource.class, "rules.summary.section.column2.title"));
        this.summaryRulesDS.setCol3Title(Messages.getString(Datasource.class, "rules.summary.section.column3.title"));
        this.summaryElement.addDataSource((SubreportDataSource)this.summaryRulesDS);
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("detailsDataSource")) {
            value = this.currentValue.getDataSource();
        } else if (field.getName().equals("ruleName")) {
            value = this.currentValue.getGroupElem();
        } else if (field.getName().equals("subTitle")) {
            value = this.currentValue.getDescription();
        }
        return value;
    }

    public boolean nextItem() throws JRException {
        this.currentValue = null;
        if (this.rules.size() > 0) {
            CobolRule r = this.rules.iterator().next();
            this.rules.remove(r);
            L.trace("before build data for rule: {}", (Object)r.getName());
            this.currentValue = this.buildReportElement(r, this.monitor.newChild(10));
            L.trace("after build data for rule: {}", (Object)r.getName());
        } else {
            this.closeTransfer();
            this.summaryRulesDS.setTotals((Pair<Integer, Integer>)new Pair((Object)this.totalFailures, (Object)this.totalWeight));
            this.buildProgramsSummary();
            this.monitor.setWorkRemaining(0);
            this.monitor.subTask("");
        }
        return this.currentValue != null;
    }

    private void buildProgramsSummary() {
        if (this.progSummary != null && !this.progSummary.isEmpty()) {
            com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource summaryDS = new com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource(3);
            summaryDS.setTitleAnchor("programs summary anchor");
            summaryDS.setTitle(Messages.getString(Datasource.class, "programs.summary.section.title"));
            summaryDS.setCol1Title(Messages.getString(Datasource.class, "programs.summary.section.column1.title"));
            summaryDS.setCol2Title(Messages.getString(Datasource.class, "programs.summary.section.column2.title"));
            summaryDS.setCol3Title(Messages.getString(Datasource.class, "programs.summary.section.column3.title"));
            this.summaryElement.addDataSource((SubreportDataSource)summaryDS);
            ArrayList<ObjectForSubreport3Link> progSummList = new ArrayList<ObjectForSubreport3Link>();
            Set<String> progs = this.progSummary.keySet();
            ArrayList<String> tmp = new ArrayList<String>(progs);
            Collections.sort(tmp);
            for (String prgName : tmp) {
                Pair<Set<String>, Integer> vals = this.progSummary.remove(prgName);
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(prgName);
                obj.setMiddleValue(String.valueOf(((Set)vals.getFirst()).size()));
                obj.setRightValue(((Integer)vals.getSecond()).toString());
                progSummList.add(obj);
            }
            summaryDS.setList(progSummList);
        }
    }

    private RuleElement buildReportElement(CobolRule r, SubMonitor pMonitor) throws JRException {
        Object obj;
        String ruleNameToPrint;
        String ruleName = r.getName();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)100);
        subMonitor.subTask(Messages.getString(Datasource.class, "monitor.buildruledata.subtask", new String[]{ruleName}));
        int occurrences = 0;
        Integer weight = r.getWeight();
        String titleAnchor = ruleNameToPrint = ReportsUtils.stripNonValidXMLCharacters((String)ruleName, (boolean)true);
        this.currentValue = new RuleElement(ruleNameToPrint);
        DetailsDataSource detailsDS = new DetailsDataSource(5);
        ArrayList<ObjectForDetailsSubreport> objList = new ArrayList<ObjectForDetailsSubreport>();
        detailsDS.setList(objList);
        this.currentValue.addDataSource((SubreportDataSource)detailsDS);
        StringBuffer longText = new StringBuffer(r.getDescription());
        if (longText != null) {
            if (r.hasParameters()) {
                longText.append(NEW_LINE_STRING);
                longText.append("    ");
                longText.append(r.getParametersDescription());
            }
            boolean hasGroup = false;
            if (r.getGroupName() != null) {
                longText.append(NEW_LINE_STRING);
                longText.append(Messages.getString(Datasource.class, "details.rule.category.label", new String[]{r.getGroupName().toLowerCase()}));
                hasGroup = true;
            }
            if (r.getCustomerId() != null) {
                if (hasGroup) {
                    longText.append("; ");
                } else {
                    longText.append(NEW_LINE_STRING);
                }
                longText.append(Messages.getString(Datasource.class, "details.rule.number.label", new String[]{r.getCustomerId()}));
            }
            this.currentValue.setDescription(ReportsUtils.stripNonValidXMLCharacters((String)longText.toString(), (boolean)true));
        }
        detailsDS.setCol1Title(Messages.getString(Datasource.class, "details.column1.text"));
        detailsDS.setCol2Title(Messages.getString(Datasource.class, "details.column2.text"));
        CobolRuleResult res = !r.isCustom() && this.onAllResources ? this.exec.execute((IProgressMonitor)subMonitor.newChild(50), r, null, this.bridge) : this.exec.execute((IProgressMonitor)subMonitor.newChild(50), r, this.programIds, this.bridge);
        Queue ruleMess = res.getMessages();
        if (ruleMess != null && !ruleMess.isEmpty()) {
            this.messages.addAll(ruleMess);
        }
        boolean emptyRule = false;
        if (res != null) {
            if (res.hadError) {
                detailsDS.col1Title = null;
                detailsDS.col2Title = null;
                obj = new ObjectForDetailsSubreport();
                ((ObjectForDetailsSubreport)obj).groupName = Messages.getString(Datasource.class, "details.rule.ruleHadError");
                objList.add((ObjectForDetailsSubreport)obj);
            } else if (!res.isEmpty()) {
                if (this.progSummary == null) {
                    this.progSummary = new HashMap<String, Pair<Set<String>, Integer>>();
                }
                HashMap includesDet = new HashMap();
                Map progDetails = res.getPrograms();
                ArrayList tmpProgs = new ArrayList(progDetails.values());
                Collections.sort(tmpProgs, new ResultPathComparator());
                String progGroup = r.getLocationTitle();
                if (progGroup == null || progGroup.isEmpty()) {
                    progGroup = Messages.getString(Datasource.class, "details.rule.affectedprograms.groupname");
                }
                while (!tmpProgs.isEmpty()) {
                    CobolRuleResult.Result tmpRes = (CobolRuleResult.Result)tmpProgs.remove(0);
                    String prg = tmpRes.name;
                    L.trace("before build data for program: {}", (Object)prg);
                    CobolRuleResult.Result details = (CobolRuleResult.Result)progDetails.remove(prg);
                    Pair summData = this.progSummary.get(prg);
                    if (summData == null) {
                        summData = new Pair();
                        summData.setFirst(new HashSet());
                        summData.setSecond((Object)new Integer(0));
                        this.progSummary.put(prg, (Pair<Set<String>, Integer>)summData);
                    }
                    ((Set)summData.getFirst()).add(ruleName);
                    int summOcc = (Integer)summData.getSecond();
                    summData.setSecond((Object)(summOcc += details.occurrences.intValue()));
                    if (details.lines == null || details.lines.size() <= 0) continue;
                    occurrences += details.lines.size();
                    Datasource.buildDetailsObj(detailsDS, objList, progGroup, details);
                }
                Map includes = res.getIncludes();
                ArrayList inclTemp = new ArrayList(includes.keySet());
                Collections.sort(inclTemp);
                String inclGroup = Messages.getString(Datasource.class, "details.rule.affectedincludes.groupname");
                while (!inclTemp.isEmpty()) {
                    String path = (String)inclTemp.remove(0);
                    L.trace("before build data for include: {}", (Object)path);
                    CobolRuleResult.Result details = (CobolRuleResult.Result)includes.remove(path);
                    HashSet failures = (HashSet)includesDet.get(path);
                    if (failures == null) {
                        failures = new HashSet();
                        includesDet.put(path, failures);
                    }
                    failures.addAll(details.lines);
                    Set progs = details.programs;
                    for (String prgName : progs) {
                        Pair summData = this.progSummary.get(prgName);
                        if (summData == null) {
                            summData = new Pair();
                            summData.setFirst(new HashSet());
                            summData.setSecond((Object)new Integer(0));
                            this.progSummary.put(prgName, (Pair<Set<String>, Integer>)summData);
                        }
                        ((Set)summData.getFirst()).add(ruleName);
                        if (details.occurrences == null) continue;
                        int summOcc = (Integer)summData.getSecond();
                        summData.setSecond((Object)(summOcc += details.occurrences.intValue()));
                    }
                    Datasource.buildDetailsObj(detailsDS, objList, inclGroup, details);
                }
                for (String path : includesDet.keySet()) {
                    Set lines = (Set)includesDet.get(path);
                    occurrences += lines.size();
                }
            } else {
                emptyRule = true;
            }
        } else {
            emptyRule = true;
        }
        if (emptyRule) {
            detailsDS.col1Title = null;
            detailsDS.col2Title = null;
            obj = new ObjectForDetailsSubreport();
            ((ObjectForDetailsSubreport)obj).groupName = Messages.getString(Datasource.class, "details.rule.noresult");
            objList.add((ObjectForDetailsSubreport)obj);
        }
        obj = new ObjectForSubreport3Link();
        ((ObjectForSubreport3Link)((Object)obj)).setLeftValue(ruleNameToPrint);
        ((ObjectForSubreport3Link)((Object)obj)).setLeftAnchor(true);
        ((ObjectForSubreport3Link)((Object)obj)).setLeftLink(titleAnchor);
        ((ObjectForSubreport3Link)((Object)obj)).setMiddleValue(String.valueOf(occurrences));
        int thisWeight = weight != null ? weight * occurrences : 0;
        ((ObjectForSubreport3Link)((Object)obj)).setRightValue(weight != null ? String.valueOf(thisWeight) : "0");
        this.summList.add((ObjectForSubreport3Link)((Object)obj));
        this.totalFailures = this.totalFailures + occurrences;
        this.totalWeight = this.totalWeight + thisWeight;
        subMonitor.setWorkRemaining(0);
        subMonitor.subTask("");
        return this.currentValue;
    }

    private static void buildDetailsObj(DetailsDataSource detailsDS, ArrayList<ObjectForDetailsSubreport> objList, String groupName, CobolRuleResult.Result details) {
        Datasource.buildDetailsObj(detailsDS, objList, groupName, null, details);
    }

    public static void buildDetailsObj(DetailsDataSource detailsDS, ArrayList<ObjectForDetailsSubreport> objList, String groupName, String leftField, CobolRuleResult.Result details) {
        String printedPath;
        ObjectForDetailsSubreport obj = new ObjectForDetailsSubreport();
        obj.groupName = groupName;
        String string = printedPath = leftField != null ? leftField : details.path;
        if (printedPath == null) {
            printedPath = "";
            L.warn("trying to print an object without path: {}", (Object)details.name);
        }
        String linkPath = details.path;
        if (printedPath.contains("Mainframe Library Members")) {
            L.debug("a library member was found. path={}", (Object)printedPath);
            String[] parts = printedPath.split("\\\\");
            printedPath = String.valueOf(parts[parts.length - 2]) + " (" + parts[parts.length - 1] + ")";
        }
        if (details.isInclude) {
            ArrayList temp = new ArrayList(details.programs);
            Collections.sort(temp);
            String tmp = ((Object)temp).toString();
            tmp = tmp.substring(1);
            tmp = tmp.substring(0, tmp.length() - 1);
            printedPath = String.valueOf(printedPath) + Messages.getString(Datasource.class, "details.rule.affectedincludes.usedbyprograms.part", new String[]{tmp});
            temp = null;
        }
        obj.leftField = printedPath;
        objList.add(obj);
        List lines = details.lines;
        Collections.sort(lines);
        DetailsDataSource.LinesDS ds = new DetailsDataSource.LinesDS(detailsDS);
        ArrayList<DetailsDataSource.ReportRowWithLinks> linesLst = new ArrayList<DetailsDataSource.ReportRowWithLinks>();
        ds.setList(linesLst);
        obj.rightDS = ds;
        DetailsDataSource.ReportRowWithLinks l = null;
        int column = 0;
        for (Integer row : lines) {
            if (column == 8) {
                linesLst.add(l);
                column = 0;
                l = null;
            }
            if (l == null) {
                DetailsDataSource detailsDataSource = detailsDS;
                ((Object)((Object)detailsDataSource)).getClass();
                l = new DetailsDataSource.ReportRowWithLinks(detailsDataSource, null, null);
                column = 1;
            }
            String colValue = row.toString();
            switch (column) {
                case 1: {
                    l.setFirstField(colValue);
                    break;
                }
                case 2: {
                    l.setSecondField(colValue);
                    break;
                }
                case 3: {
                    l.setThirdField(colValue);
                    break;
                }
                case 4: {
                    l.setFourthField(colValue);
                    break;
                }
                case 5: {
                    l.setFifthField(colValue);
                    break;
                }
                case 6: {
                    l.setSixthField(colValue);
                    break;
                }
                case 7: {
                    l.setSeventhField(colValue);
                    break;
                }
            }
            if (linkPath != null) {
                String link = String.valueOf(linkPath) + "," + details.pType + "," + row;
                l.addHyperlink(link);
            } else {
                L.warn("line added without link: {}", (Object)colValue);
            }
            ++column;
        }
        if (l != null) {
            linesLst.add(l);
        }
    }

    public void cleanMemory() {
        this.exec = null;
        this.bridge = null;
        if (this.programIds != null) {
            this.programIds.clear();
            this.programIds = null;
        }
        if (this.progSummary != null) {
            this.progSummary.clear();
            this.progSummary = null;
        }
        if (this.rules != null) {
            this.rules.clear();
            this.rules = null;
        }
        this.summaryElement = null;
        this.summaryRulesDS = null;
        if (this.summList != null) {
            this.summList.clear();
            this.summList = null;
        }
    }

    public void closeTransfer() {
        this.bridge = null;
    }

    public SummaryDS getSummaryElement() {
        return this.summaryElement;
    }
}

