/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.List;
import java.util.Map;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;

public class EZPiePlot
extends PiePlot {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map formatsMap;

    public EZPiePlot(PieDataset dataset) {
        super(dataset);
    }

    public void setFormatsMap(Map formatsMap) {
        this.formatsMap = formatsMap;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.getDataset() == null) {
            return result;
        }
        List keys = this.getDataset().getKeys();
        Shape shape = this.getLegendItemShape();
        for (Comparable key : keys) {
            Stroke outlineStroke;
            String label;
            Number n = this.getDataset().getValue(key);
            boolean include = true;
            if (n == null) {
                include = !this.getIgnoreNullValues();
            } else {
                double v = n.doubleValue();
                if (v == 0.0) {
                    include = !this.getIgnoreZeroValues();
                } else {
                    boolean bl = include = v > 0.0;
                }
            }
            if (!include) continue;
            StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator((String)this.formatsMap.get(key));
            String description = label = labelGenerator.generateSectionLabel(this.getDataset(), key);
            String toolTipText = null;
            if (this.getLegendLabelToolTipGenerator() != null) {
                toolTipText = this.getLegendLabelToolTipGenerator().generateSectionLabel(this.getDataset(), key);
            }
            String urlText = null;
            Paint paint = this.getSectionPaint(key);
            Paint outlinePaint = this.getSectionOutlinePaint(key);
            if (outlinePaint == null) {
                outlinePaint = DEFAULT_OUTLINE_PAINT;
            }
            if ((outlineStroke = this.getSectionOutlineStroke(key)) == null) {
                outlineStroke = DEFAULT_OUTLINE_STROKE;
            }
            LegendItem item = new LegendItem(label, description, toolTipText, urlText, true, shape, true, paint, true, outlinePaint, outlineStroke, false, (Shape)new Line2D.Float(), (Stroke)new BasicStroke(), (Paint)Color.black);
            result.add(item);
        }
        return result;
    }
}

