/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration;

import com.ez.eclient.configuration.InputOutputException;
import com.ez.eclient.configuration.MutableConfiguration;
import com.ez.eclient.configuration.ReaderFactory;
import com.ez.eclient.configuration.WriterFactory;
import com.ez.eclient.configuration.validate.Argument;
import com.ez.json.tools.binding.Path;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesMutableConfiguration
implements MutableConfiguration {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String NULL_STRING = "null";
    private static Logger L = LoggerFactory.getLogger(PropertiesMutableConfiguration.class);
    private ReaderFactory rf;
    private WriterFactory wf;
    private Properties impl;
    private boolean closed;

    public PropertiesMutableConfiguration(ReaderFactory rf, WriterFactory wf) {
        Argument.isNotNull((Object)rf);
        Argument.isNotNull((Object)wf);
        this.rf = rf;
        this.wf = wf;
    }

    public MutableConfiguration setObject(String path, Object value) {
        this.checkState();
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        this.ensureRoot();
        this.impl.setProperty(path, value != null ? value.toString() : NULL_STRING);
        return this;
    }

    public MutableConfiguration setProperty(String path, Object value) {
        this.checkState();
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        this.ensureRoot();
        this.impl.setProperty(path, value != null ? value.toString() : NULL_STRING);
        return this;
    }

    public MutableConfiguration removeObject(String path) {
        this.checkState();
        this.ensureRoot();
        this.impl.remove(path);
        return this;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.writeConfiguration();
            }
            finally {
                this.impl = null;
                this.closed = true;
            }
        }
    }

    public Map getMapObject(String path) {
        this.checkState();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (Map)this.get(this.impl, path);
    }

    public List getListObject(String path) {
        this.checkState();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (List)this.get(this.impl, path);
    }

    public Object getObject(String path) {
        this.checkState();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return this.get(this.impl, path);
    }

    public Object getRootObject() {
        this.checkState();
        this.ensureRoot();
        return this.impl;
    }

    public void refresh() {
        this.checkState();
        this.impl = null;
    }

    private void ensureRoot() {
        if (this.impl == null) {
            this.impl = this.readConfiguration();
        }
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalArgumentException("Already closed.");
        }
    }

    private Object get(Object root, String path) {
        return Path.getObject((Object)root, (String)path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties readConfiguration() {
        Reader r = null;
        Properties properties = new Properties();
        try {
            try {
                r = this.rf.create();
                properties.load(r);
                return properties;
            }
            catch (InputOutputException ex) {
                L.error("Can't read.", (Throwable)ex);
                if (r == null) return properties;
                try {
                    r.close();
                    return properties;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return properties;
            }
            catch (IOException ex) {
                L.error("Can't read.", (Throwable)ex);
                if (r == null) return properties;
                try {
                    r.close();
                    return properties;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return properties;
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeConfiguration() {
        Writer w = null;
        try {
            try {
                w = this.wf.create();
                this.impl.store(w, null);
                return;
            }
            catch (InputOutputException ex) {
                L.error("Can't write.", (Throwable)ex);
                if (w == null) return;
                try {
                    w.close();
                    return;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return;
            }
            catch (IOException ex) {
                L.error("Can't write.", (Throwable)ex);
                if (w == null) return;
                try {
                    w.close();
                    return;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return;
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
            }
        }
    }
}

