/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.InputOutputException;
import com.ez.eclient.configuration.ReaderFactory;
import com.ez.eclient.configuration.validate.Argument;
import com.ez.json.tools.binding.Path;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfiguration
implements Configuration {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(PropertiesConfiguration.class);
    private ReaderFactory rf;
    private Object root = null;
    private boolean closed = false;

    public PropertiesConfiguration(ReaderFactory rf) {
        Argument.isNotNull((Object)rf);
        this.rf = rf;
    }

    public Map getMapObject(String path) {
        this.checkClosed();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (Map)this.get(this.root, path);
    }

    public List getListObject(String path) {
        this.checkClosed();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (List)this.get(this.root, path);
    }

    public Object getObject(String path) {
        this.checkClosed();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return this.get(this.root, path);
    }

    public Object getRootObject() {
        this.checkClosed();
        this.ensureRoot();
        return this.root;
    }

    public void refresh() {
        this.checkClosed();
        this.root = null;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.rf.release();
            }
            finally {
                this.rf = null;
                this.root = null;
                this.closed = true;
            }
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
    }

    private Object get(Object root, String path) {
        return Path.getObject((Object)root, (String)path);
    }

    private void ensureRoot() {
        block15: {
            if (this.root == null) {
                Reader r = null;
                try {
                    try {
                        r = this.rf.create();
                        Properties p = new Properties();
                        try {
                            p.load(r);
                        }
                        catch (IOException e) {
                            throw new InputOutputException("Can't load configuration.", (Exception)e);
                        }
                        this.root = this.load(p);
                    }
                    catch (InputOutputException ex) {
                        L.error("Can't read file.", (Throwable)ex);
                        if (r == null) break block15;
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            L.error("Can't close.", (Throwable)e);
                        }
                    }
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            L.error("Can't close.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private Object load(Properties p) {
        HashMap<String, String> ro = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            HashMap co = ro;
            Object[] accessors = Path.parsePath((String)key);
            int i = 0;
            while (i < accessors.length - 1) {
                String a = (String)accessors[i];
                HashMap m = (HashMap)co.get(a);
                if (m == null) {
                    m = new HashMap();
                    co.put(a, m);
                }
                co = m;
                ++i;
            }
            co.put((String)accessors[accessors.length - 1], value);
        }
        return ro;
    }
}

