/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration;

import com.ez.eclient.configuration.InputOutputException;
import com.ez.eclient.configuration.MutableConfiguration;
import com.ez.eclient.configuration.ReaderFactory;
import com.ez.eclient.configuration.WriterFactory;
import com.ez.eclient.configuration.validate.Argument;
import com.ez.json.tools.binding.JsonGenerator;
import com.ez.json.tools.binding.JsonParser;
import com.ez.json.tools.binding.Path;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMutableConfiguration
implements MutableConfiguration {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(JsonMutableConfiguration.class);
    private ReaderFactory rf;
    private WriterFactory wf;
    private Object root;
    private boolean closed;

    public JsonMutableConfiguration(ReaderFactory rf, WriterFactory wf) {
        Argument.isNotNull((Object)rf);
        Argument.isNotNull((Object)wf);
        this.rf = rf;
        this.wf = wf;
    }

    public MutableConfiguration setObject(String path, Object value) {
        this.checkState();
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        this.ensureRoot();
        Path.setObject((Object)this.root, (String)path, (Object)value);
        return this;
    }

    public MutableConfiguration setProperty(String path, Object value) {
        this.checkState();
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        this.ensureRoot();
        Path.setProperty((Object)this.root, (String)path, (Object)value);
        return this;
    }

    public MutableConfiguration removeObject(String path) {
        this.checkState();
        this.ensureRoot();
        Path.clearObject((Object)this.root, (String)path);
        return this;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.writeConfiguration();
            }
            finally {
                this.root = null;
                this.closed = true;
            }
        }
    }

    public Map getMapObject(String path) {
        this.checkState();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (Map)this.get(this.root, path);
    }

    public List getListObject(String path) {
        this.checkState();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (List)this.get(this.root, path);
    }

    public Object getObject(String path) {
        this.checkState();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return this.get(this.root, path);
    }

    public Object getRootObject() {
        this.checkState();
        this.ensureRoot();
        return this.root;
    }

    public void refresh() {
        this.checkState();
        this.root = null;
    }

    private void ensureRoot() {
        if (this.root == null) {
            this.root = this.readConfiguration();
            if (this.root == null) {
                this.root = new HashMap();
            }
        }
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalArgumentException("Already closed.");
        }
    }

    private Object get(Object root, String path) {
        return Path.getObject((Object)root, (String)path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readConfiguration() {
        Reader r = null;
        Object o = null;
        try {
            try {
                r = this.rf.create();
                try (JsonReader jsonReader = Json.createReader((Reader)r);){
                    JsonStructure rootj = jsonReader.read();
                    o = JsonParser.parseJson((JsonStructure)rootj);
                    return o;
                }
            }
            catch (InputOutputException ex) {
                L.error("Can't read.", (Throwable)ex);
                if (r == null) return o;
                try {
                    r.close();
                    return o;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return o;
            }
            catch (JsonParsingException ex) {
                L.error("Can't parse file.", (Throwable)ex);
                if (r == null) return o;
                try {
                    r.close();
                    return o;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return o;
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
            }
        }
    }

    private void writeConfiguration() {
        block16: {
            Writer w = null;
            try {
                try {
                    w = this.wf.create();
                    try (JsonWriter jw = Json.createWriter((Writer)w);){
                        JsonValue jv = JsonGenerator.generate((Object)this.root);
                        if (!(jv instanceof JsonStructure)) {
                            throw new RuntimeException("Not a json structure: " + jv);
                        }
                        jw.write((JsonStructure)jv);
                    }
                }
                catch (Exception ex) {
                    L.error("Can't write.", (Throwable)ex);
                    if (w == null) break block16;
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        L.error("Can't close.", (Throwable)e);
                    }
                }
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {
                        L.error("Can't close.", (Throwable)e);
                    }
                }
            }
        }
    }
}

