/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.InputOutputException;
import com.ez.eclient.configuration.ReaderFactory;
import com.ez.eclient.configuration.validate.Argument;
import com.ez.json.tools.binding.JsonParser;
import com.ez.json.tools.binding.Path;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfiguration
implements Configuration {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(JsonConfiguration.class);
    private final ReaderFactory rf;
    private Object root = null;
    private boolean closed = false;

    public JsonConfiguration(ReaderFactory rf) {
        Argument.isNotNull((Object)rf);
        this.rf = rf;
    }

    public Map getMapObject(String path) {
        this.checkClosed();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (Map)this.get(this.root, path);
    }

    public List getListObject(String path) {
        this.checkClosed();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return (List)this.get(this.root, path);
    }

    public Object getObject(String path) {
        this.checkClosed();
        Argument.isNotNull((Object)path);
        this.ensureRoot();
        return this.get(this.root, path);
    }

    public Object getRootObject() {
        this.checkClosed();
        this.ensureRoot();
        return this.root;
    }

    public void refresh() {
        this.checkClosed();
        this.root = null;
    }

    public void close() {
        if (!this.closed) {
            this.root = null;
            this.closed = true;
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
    }

    private void ensureRoot() {
        if (this.root == null) {
            this.root = this.readConfiguration();
            if (this.root == null) {
                this.root = new HashMap();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readConfiguration() {
        Reader r = null;
        Object o = null;
        try {
            try {
                r = this.rf.create();
                try (JsonReader jsonReader = Json.createReader((Reader)r);){
                    JsonStructure rootj = jsonReader.read();
                    o = JsonParser.parseJson((JsonStructure)rootj);
                    return o;
                }
            }
            catch (InputOutputException ex) {
                L.error("Can't read file.", (Throwable)ex);
                if (r == null) return o;
                try {
                    r.close();
                    return o;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return o;
            }
            catch (JsonParsingException ex) {
                L.error("Can't parse file.", (Throwable)ex);
                if (r == null) return o;
                try {
                    r.close();
                    return o;
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
                return o;
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    L.error("Can't close.", (Throwable)e);
                }
            }
        }
    }

    private Object get(Object root, String path) {
        return Path.getObject((Object)root, (String)path);
    }
}

