/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration;

import com.ez.eclient.configuration.InputOutputException;
import com.ez.eclient.configuration.WriterFactory;
import com.ez.eclient.configuration.internal.Utils;
import com.ez.eclient.configuration.validate.Argument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriterFactory
implements WriterFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FileWriterFactory.class);
    private File file;

    public FileWriterFactory(File file) {
        Argument.isNotNull((Object)file);
        this.file = file;
    }

    public Writer create() {
        try {
            File parent;
            if (!(this.file.exists() || (parent = this.file.getParentFile()).exists() || parent.mkdirs())) {
                L.error("Can't create {}", (Object)parent);
            }
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Utils.UTF8_CHARSET);
        }
        catch (IOException e) {
            throw new InputOutputException((Exception)e);
        }
    }

    public void release() {
    }

    public File getFile() {
        return this.file;
    }
}

