/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentBaseParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartFileToRecordContentParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartRequestCommand;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;

public class OServerCommandPostUploadSingleFile
extends OHttpMultipartRequestCommand<String, ORID> {
    private static final String[] NAMES = new String[]{"POST|uploadSingleFile/*"};
    protected StringWriter buffer;
    protected OJSONWriter writer;
    protected ORID fileRID;
    protected String fileDocument;
    protected String fileName;
    protected String fileType;
    protected long now;
    protected ODatabaseDocumentInternal database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        if (!iRequest.isMultipart) {
            iResponse.send(405, "Request is not multipart/form-data", "text/plain", "Request is not multipart/form-data", null);
        } else if (iRequest.multipartStream == null || iRequest.multipartStream.available() <= 0) {
            iResponse.send(405, "Content stream is null or empty", "text/plain", "Content stream is null or empty", null);
        } else {
            this.database = this.getProfiledDatabaseInstance(iRequest);
            try {
                this.buffer = new StringWriter();
                this.writer = new OJSONWriter((Writer)this.buffer);
                this.writer.beginObject();
                this.parse(iRequest, iResponse, new OHttpMultipartContentBaseParser(), new OHttpMultipartFileToRecordContentParser(), (ODatabaseDocument)this.database);
                boolean ok = this.saveRecord(iRequest, iResponse);
                this.writer.endObject();
                this.writer.flush();
                if (ok) {
                    iResponse.send(200, "OK", "application/json", this.buffer.toString(), null);
                }
            }
            finally {
                if (this.database != null) {
                    this.database.close();
                }
                this.database = null;
                if (this.buffer != null) {
                    this.buffer.close();
                }
                this.buffer = null;
                if (this.writer != null) {
                    this.writer.close();
                }
                this.writer = null;
                this.fileDocument = null;
                this.fileName = null;
                this.fileType = null;
                if (this.fileRID != null) {
                    this.fileRID.reset();
                }
                this.fileRID = null;
            }
        }
        return false;
    }

    @Override
    protected void processBaseContent(OHttpRequest iRequest, String iContentResult, HashMap<String, String> headers) throws Exception {
        if (headers.containsKey("name") && headers.get("name").equals(this.getDocumentParamenterName())) {
            this.fileDocument = iContentResult;
        }
    }

    @Override
    protected void processFileContent(OHttpRequest iRequest, ORID iContentResult, HashMap<String, String> headers) throws Exception {
        if (headers.containsKey("name") && headers.get("name").equals(this.getFileParamenterName())) {
            this.fileRID = iContentResult;
            if (headers.containsKey("filename")) {
                this.fileName = headers.get("filename");
                if (this.fileName.charAt(0) == '\"') {
                    this.fileName = new String(this.fileName.substring(1));
                }
                if (this.fileName.charAt(this.fileName.length() - 1) == '\"') {
                    this.fileName = new String(this.fileName.substring(0, this.fileName.length() - 1));
                }
                this.fileType = headers.get("Content-Type");
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat formatter = this.database.getStorage().getConfiguration().getDateFormatInstance();
                this.now = cal.getTimeInMillis();
                this.writer.beginObject((Object)"uploadedFile");
                this.writer.writeAttribute(1, true, "name", (Object)this.fileName);
                this.writer.writeAttribute(1, true, "type", (Object)this.fileType);
                this.writer.writeAttribute(1, true, "date", (Object)formatter.format(cal.getTime()));
                this.writer.writeAttribute(1, true, "rid", (Object)this.fileRID);
                this.writer.endObject();
            }
        }
    }

    public boolean saveRecord(OHttpRequest iRequest, OHttpResponse iResponse) throws InterruptedException, IOException {
        if (this.fileDocument != null) {
            if (this.fileRID != null) {
                if (this.fileDocument.contains("$now")) {
                    this.fileDocument = this.fileDocument.replace("$now", String.valueOf(this.now));
                }
                if (this.fileDocument.contains("$fileName")) {
                    this.fileDocument = this.fileDocument.replace("$fileName", this.fileName);
                }
                if (this.fileDocument.contains("$fileType")) {
                    this.fileDocument = this.fileDocument.replace("$fileType", this.fileType);
                }
                if (this.fileDocument.contains("$file")) {
                    this.fileDocument = this.fileDocument.replace("$file", this.fileRID.toString());
                }
            } else {
                iResponse.send(405, "File cannot be null", "text/plain", "File cannot be null", null);
                return false;
            }
            ODocument doc = new ODocument();
            doc.fromJSON(this.fileDocument);
            doc.save();
            this.writer.beginObject((Object)"updatedDocument");
            this.writer.writeAttribute(1, true, "rid", (Object)doc.getIdentity().toString());
            this.writer.endObject();
            this.fileDocument = null;
        } else if (this.fileRID == null) {
            iResponse.send(405, "File cannot be null", "text/plain", "File cannot be null", null);
            return false;
        }
        return true;
    }

    @Override
    protected String getDocumentParamenterName() {
        return "linkValue";
    }

    @Override
    protected String getFileParamenterName() {
        return "file";
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

