/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetDatabase;
import java.io.StringWriter;
import java.io.Writer;

public class OServerCommandGetClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|class/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: class/<database>/<class-name>");
        iRequest.data.commandInfo = "Returns the information of a class in the schema";
        iRequest.data.commandDetail = urlParts[2];
        ODatabaseDocumentInternal db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().existsClass(urlParts[2])) {
                OClass cls = db.getMetadata().getSchema().getClass(urlParts[2]);
                StringWriter buffer = new StringWriter();
                OJSONWriter json = new OJSONWriter((Writer)buffer, "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments");
                OServerCommandGetDatabase.exportClass((ODatabaseDocument)db, json, cls);
                iResponse.send(200, "OK", "application/json", buffer.toString(), null);
            } else {
                iResponse.send(404, null, null, null, null);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

