/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class OAbstractDistributedConflictResolver
implements ODistributedConflictResolver {
    protected ODocument configuration;

    @Override
    public void configure(ODocument config) {
        this.configuration = config;
    }

    public static boolean compareRecords(ORawBuffer key1, ORawBuffer key2) {
        boolean matched = false;
        if (Arrays.equals(key1.buffer, key2.buffer)) {
            matched = true;
        } else if (key1.recordType == 100) {
            ODocument otherDocument;
            ODocument currentDocument = new ODocument().fromStream(key1.buffer);
            if (key2.recordType == 100 && currentDocument.hasSameContentOf(otherDocument = new ODocument().fromStream(key2.buffer))) {
                matched = true;
            }
        }
        return matched;
    }

    protected static Object getBestResult(Map<Object, List<String>> groupedResult, List<Object> exclude) {
        Object bestResult = NOT_FOUND;
        int max = -1;
        for (Map.Entry<Object, List<String>> entry : groupedResult.entrySet()) {
            boolean skip = false;
            if (exclude != null && !exclude.isEmpty()) {
                for (Object ex : exclude) {
                    if ((ex != null || entry.getKey() != null) && (ex == null || entry.getKey() == null || !ex.equals(entry.getKey()))) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || entry.getValue().size() <= max) continue;
            bestResult = entry.getKey();
            max = entry.getValue().size();
        }
        return bestResult;
    }
}

