/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.utils;

import com.ez.internal.utils.PathUtils;
import com.ez.report.generation.common.internal.Messages;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);

    public static Object instantiate(String className, Class[] p, Object[] args) {
        return Utils.instantiate(null, className, p, args);
    }

    private static Object instantiate(String bundleName, String className, Class[] p, Object[] args) {
        Object instance = null;
        try {
            Class clazz = null;
            clazz = bundleName == null ? Class.forName(className) : Platform.getBundle((String)bundleName).loadClass(className);
            if (clazz != null) {
                Constructor<?>[] ctors = clazz.getConstructors();
                Constructor<?> ctor = null;
                int i = 0;
                while (i < ctors.length) {
                    Class<?>[] params = ctors[i].getParameterTypes();
                    if (params.length == p.length) {
                        int j = 0;
                        while (j < p.length) {
                            if (!params[j].equals(p[j])) break;
                            ++j;
                        }
                        if (j == p.length) {
                            ctor = ctors[i];
                            break;
                        }
                    }
                    ++i;
                }
                if (ctor != null) {
                    instance = ctor.newInstance(args);
                } else {
                    L.warn("no constructor found for class {}", (Object)clazz);
                }
            } else {
                L.error("class {} could not be loaded", (Object)className);
            }
        }
        catch (Exception e) {
            L.error("dynamically loading class", (Throwable)e);
        }
        return instance;
    }

    public static InputStream getDefaultLogo() {
        return Utils.class.getClassLoader().getResourceAsStream("icons/reportHeaderIBM2.png");
    }

    public static InputStream getResourceStreamFromPlugin(String resourcePath, String bundleName) {
        InputStream stream = null;
        bundleName = bundleName == null ? "com.ez.jasperreports" : bundleName;
        URL fullPathString = null;
        try {
            Bundle bundle = Platform.getBundle((String)bundleName);
            fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(resourcePath), null);
        }
        catch (Throwable ex) {
            L.debug("not in eclipse: {}", (Object)ex.getMessage());
        }
        if (fullPathString == null) {
            try {
                fullPathString = new URL(resourcePath);
            }
            catch (MalformedURLException e) {
                L.debug("error at getting resource stream for a report template: {}; {}", (Object)resourcePath, (Object)e.getMessage());
            }
        }
        if (fullPathString != null) {
            try {
                stream = fullPathString.openStream();
            }
            catch (IOException e) {
                L.debug("error at getting resource stream for report template:{}; {} ", (Object)resourcePath, (Object)e.getMessage());
            }
        } else {
            L.trace("template report not found in bundles: {}", (Object)resourcePath);
            stream = Utils.class.getClassLoader().getResourceAsStream(resourcePath);
        }
        if (stream != null) {
            L.trace("found it!! {}", (Object)resourcePath);
        } else {
            String err = "template report not found: " + resourcePath;
            if (bundleName != null && !bundleName.isEmpty()) {
                err = String.valueOf(err) + " in bundle " + bundleName;
            }
            L.error(err);
        }
        return stream;
    }

    public static InputStream getResourceStreamFromPlugin(String resourcePath) {
        return Utils.getResourceStreamFromPlugin(resourcePath, null);
    }

    public static String getEscapeTextFor(String text) {
        return ReportsUtils.stripNonValidXMLCharacters(text, true);
    }

    public static void setParamsForTitle(Map<String, Object> params, Map<String, Object> inputs) {
        if (inputs == null || inputs.isEmpty()) {
            L.error("no inputs!!");
        } else {
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            InputStream is = (InputStream)inputs.get("report image header");
            params.put("logoImg", is);
            params.put("title.orgValue", inputs.get("organization"));
            params.put("title.col1Value", inputs.get("owner"));
            params.put("title.col2Value", inputs.get("organization_role"));
            params.put("title.orgName", Messages.getString(Utils.class, "organization.title"));
            params.put("title.dateLb", Messages.getString(Utils.class, "dateLabel.title"));
            params.put("tableHead", Messages.getString(Utils.class, "label.title"));
            params.put("titleCol1", Messages.getString(Utils.class, "owner.title"));
            params.put("titleCol2", Messages.getString(Utils.class, "roleLabel.title"));
        }
    }

    public static boolean putSubreportStream(String templateFilePath, String parameterName, Map parameters) {
        boolean added = false;
        InputStream stream = Utils.getResourceStreamFromPlugin(templateFilePath);
        added = Utils.putSubreportParam(stream, parameterName, parameters);
        if (!added) {
            L.info("stream for template {} not added!", (Object)templateFilePath);
        }
        return added;
    }

    public static boolean putSubreportParam(InputStream stream, String parameterName, Map parameters) {
        boolean added = false;
        if (stream != null) {
            try {
                JasperReport jasperReport = Utils.loadReport(stream);
                if (jasperReport != null) {
                    parameters.put(parameterName, jasperReport);
                    added = true;
                } else {
                    L.warn("cannot load template for parameter: {}", (Object)parameterName);
                }
            }
            catch (JRException e) {
                L.error("error at loading template for parameter: {}", (Object)parameterName, (Object)e);
            }
        }
        return added;
    }

    public static JasperReport loadReport(InputStream stream) throws JRException {
        JasperReport jasperReport = null;
        if (stream != null) {
            jasperReport = (JasperReport)JRLoader.loadObject((InputStream)stream);
        }
        return jasperReport;
    }

    public static JasperReport loadReport(String templatePath) throws JRException {
        JasperReport jReport = null;
        InputStream rs = Utils.getResourceStreamFromPlugin(templatePath);
        jReport = Utils.loadReport(rs);
        return jReport;
    }

    public static void exportFile(String exportedFile, File file, String sourcePath) throws IOException {
        Utils.exportFile(exportedFile, file, sourcePath, true);
    }

    public static void exportFile(String exportedFile, File file, String sourcePath, boolean useGraphsDir) throws IOException {
        if (sourcePath == null) {
            if (useGraphsDir) {
                sourcePath = Utils.getGraphsDirectory().concat(exportedFile);
            } else {
                L.error("no source path specified!");
            }
        } else {
            if (exportedFile.startsWith("./")) {
                exportedFile = exportedFile.substring(2);
            }
            int lastSep = file.getAbsolutePath().lastIndexOf(File.separator);
            String fPath = file.getAbsolutePath().substring(0, lastSep);
            String destPath = fPath.concat(File.separator).concat(exportedFile);
            File destFile = new File(destPath);
            Utils.copyResource(sourcePath, destFile);
            L.info("file {} was copied into {}", (Object)sourcePath, (Object)destFile);
        }
    }

    private static void copyResource(String sourceProjectPath, File destFile) throws IOException {
        byte[] buf = new byte[2048];
        URL sourceURL = new File(sourceProjectPath).toURI().toURL();
        InputStream sStream = sourceURL.openStream();
        BufferedInputStream in = new BufferedInputStream(sStream);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
        int read = in.read(buf);
        while (read != -1) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
        out.close();
        in.close();
        sStream.close();
    }

    public static String getGraphsDirectory() {
        File GRAPHS_PATH_FOLDER = new File(String.valueOf(PathUtils.METADATA_FOLDER.getAbsolutePath()) + File.separator + "graphs" + File.separator);
        if (!GRAPHS_PATH_FOLDER.exists()) {
            GRAPHS_PATH_FOLDER.mkdirs();
        }
        String path = String.valueOf(GRAPHS_PATH_FOLDER.getAbsolutePath()) + File.separator;
        return path;
    }
}

