/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.utils;

import com.ez.report.generation.common.internal.Activator;
import com.ez.report.generation.common.model.HeadingBean;
import com.ez.report.generation.common.scriptlets.HeadingsScriptlet;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintLine;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportsUtils.class);
    public static final String LANGUAGE_PARAMETER = "language";
    public static final String LANGUAGE_PARAM_JAPANESE = "JA";
    public static final String LANGUAGE_PARAM_CHINESE = "ZH";
    public static final String LANGUAGE_PARAM_CHINESE_TRADITIONAL = "ZH_TW";
    public static final String LANGUAGE_PARAM_KOREAN = "KO";
    public static final int BLOCK_SIZE = 1024;
    public static final int MIN_GROTH_COUNT = 512;
    public static final int MAX_CACHED_PAGES = 100;
    public static final String pageNrKey = "txtPage";
    public static final String countingFrameKey = "frmPageNr";
    private static final String countingFrameLineKey = "line";
    public static final String totalPagesNrKey = "txtTotalPages";
    public static final String NON_PRINTING_CHAR_MARKER = ".";
    public static final String HEADINGS_TEMPLATE_PARAMETERNAME = "headingsTemplate";
    public static final String HEADINGS_TEMPLATE_PARAMETER_EZVALUE = "reports/HeadingsReport.jasper";
    public static final String HEADINGS_TEMPLATE_PARAMETER_STRETCH = "reports/HeadingsReportWithFrame.jasper";
    public static final String SCRIPTLET_PARAMETERNAME = "scriptlet";
    public static final String LIMIT_RESTRICTION_MARKER = " *";
    public static final String NAME_RESTRICTION_MARKER = " !";
    public static final String ASIAN_LANGUAGE_PARAMETER = "asian_language";
    private static final String JA_FONTNAME = "HeiseiKakuGo-W5";
    private static final String KO_FONTNAME = "HYGoThic-Medium";
    private static final String ZH_TW_FONTNAME = "MSung-Light";
    private static final String ZH_FONTNAME = "STSong-Light";

    private static void changePageNumber(JasperPrint jasperPrint, JRPrintPage pageToDelete, int moved, boolean useAnchorIndexes) {
        String appendixKey = "txtAppendix";
        String appendixAnchor = HeadingBean.replaceIllegalForHiperlink("appendix");
        int appendixPage = 0;
        List pages = jasperPrint.getPages();
        int j = moved + 1;
        while (j < pages.size()) {
            JRPrintPage page = (JRPrintPage)pages.get(j);
            List elements = page.getElements();
            boolean found = false;
            boolean appendixFound = false;
            if (elements != null && elements.size() > 0 && !found) {
                Iterator it = elements.iterator();
                block1: while (it.hasNext() && !found) {
                    JRPrintElement element = (JRPrintElement)it.next();
                    if (element instanceof JRTemplatePrintFrame && countingFrameKey.equalsIgnoreCase(element.getKey())) {
                        List els = ((JRTemplatePrintFrame)element).getElements();
                        for (Object elem : els) {
                            int newValue;
                            String str;
                            if (!(elem instanceof JRPrintText)) continue;
                            if (pageNrKey.equals(((JRPrintText)elem).getKey())) {
                                str = ((JRPrintText)elem).getFullText();
                                int initPage = Integer.valueOf(str);
                                newValue = initPage + moved;
                                L.debug("counter of page " + initPage + " changed to " + String.valueOf(newValue));
                                ((JRPrintText)elem).setText(String.valueOf(newValue));
                                if (appendixFound) {
                                    appendixPage = newValue;
                                    L.debug("appendixPage was modified to " + appendixPage);
                                }
                                found = true;
                                if (pageToDelete != null) continue;
                                continue block1;
                            }
                            if (!totalPagesNrKey.equals(((JRPrintText)elem).getKey())) continue;
                            str = ((JRPrintText)elem).getFullText();
                            int initValue = Integer.valueOf(str);
                            newValue = initValue - 1;
                            L.debug("total nr changed from " + initValue + " to " + String.valueOf(newValue));
                            ((JRPrintText)elem).setText(String.valueOf(newValue));
                            if (found) continue block1;
                        }
                        continue;
                    }
                    if (!(element instanceof JRPrintText) || !appendixKey.equals(((JRPrintText)element).getKey())) continue;
                    appendixPage = j + 1;
                    appendixFound = true;
                    L.debug("appendix found at page " + j);
                    if (found) break;
                }
            }
            ++j;
        }
        ReportsUtils.changeNumbersInTOC(jasperPrint, moved, appendixAnchor, appendixPage, useAnchorIndexes);
    }

    private static void changeNumbersInTOC(JasperPrint jasperPrint, int moved, String appendixAnchor, int appendixPage, boolean useAnchorIndexes) {
        List pages = jasperPrint.getPages();
        Map anchors = jasperPrint.getAnchorIndexes();
        int j = 1;
        while (j < moved + 1) {
            JRPrintPage page = (JRPrintPage)pages.get(j);
            List elements = page.getElements();
            if (elements != null && elements.size() > 0) {
                for (JRPrintElement element2 : elements) {
                    if (element2 instanceof JRTemplatePrintFrame && element2.getKey().startsWith("frameHeading")) {
                        List els = ((JRTemplatePrintFrame)element2).getElements();
                        for (JRPrintElement element2 : els) {
                            ReportsUtils.checkElement(moved, appendixAnchor, appendixPage, useAnchorIndexes, element2, anchors);
                        }
                        continue;
                    }
                    ReportsUtils.checkElement(moved, appendixAnchor, appendixPage, useAnchorIndexes, element2, anchors);
                }
            }
            ++j;
        }
    }

    private static void checkElement(int moved, String appendixAnchor, int appendixPage, boolean useAnchorIndexes, JRPrintElement element, Map anchors) {
        if (element instanceof JRPrintText && pageNrKey.equals(((JRPrintText)element).getKey())) {
            String anchor = ((JRPrintText)element).getHyperlinkAnchor();
            JRPrintAnchorIndex anchIdx = (JRPrintAnchorIndex)anchors.get(anchor);
            int initPage = -1;
            String newValue = "";
            String str = ((JRPrintText)element).getFullText();
            initPage = Integer.valueOf(str);
            int pg = anchIdx != null ? anchIdx.getPageIndex() + 1 : -1;
            int newNr = useAnchorIndexes && pg > -1 ? pg : initPage + moved;
            L.debug("anchName: " + anchor + " useAnchorPage=" + pg + " ;;; pg=" + (initPage + moved));
            newValue = String.valueOf(newNr);
            if (appendixPage != 0 && anchor.equalsIgnoreCase(appendixAnchor)) {
                L.debug("appendix page found in TOC");
                if (newNr != appendixPage) {
                    newValue = String.valueOf(appendixPage);
                }
            }
            ((JRPrintText)element).setText(String.valueOf(newValue));
            L.debug("page number [" + initPage + "] from TOC was changed to: [" + newValue + "]");
        }
    }

    public static String prepareTooltip(String tooltip) {
        if (tooltip == null || "".equals(tooltip)) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < tooltip.length()) {
            char current = tooltip.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                if (current == '&') {
                    out.append("&&");
                } else {
                    out.append(current);
                }
            } else {
                char intValue = current;
                L.debug("int value of a non-printable char in tooltip: " + intValue);
                out.append(NON_PRINTING_CHAR_MARKER);
            }
            ++i;
        }
        return out.toString();
    }

    public static String stripNonValidXMLCharacters(String in, boolean ignoreNewLine) {
        StringBuffer out = new StringBuffer();
        boolean currentStringHasNonPrintChar = false;
        if (in == null || "".equals(in)) {
            return "";
        }
        int i = 0;
        while (i < in.length()) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                if (current == '&') {
                    out.append("&amp;");
                } else if (current == '>') {
                    out.append("&gt;");
                } else if (current == '<') {
                    out.append("&lt;");
                } else if (current == '\"') {
                    out.append("&quot;");
                } else {
                    if (!ignoreNewLine) {
                        if (current == '\n') {
                            out.append("LF");
                        } else if (current == '\r') {
                            out.append("CR");
                        }
                    }
                    out.append(current);
                }
            } else {
                char intValue = current;
                L.debug("int value of a non-printable char: " + intValue);
                currentStringHasNonPrintChar = true;
                out.append(NON_PRINTING_CHAR_MARKER);
            }
            ++i;
        }
        return out.toString();
    }

    public static void moveTableOfContents(JasperPrint jasperPrint) {
        ReportsUtils.moveTableOfContents(jasperPrint, false);
    }

    public static void moveTableOfContents(JasperPrint jasperPrint, boolean useAnchorIndexes) {
        if (jasperPrint != null) {
            List pages = jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                L.trace("moveTableOfContents(); pages.size=" + pages.size());
                JRPrintPage pageToDelete = null;
                String key = "hiddenTxt";
                JRPrintPage page2 = null;
                List elements = null;
                Iterator it = null;
                JRPrintElement element = null;
                int i = pages.size() - 1;
                boolean isFound = false;
                while (i >= 0 && !isFound) {
                    page2 = (JRPrintPage)pages.get(i);
                    elements = page2.getElements();
                    if (elements != null && elements.size() > 0) {
                        it = elements.iterator();
                        while (it.hasNext() && !isFound) {
                            element = (JRPrintElement)it.next();
                            if (!(element instanceof JRPrintText) || !key.equals(((JRPrintText)element).getKey())) continue;
                            isFound = true;
                            break;
                        }
                    }
                    --i;
                }
                if (isFound) {
                    L.debug("move pages from " + (i + 1) + " to " + pages.size());
                    int moved = 0;
                    int indexToAdd = 0;
                    pageToDelete = (JRPrintPage)pages.get(i);
                    List elems = pageToDelete.getElements();
                    if (elems.size() > 0) {
                        if (elems.size() != 1) {
                            pageToDelete = null;
                        } else {
                            for (Object obj : elems) {
                                if (obj instanceof JRTemplatePrintRectangle) continue;
                                pageToDelete = null;
                            }
                        }
                    }
                    int j = i + 1;
                    while (j < pages.size()) {
                        indexToAdd = j - i;
                        jasperPrint.addPage(indexToAdd, jasperPrint.removePage(j));
                        ++moved;
                        ++j;
                    }
                    if (moved != 0) {
                        ReportsUtils.changePageNumber(jasperPrint, pageToDelete, moved, useAnchorIndexes);
                    } else {
                        boolean found = false;
                        for (JRPrintPage page2 : pages) {
                            elements = page2.getElements();
                            if (elements == null) continue;
                            Iterator iterator2 = elements.iterator();
                            block5: while (iterator2.hasNext() && !found) {
                                element = (JRPrintElement)iterator2.next();
                                if (!(element instanceof JRTemplatePrintFrame) || !countingFrameKey.equalsIgnoreCase(element.getKey())) continue;
                                List els = ((JRTemplatePrintFrame)element).getElements();
                                Iterator iterator3 = els.iterator();
                                while (iterator3.hasNext() && !found) {
                                    Object obj = iterator3.next();
                                    if (!(obj instanceof JRPrintText) || !totalPagesNrKey.equals(((JRPrintText)obj).getKey())) continue;
                                    String str = ((JRPrintText)obj).getFullText();
                                    int initPage = Integer.valueOf(str);
                                    int newValue = initPage - 1;
                                    L.debug("total nr of pages changed from " + initPage + " to " + String.valueOf(newValue) + " (empty last page removed)");
                                    ((JRPrintText)obj).setText(String.valueOf(newValue));
                                    found = true;
                                    continue block5;
                                }
                            }
                        }
                    }
                } else {
                    L.trace("hiddentxt (start of TOC subreport) not found!");
                }
                if (pageToDelete != null) {
                    L.debug("remove a final blank page " + pageToDelete);
                    pages.remove(pageToDelete);
                } else {
                    L.debug("blank page do not exist at the end of the report");
                }
            } else {
                L.trace("moveTOC(); no pages in report");
            }
        }
    }

    private static void changeFileNumbers(List pages) {
        int totalNr = pages.size();
        int pageNr = 0;
        for (JRPrintPage page : pages) {
            List elements = page.getElements();
            ++pageNr;
            boolean found = false;
            if (elements == null || elements.size() <= 0 || found) continue;
            Iterator it = elements.iterator();
            block1: while (it.hasNext() && !found) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (!(element instanceof JRTemplatePrintFrame) || !countingFrameKey.equalsIgnoreCase(element.getKey())) continue;
                List els = ((JRTemplatePrintFrame)element).getElements();
                for (Object elem : els) {
                    int newValue;
                    String str;
                    if (!(elem instanceof JRPrintText)) continue;
                    if (totalPagesNrKey.equals(((JRPrintText)elem).getKey())) {
                        str = ((JRPrintText)elem).getFullText();
                        int initValue = Integer.valueOf(str);
                        newValue = totalNr;
                        L.debug("total nr changed from " + initValue + " to " + String.valueOf(newValue));
                        ((JRPrintText)elem).setText(String.valueOf(newValue));
                        if (!found) continue;
                        continue block1;
                    }
                    if (!pageNrKey.equals(((JRPrintText)elem).getKey())) continue;
                    str = ((JRPrintText)elem).getFullText();
                    int initPage = Integer.valueOf(str);
                    newValue = pageNr;
                    L.debug("counter of page " + initPage + " changed to " + String.valueOf(newValue));
                    ((JRPrintText)elem).setText(String.valueOf(newValue));
                    found = true;
                }
            }
        }
    }

    public static void removeEmptyPages(List pages, String reportName) {
        ReportsUtils.removeEmptyPages(pages, reportName, false);
    }

    public static void removeEmptyPages(List pages, String reportName, boolean mustRecount) {
        ArrayList<JRPrintPage> pagesToRemove = new ArrayList<JRPrintPage>();
        for (JRPrintPage page : pages) {
            boolean hasElements = false;
            if (page.getElements() != null && !page.getElements().isEmpty()) {
                Iterator iterator2 = page.getElements().iterator();
                while (iterator2.hasNext() && !hasElements) {
                    Object object = iterator2.next();
                    if (object instanceof JRTemplatePrintFrame) {
                        JRTemplatePrintFrame frame = (JRTemplatePrintFrame)object;
                        hasElements = frame.getElements() != null && !frame.getElements().isEmpty();
                        if (!countingFrameKey.equalsIgnoreCase(frame.getKey()) || page.getElements().size() != 2) continue;
                        hasElements = false;
                        mustRecount = true;
                        continue;
                    }
                    if (object instanceof JRTemplatePrintRectangle) {
                        hasElements = false;
                        continue;
                    }
                    if (object instanceof JRTemplatePrintLine && countingFrameLineKey.equals(((JRTemplatePrintLine)object).getKey())) continue;
                    hasElements = true;
                }
            }
            if (hasElements) continue;
            pagesToRemove.add(page);
        }
        if (!pagesToRemove.isEmpty()) {
            pages.removeAll(pagesToRemove);
            L.debug("removed {} empty page(s) from report: {}", (Object)pagesToRemove.size(), (Object)reportName);
            if (mustRecount) {
                ReportsUtils.changeFileNumbers(pages);
            }
        }
    }

    public static void addScriptlet(Map parameters, String className, ClassLoader loader) {
        try {
            if (className == null || className.isEmpty()) {
                className = HeadingsScriptlet.class.getName();
                loader = Activator.class.getClassLoader();
                L.info("didn't specified scriptlet class; default it will be used, the same for loader!");
            }
            JRAbstractScriptlet scriptlet = ReportsUtils.instantiateScriptlet(className, loader);
            parameters.put("REPORT_SCRIPTLET", scriptlet);
        }
        catch (JRException e) {
            L.error("cannot instantiate scriptlet " + className, (Throwable)e);
        }
    }

    private static JRAbstractScriptlet instantiateScriptlet(String scriptletClassName, ClassLoader loader) throws JRException {
        JRAbstractScriptlet scriptlet = null;
        try {
            Class<?> scriptletClass = loader.loadClass(scriptletClassName);
            L.debug(String.valueOf(scriptletClassName) + " scriptlet found");
            scriptlet = (JRAbstractScriptlet)scriptletClass.newInstance();
            L.debug(String.valueOf(scriptletClassName) + " scriptlet instantiated");
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Error loading scriptlet class : " + scriptletClassName, (Throwable)e);
        }
        catch (Exception e) {
            throw new JRException("Error creating scriptlet class instance : " + scriptletClassName, (Throwable)e);
        }
        return scriptlet;
    }

    public static void addLocaleParameter(Map params) {
        Locale loc = Locale.getDefault();
        L.info("locale: {}", (Object)loc);
        if (Locale.JAPANESE.getLanguage().equals(loc.getLanguage())) {
            params.put(LANGUAGE_PARAMETER, LANGUAGE_PARAM_JAPANESE);
        } else if (Locale.KOREAN.getLanguage().equals(loc.getLanguage())) {
            params.put(LANGUAGE_PARAMETER, LANGUAGE_PARAM_KOREAN);
        } else if (Locale.TRADITIONAL_CHINESE.equals(loc)) {
            params.put(LANGUAGE_PARAMETER, LANGUAGE_PARAM_CHINESE_TRADITIONAL);
        } else if (Locale.CHINESE.getLanguage().equals(loc.getLanguage())) {
            params.put(LANGUAGE_PARAMETER, LANGUAGE_PARAM_CHINESE);
        }
        L.info("report language parameter: {}", params.get(LANGUAGE_PARAMETER));
    }

    public static String getFontName(Locale loc) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String ret = JA_FONTNAME;
        if (Locale.KOREAN.getLanguage().equals(loc.getLanguage())) {
            ret = KO_FONTNAME;
        } else if (Locale.TRADITIONAL_CHINESE.equals(loc)) {
            ret = ZH_TW_FONTNAME;
        } else if (Locale.CHINESE.getLanguage().equals(loc.getLanguage())) {
            ret = ZH_FONTNAME;
        }
        L.trace("locale: {}, font name: {}", (Object)loc, (Object)ret);
        return ret;
    }

    public static Font getFont(Locale loc, int size, boolean bold) {
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String fontName = ReportsUtils.getFontName(loc);
        Font ret = new Font(fontName, bold ? 1 : 0, size);
        L.trace("locale: {}, font: {}", (Object)loc, (Object)ret);
        return ret;
    }

    public static void preCustomizePrint(JasperReport jReport, Map params) {
        String asianLang;
        if (jReport != null && (asianLang = (String)params.get(ASIAN_LANGUAGE_PARAMETER)) != null) {
            HashSet<JRStyle> toCheck = new HashSet<JRStyle>();
            for (Object v : params.values()) {
                if (!(v instanceof JasperReport)) continue;
                toCheck.addAll(Arrays.asList(((JasperReport)v).getStyles()));
            }
            JRStyle[] styles = jReport.getStyles();
            if (styles != null && styles.length > 0) {
                toCheck.addAll(Arrays.asList(styles));
            }
            HashSet<JRConditionalStyle> customStyles = new HashSet<JRConditionalStyle>();
            for (JRStyle jRStyle : toCheck) {
                if (!"languageStyle".equalsIgnoreCase(jRStyle.getName())) continue;
                customStyles.addAll(Arrays.asList(jRStyle.getConditionalStyles()));
            }
            if (!customStyles.isEmpty()) {
                for (JRStyle jRStyle : customStyles) {
                    L.trace("style name: " + jRStyle.getName());
                    jRStyle.setPdfEmbedded(Boolean.valueOf(true));
                    String pdfFont = null;
                    String pdfEncoding = "UTF-8";
                    if (Locale.CHINESE.getLanguage().equals(asianLang)) {
                        pdfFont = ZH_FONTNAME;
                        pdfEncoding = "UniGB-UCS2-H";
                    } else if (Locale.KOREAN.getLanguage().equals(asianLang)) {
                        pdfFont = KO_FONTNAME;
                        pdfEncoding = "UniKS-UCS2-H";
                    }
                    if (pdfFont != null) {
                        jRStyle.setPdfFontName(pdfFont);
                    }
                    jRStyle.setPdfEncoding(pdfEncoding);
                }
            } else {
                L.warn("conditional language style not found!");
            }
        }
    }
}

